/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.wizardry;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.wizardry.Huffman;
import java.util.ArrayList;
import java.util.List;

class MessageDataBlock
extends AbstractFile {
    final int firstMessageNo;
    final int lastMessageNo;
    private final int groupCount;
    private final List<Message> messages = new ArrayList<Message>();
    private final Huffman huffman;

    MessageDataBlock(String name, byte[] buffer, int firstMessageNo, Huffman huffman) {
        super(name, buffer);
        this.firstMessageNo = firstMessageNo;
        this.huffman = huffman;
        int ptr = 511;
        this.groupCount = buffer[ptr--] & 0xFF;
        int currentMessageNo = firstMessageNo;
        int totalMessageBytes = firstMessageNo == 1 ? 4 : 0;
        int i = 0;
        int max = this.groupCount - 1;
        while (i < this.groupCount) {
            int huffBytes = buffer[ptr];
            int j = 0;
            while (j < huffBytes) {
                int messageLength = buffer[ptr - j - 1] & 0xFF;
                Message message = new Message(currentMessageNo + j, (totalMessageBytes += messageLength) - messageLength, messageLength);
                this.messages.add(message);
                ++j;
            }
            ptr -= huffBytes;
            currentMessageNo += huffBytes;
            --ptr;
            if (max > 0) {
                byte gap = buffer[ptr--];
                int skip = gap & 0xFF;
                if ((gap & 0x80) != 0) {
                    gap = (byte)(gap & 0x7F);
                    int gap2 = buffer[ptr--] & 0xFF;
                    skip = gap * 256 + gap2;
                }
                currentMessageNo += --skip;
            }
            ++i;
            --max;
        }
        this.lastMessageNo = currentMessageNo > firstMessageNo ? currentMessageNo - 1 : firstMessageNo;
        this.setName(String.valueOf(this.getName()) + " - " + this.lastMessageNo);
    }

    byte[] getMessage(int messageNo) {
        for (Message message : this.messages) {
            if (message.msgNo != messageNo) continue;
            byte[] returnMessage = new byte[message.length];
            System.arraycopy(this.buffer, message.offset, returnMessage, 0, message.length);
            return returnMessage;
        }
        return null;
    }

    String getText(int messageNo) {
        for (Message message : this.messages) {
            if (message.msgNo != messageNo) continue;
            byte[] returnMessage = new byte[message.length];
            System.arraycopy(this.buffer, message.offset, returnMessage, 0, message.length);
            return this.huffman.decodeMessage(returnMessage);
        }
        return null;
    }

    @Override
    public String getText() {
        if (this.messages.size() == 0) {
            return "No Messages";
        }
        if (this.huffman == null) {
            return this.toString();
        }
        StringBuilder text = new StringBuilder();
        int lastMessageNo = this.messages.get((int)0).msgNo - 1;
        for (Message message : this.messages) {
            if (message.msgNo != lastMessageNo + 1) {
                text.append("\n");
            }
            lastMessageNo = message.msgNo;
            byte[] returnMessage = new byte[message.length];
            System.arraycopy(this.buffer, message.offset, returnMessage, 0, message.length);
            text.append(String.format("%5d  %s%n", message.msgNo, this.huffman.decodeMessage(returnMessage)));
        }
        if (text.length() > 0) {
            text.deleteCharAt(text.length() - 1);
        }
        return text.toString();
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        for (Message message : this.messages) {
            text.append(message);
            text.append("\n");
        }
        if (text.length() > 0) {
            text.deleteCharAt(text.length() - 1);
        }
        return text.toString();
    }

    class Message {
        final int msgNo;
        final int offset;
        final int length;

        public Message(int msgNo, int offset, int length) {
            this.msgNo = msgNo;
            this.offset = offset;
            this.length = length;
        }

        public String toString() {
            StringBuilder text = new StringBuilder();
            String data = HexFormatter.format(MessageDataBlock.this.buffer, this.offset, this.length);
            text.append(String.format("%5d: %03X  %02X : %s", this.msgNo, this.offset, this.length, data));
            return text.toString();
        }
    }
}

