/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.wizardry;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.utilities.Utility;
import com.bytezone.diskbrowser.wizardry.Huffman;
import com.bytezone.diskbrowser.wizardry.MessageDataBlock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class MessageBlock
extends AbstractFile
implements Iterable<MessageDataBlock> {
    private final int indexOffset;
    private final int indexLength;
    private String text;
    private final List<MessageDataBlock> messageDataBlocks = new ArrayList<MessageDataBlock>();

    MessageBlock(byte[] buffer, Huffman huffman) {
        super("bollocks", buffer);
        this.indexOffset = Utility.getShort(buffer, 0);
        this.indexLength = Utility.getShort(buffer, 2);
        int ptr = this.indexOffset * 512;
        int i = 0;
        int max = this.indexLength / 2;
        while (i < max) {
            int firstMessageNo = Utility.getShort(buffer, ptr + i * 2);
            byte[] data = new byte[512];
            System.arraycopy(buffer, i * 512, data, 0, data.length);
            MessageDataBlock messageDataBlock = new MessageDataBlock(" Message " + firstMessageNo, data, firstMessageNo, huffman);
            this.messageDataBlocks.add(messageDataBlock);
            ++i;
        }
    }

    public String getMessageText(int messageNo) {
        int i = 0;
        while (i < this.messageDataBlocks.size()) {
            MessageDataBlock messageDataBlock = this.messageDataBlocks.get(i);
            if (messageDataBlock.lastMessageNo >= messageNo) {
                return messageDataBlock.getText(messageNo);
            }
            ++i;
        }
        return null;
    }

    public List<String> getMessageLines(int messageNo) {
        ArrayList<String> lines = new ArrayList<String>();
        for (MessageDataBlock messageDataBlock : this.messageDataBlocks) {
            String message;
            if (messageNo > messageDataBlock.lastMessageNo) continue;
            if (messageNo < messageDataBlock.firstMessageNo) break;
            while ((message = messageDataBlock.getText(messageNo)) != null) {
                lines.add(message);
                ++messageNo;
            }
        }
        return lines;
    }

    public byte[] getMessage(int messageNo) {
        int i = 0;
        while (i < this.messageDataBlocks.size()) {
            MessageDataBlock messageDataBlock = this.messageDataBlocks.get(i);
            if (messageDataBlock.firstMessageNo > messageNo) {
                return this.messageDataBlocks.get(i - 1).getMessage(messageNo);
            }
            ++i;
        }
        return null;
    }

    @Override
    public String getText() {
        if (this.text != null) {
            return this.text;
        }
        StringBuilder text = new StringBuilder();
        for (MessageDataBlock mdb : this.messageDataBlocks) {
            text.append(mdb);
            text.append("\n");
        }
        this.text = text.toString();
        return this.text;
    }

    @Override
    public Iterator<MessageDataBlock> iterator() {
        return this.messageDataBlocks.iterator();
    }
}

