/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.wizardry;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.utilities.Utility;
import com.bytezone.diskbrowser.wizardry.Item;
import com.bytezone.diskbrowser.wizardry.MazeAddress;
import com.bytezone.diskbrowser.wizardry.MazeCell;
import com.bytezone.diskbrowser.wizardry.Message;
import com.bytezone.diskbrowser.wizardry.Monster;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class MazeLevel
extends AbstractFile {
    private static final int AUX0 = 768;
    private static final int AUX1 = 800;
    private static final int AUX2 = 832;
    private static final String[] squareType = new String[]{"Normal", "Stairs", "Pit", "Chute", "Spinner", "Darkness", "Teleport", "Ouch", "Elevator", "Rock/Water", "Fizzle", "Message/Item", "Monster"};
    public final int level;
    private List<Message> messages;
    private List<Monster> monsters;
    private List<Item> items;

    public MazeLevel(byte[] buffer, int level) {
        super("Level " + level, buffer);
        this.level = level;
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        text.append("West walls/doors\n\n");
        text.append(HexFormatter.format(this.buffer, 0, 120, true, 0));
        this.addWalls(text, 0);
        text.append("\nSouth walls/doors\n\n");
        text.append(HexFormatter.format(this.buffer, 120, 120, true, 120));
        this.addWalls(text, 120);
        text.append("\nEast walls/doors\n\n");
        text.append(HexFormatter.format(this.buffer, 240, 120, true, 240));
        this.addWalls(text, 240);
        text.append("\nNorth walls/doors\n\n");
        text.append(HexFormatter.format(this.buffer, 360, 120, true, 360));
        this.addWalls(text, 360);
        text.append("\nFIGHTS\n\n");
        text.append(HexFormatter.format(this.buffer, 480, 80, true, 480));
        this.addEncounters(text, 480);
        text.append("\nSQREXTRA\n\n");
        text.append(HexFormatter.format(this.buffer, 560, 200, true, 560));
        this.addExtras(text, 560);
        text.append("\nSQRTYPE\n\n");
        text.append(String.format("%04X: %s%n", 760, HexFormatter.getHexString(this.buffer, 760, 8)));
        text.append("\nAUX0\n\n");
        text.append(HexFormatter.format(this.buffer, 768, 32, true, 768));
        text.append("\n");
        text.append("\nAUX1\n\n");
        text.append(HexFormatter.format(this.buffer, 800, 32, true, 800));
        text.append("\n");
        text.append("\nAUX2\n\n");
        text.append(HexFormatter.format(this.buffer, 832, 32, true, 832));
        text.append("\n");
        ArrayList<MazeAddress> messageList = new ArrayList<MazeAddress>();
        ArrayList<MazeAddress> monsterList = new ArrayList<MazeAddress>();
        this.addTable(text, messageList, monsterList);
        text.append("\n\nENMYCALC\n\n");
        text.append(HexFormatter.format(this.buffer, 864, this.buffer.length - 864, true, 864));
        this.addEnmyCalc(text, 864);
        text.append("\n\n");
        for (MazeAddress address : messageList) {
            Message message = this.getMessage(address.row);
            if (message == null) continue;
            text.append(String.format("%nMessage: %04X  (%d)%n", address.row, address.row));
            text.append(message.getText());
            text.append("\n");
        }
        for (MazeAddress address : monsterList) {
            Monster monster = this.getMonster(address.column);
            if (monster == null) continue;
            text.append(String.format("%nMonster: %04X%n", address.column));
            text.append(monster.getText());
            text.append("\n");
        }
        return text.toString();
    }

    private void addWalls(StringBuilder text, int ptr) {
        text.append("\n\n");
        int col = 0;
        while (col < 20) {
            text.append(String.format("   Col %2d : %s : ", col, HexFormatter.getHexString(this.buffer, ptr, 6)));
            int i = 0;
            while (i < 5) {
                int val = this.buffer[ptr++] & 0xFF;
                int j = 0;
                while (j < 4) {
                    int wall = val & 3;
                    text.append(String.format("%d ", wall));
                    val >>>= 2;
                    ++j;
                }
                ++i;
            }
            ++ptr;
            text.append("\n");
            ++col;
        }
    }

    private void addEncounters(StringBuilder text, int ptr) {
        text.append("\n\n");
        int i = 0;
        while (i < 20) {
            text.append(String.format("  Col %2d: %s  ", i, HexFormatter.getHexString(this.buffer, ptr + i * 4, 4)));
            int val = Utility.readTriple(this.buffer, ptr + i * 4);
            int j = 0;
            while (j < 20) {
                text.append((val & 1) == 0 ? "  " : " 1");
                val >>>= 1;
                ++j;
            }
            text.append("\n");
            ++i;
        }
    }

    private void addExtras(StringBuilder text, int ptr) {
        text.append("\n\n");
        int i = 0;
        while (i < 20) {
            text.append(String.format("  Col %2d:  ", i));
            int j = 0;
            while (j < 10) {
                int val = this.buffer[ptr++] & 0xFF;
                int left = (val & 0xF0) >> 4;
                int right = val & 0xF;
                String sLeft = left == 0 ? " " : String.format("%X", left);
                String sRight = right == 0 ? " " : String.format("%X", right);
                text.append(String.format("%s %s ", sRight, sLeft));
                ++j;
            }
            text.append("\n");
            ++i;
        }
    }

    private void addTable(StringBuilder text, List<MazeAddress> messageList, List<MazeAddress> monsterList) {
        text.append("\n\nSQREXTRA  SQRTYPE   TSQUARE           AUX0  AUX1  AUX2\n");
        int j = 0;
        while (j < 16) {
            int cellFlag;
            String extraText = "";
            int val = this.buffer[760 + j / 2] & 0xFF;
            String extra = j % 2 == 0 ? squareType[val % 16] : squareType[val / 16];
            MazeAddress address = this.getAddress(j);
            int n = cellFlag = j % 2 == 0 ? val % 16 : val / 16;
            if (cellFlag == 11) {
                extraText = "Msg:" + String.format("%04X  ", address.row);
                messageList.add(address);
                int messageType = address.column;
                if (messageType == 2) {
                    extraText = String.valueOf(extraText) + "Obtained: ";
                    if (this.items != null) {
                        extraText = String.valueOf(extraText) + this.items.get(address.level).getName();
                    }
                }
                if (messageType == 4) {
                    extraText = address.level < this.monsters.size() ? String.valueOf(extraText) + this.monsters.get((int)address.level).realName : String.valueOf(extraText) + "Obtained: " + this.items.get((address.level - 64536) * -1).getName();
                }
                if (messageType == 5) {
                    extraText = String.valueOf(extraText) + "Requires: ";
                    if (this.items != null) {
                        extraText = String.valueOf(extraText) + this.items.get(address.level).getName();
                    }
                }
            }
            if (cellFlag == 12) {
                monsterList.add(address);
                extraText = "Encounter: ";
                if (this.monsters != null) {
                    extraText = String.valueOf(extraText) + this.monsters.get((int)address.column).realName;
                }
            }
            text.append(String.format("    %X   -->   %X     %-15s   %04X  %04X  %04X  %s%n", j, cellFlag, extra, address.level, address.row, address.column, extraText));
            ++j;
        }
    }

    private void addEnmyCalc(StringBuilder text, int ptr) {
        text.append("\n\n");
        text.append(String.format("MINENEMY   %04X  %04X  %04X%n", Utility.getShort(this.buffer, ptr), Utility.getShort(this.buffer, ptr + 10), Utility.getShort(this.buffer, ptr + 20)));
        text.append(String.format("MULTWORS   %04X  %04X  %04X%n", Utility.getShort(this.buffer, ptr += 2), Utility.getShort(this.buffer, ptr + 10), Utility.getShort(this.buffer, ptr + 20)));
        text.append(String.format("WORSE01    %04X  %04X  %04X%n", Utility.getShort(this.buffer, ptr += 2), Utility.getShort(this.buffer, ptr + 10), Utility.getShort(this.buffer, ptr + 20)));
        text.append(String.format("RANGE0N    %04X  %04X  %04X%n", Utility.getShort(this.buffer, ptr += 2), Utility.getShort(this.buffer, ptr + 10), Utility.getShort(this.buffer, ptr + 20)));
        text.append(String.format("PERCWORS   %04X  %04X  %04X%n", Utility.getShort(this.buffer, ptr += 2), Utility.getShort(this.buffer, ptr + 10), Utility.getShort(this.buffer, ptr + 20)));
    }

    @Override
    public BufferedImage getImage() {
        Dimension cellSize = new Dimension(22, 22);
        this.image = new BufferedImage(20 * cellSize.width + 1, 20 * cellSize.height + 1, 9);
        Graphics2D g = this.image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int row = 0;
        while (row < 20) {
            int column = 0;
            while (column < 20) {
                MazeCell cell = this.getLocation(row, column);
                int x = column * cellSize.width;
                int y = this.image.getHeight() - (row + 1) * cellSize.height - 1;
                cell.draw(g, x, y);
                ++column;
            }
            ++row;
        }
        return this.image;
    }

    public void setMessages(List<Message> messages) {
        this.messages = messages;
    }

    public void setMonsters(List<Monster> monsters) {
        this.monsters = monsters;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    public MazeCell getLocation(int row, int column) {
        MazeAddress address = new MazeAddress(this.level, row, column);
        MazeCell cell = new MazeCell(address);
        int BYTES_PER_COL = 6;
        int CELLS_PER_BYTE = 4;
        int BITS_PER_ROW = 2;
        int offset = column * BYTES_PER_COL + row / CELLS_PER_BYTE;
        int value = this.buffer[offset] & 0xFF;
        cell.westWall = ((value >>>= row % CELLS_PER_BYTE * BITS_PER_ROW) & 1) == 1;
        cell.westDoor = ((value >>>= 1) & 1) == 1;
        value = this.buffer[offset + 120] & 0xFF;
        cell.southWall = ((value >>>= row % CELLS_PER_BYTE * BITS_PER_ROW) & 1) == 1;
        cell.southDoor = ((value >>>= 1) & 1) == 1;
        value = this.buffer[offset + 240] & 0xFF;
        cell.eastWall = ((value >>>= row % CELLS_PER_BYTE * BITS_PER_ROW) & 1) == 1;
        cell.eastDoor = ((value >>>= 1) & 1) == 1;
        value = this.buffer[offset + 360] & 0xFF;
        cell.northWall = ((value >>>= row % CELLS_PER_BYTE * BITS_PER_ROW) & 1) == 1;
        cell.northDoor = ((value >>>= 1) & 1) == 1;
        BYTES_PER_COL = 4;
        CELLS_PER_BYTE = 8;
        BITS_PER_ROW = 1;
        offset = column * BYTES_PER_COL + row / CELLS_PER_BYTE;
        value = this.buffer[offset + 480] & 0xFF;
        cell.monsterLair = ((value >>>= row % 8) & 1) == 1;
        offset = column * 10 + row / 2;
        value = this.buffer[offset + 560] & 0xFF;
        int b = row % 2 == 0 ? value % 16 : value / 16;
        int c = this.buffer[760 + b / 2] & 0xFF;
        int cellFlag = b % 2 == 0 ? c % 16 : c / 16;
        block0 : switch (cellFlag) {
            case 0: {
                break;
            }
            case 1: {
                cell.stairs = true;
                cell.addressTo = this.getAddress(b);
                break;
            }
            case 2: {
                cell.pit = true;
                break;
            }
            case 3: {
                cell.chute = true;
                cell.addressTo = this.getAddress(b);
                break;
            }
            case 4: {
                cell.spinner = true;
                break;
            }
            case 5: {
                cell.darkness = true;
                break;
            }
            case 6: {
                cell.teleport = true;
                cell.addressTo = this.getAddress(b);
                break;
            }
            case 7: {
                cell.unknown = cellFlag;
                break;
            }
            case 8: {
                cell.elevator = true;
                MazeAddress elevatorAddress = this.getAddress(b);
                cell.elevatorTo = elevatorAddress.row;
                cell.elevatorFrom = elevatorAddress.column;
                break;
            }
            case 9: {
                cell.rock = true;
                break;
            }
            case 10: {
                cell.spellsBlocked = true;
                break;
            }
            case 11: {
                MazeAddress messageAddress = this.getAddress(b);
                Message m = this.getMessage(messageAddress.row);
                if (m != null) {
                    cell.message = m;
                }
                cell.messageType = messageAddress.column;
                switch (cell.messageType) {
                    case 2: {
                        if (this.items == null) break block0;
                        cell.itemObtained = this.items.get(messageAddress.level);
                        break;
                    }
                    case 4: {
                        int itemID = messageAddress.level;
                        if (itemID <= 100) {
                            cell.monsterID = itemID;
                            cell.monsters = this.monsters;
                            break;
                        }
                        int val = (itemID - 64536) * -1;
                        if (this.items != null && val < this.items.size()) {
                            cell.itemObtained = this.items.get(val);
                        }
                        if (cell.itemObtained != null) break block0;
                        System.out.printf("Item %d (%d) not found on level %d%n", val, value, this.level);
                        break;
                    }
                    case 5: {
                        if (this.items == null) break block0;
                        cell.itemRequired = this.items.get(messageAddress.level);
                    }
                }
                break;
            }
            case 12: {
                MazeAddress monsterAddress = this.getAddress(b);
                cell.monsterID = monsterAddress.column;
                cell.monsters = this.monsters;
                break;
            }
            default: {
                System.out.println("Unknown extra: " + cellFlag);
                cell.unknown = cellFlag;
            }
        }
        return cell;
    }

    private MazeAddress getAddress(int b) {
        return new MazeAddress(Utility.getShort(this.buffer, 768 + (b *= 2)), Utility.getShort(this.buffer, 800 + b), Utility.getShort(this.buffer, 832 + b));
    }

    private Message getMessage(int messageNo) {
        if (this.messages == null) {
            return null;
        }
        for (Message m : this.messages) {
            if (!m.match(messageNo)) continue;
            return m;
        }
        return null;
    }

    private Monster getMonster(int monsterNo) {
        if (this.monsters == null) {
            return null;
        }
        for (Monster m : this.monsters) {
            if (!m.match(monsterNo)) continue;
            return m;
        }
        return null;
    }

    public int getRows() {
        return 20;
    }

    public int getColumns() {
        return 20;
    }
}

