/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.wizardry;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.utilities.Utility;
import com.bytezone.diskbrowser.wizardry.MazeAddress;
import com.bytezone.diskbrowser.wizardry.MazeCell;
import com.bytezone.diskbrowser.wizardry.MessageBlock;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

class MazeGridV5
extends AbstractFile {
    private final MessageBlock messageBlock;
    List<MazeGrid> grids = new ArrayList<MazeGrid>();
    int minX = 9999;
    int minY = 9999;
    int maxX = 0;
    int maxY = 0;

    MazeGridV5(String name, byte[] buffer, MessageBlock messageBlock) {
        super(name, buffer);
        this.messageBlock = messageBlock;
        int i = 0;
        while (i < 16) {
            MazeCell[][] grid = new MazeCell[8][8];
            int row = 0;
            while (row < 8) {
                int col = 0;
                while (col < 8) {
                    grid[row][col] = this.getLayout(i, row, col);
                    ++col;
                }
                ++row;
            }
            MazeGrid mazeGrid = new MazeGrid(grid, buffer[528 + i] & 0xFF, buffer[512 + i] & 0xFF);
            this.grids.add(mazeGrid);
            this.minX = Math.min(this.minX, mazeGrid.xOffset);
            this.minY = Math.min(this.minY, mazeGrid.yOffset);
            this.maxX = Math.max(this.maxX, mazeGrid.xOffset);
            this.maxY = Math.max(this.maxY, mazeGrid.yOffset);
            ++i;
        }
    }

    @Override
    public BufferedImage getImage() {
        Dimension cellSize = new Dimension(22, 22);
        int fudge = 30;
        int gridWidth = (this.maxX - this.minX + 8) * cellSize.width;
        int gridHeight = (this.maxY - this.minY + 7) * cellSize.height;
        this.image = new BufferedImage(gridWidth + 1, gridHeight + fudge, 9);
        Graphics2D g = this.image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.LIGHT_GRAY);
        g.fillRect(0, 0, gridWidth + 1, gridHeight + fudge);
        int i = 0;
        while (i < 16) {
            MazeGrid mazeGrid = this.grids.get(i);
            int row = 0;
            while (row < 8) {
                int column = 0;
                while (column < 8) {
                    MazeCell cell = mazeGrid.grid[row][column];
                    int x = column * cellSize.width;
                    int y = this.image.getHeight() - row * cellSize.height;
                    cell.draw(g, x += (mazeGrid.xOffset - this.minX) * cellSize.width, y -= (mazeGrid.yOffset - this.minY) * cellSize.height + fudge);
                    ++column;
                }
                ++row;
            }
            ++i;
        }
        return this.image;
    }

    private MazeCell getLayout(int gridNo, int row, int column) {
        MazeAddress address = new MazeAddress(0, row, column);
        MazeCell cell = new MazeCell(address);
        int offset = gridNo * 16 + column * 2 + row / 4;
        int value = this.buffer[offset + 0] & 0xFF;
        cell.eastWall = ((value >>>= row % 4 * 2) & 1) == 1;
        cell.eastDoor = ((value >>>= 1) & 1) == 1;
        value = this.buffer[offset + 256] & 0xFF;
        cell.northWall = ((value >>>= row % 4 * 2) & 1) == 1;
        cell.northDoor = ((value >>>= 1) & 1) == 1;
        return cell;
    }

    @Override
    public String getHexDump() {
        StringBuilder text = new StringBuilder(super.getHexDump());
        text.append("\n\n");
        int offset = 544;
        int i = 0;
        while (i < 16) {
            text.append(String.format("%05X : ", offset + i * 4));
            int j = 0;
            while (j < 4) {
                text.append(HexFormatter.getHexString(this.buffer, offset + j * 64 + i * 4, 4));
                text.append("  ");
                ++j;
            }
            text.append("\n");
            ++i;
        }
        text.append("\n");
        offset = 800;
        i = 0;
        while (i < 15) {
            text.append(HexFormatter.format(this.buffer, offset + i * 10, 10));
            text.append("\n");
            ++i;
        }
        text.append("\n");
        offset = 1024;
        i = 0;
        while (i < 5) {
            text.append(HexFormatter.format(this.buffer, offset + i * 64, 64));
            text.append("\n\n");
            ++i;
        }
        text.append("\n");
        i = 0;
        while (i < 176) {
            int msg = Utility.getShort(this.buffer, 1344 + i);
            text.append(String.format("%05X  %04X  %04X", 1344 + i, i / 2, msg));
            if (msg >= 700) {
                List<String> messages = this.messageBlock.getMessageLines(msg);
                if (messages.size() > 0) {
                    text.append(String.format("  %s%n", messages.get(0)));
                } else {
                    text.append(String.format(" Message not found: %04X%n", msg));
                }
            } else {
                text.append("\n");
            }
            i += 2;
        }
        text.append("\n");
        offset = 1520;
        i = 0;
        while (i < 7) {
            text.append(HexFormatter.format(this.buffer, offset + i * 64, 64));
            text.append("\n\n");
            ++i;
        }
        return text.toString();
    }

    private class MazeGrid {
        MazeCell[][] grid;
        int xOffset;
        int yOffset;

        public MazeGrid(MazeCell[][] grid, int x, int y) {
            this.grid = grid;
            this.xOffset = x;
            this.yOffset = y;
        }
    }
}

