/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.wizardry;

import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.wizardry.Item;
import com.bytezone.diskbrowser.wizardry.MazeAddress;
import com.bytezone.diskbrowser.wizardry.Message;
import com.bytezone.diskbrowser.wizardry.Monster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.List;

class MazeCell {
    static final Dimension cellSize = new Dimension(22, 22);
    static final Color SECRET_DOOR = Color.RED;
    static final Color DOOR = Color.GREEN;
    boolean northWall;
    boolean southWall;
    boolean eastWall;
    boolean westWall;
    boolean northDoor;
    boolean southDoor;
    boolean eastDoor;
    boolean westDoor;
    boolean darkness;
    boolean stairs;
    boolean pit;
    boolean spinner;
    boolean chute;
    boolean elevator;
    boolean monsterLair;
    boolean rock;
    boolean teleport;
    boolean spellsBlocked;
    int elevatorFrom;
    int elevatorTo;
    int messageType;
    int monsterID = -1;
    int itemID;
    int unknown;
    MazeAddress address;
    MazeAddress addressTo;
    public Message message;
    public List<Monster> monsters;
    public Item itemRequired;
    public Item itemObtained;

    MazeCell(MazeAddress address) {
        this.address = address;
    }

    void draw(Graphics2D g, int x, int y) {
        g.setColor(Color.BLACK);
        g.fillRect(x, y, MazeCell.cellSize.width, MazeCell.cellSize.height);
        g.setColor(Color.WHITE);
        if (this.westWall) {
            this.drawWest(g, x, y);
        }
        if (this.eastWall) {
            this.drawEast(g, x, y);
        }
        if (this.northWall) {
            this.drawNorth(g, x, y);
        }
        if (this.southWall) {
            this.drawSouth(g, x, y);
        }
        g.setColor(DOOR);
        if (this.westDoor) {
            this.drawWest(g, x, y);
        }
        if (this.eastDoor) {
            this.drawEast(g, x, y);
        }
        if (this.northDoor) {
            this.drawNorth(g, x, y);
        }
        if (this.southDoor) {
            this.drawSouth(g, x, y);
        }
        g.setColor(SECRET_DOOR);
        if (this.westDoor && this.westWall) {
            this.drawWest(g, x, y);
        }
        if (this.eastDoor && this.eastWall) {
            this.drawEast(g, x, y);
        }
        if (this.northDoor && this.northWall) {
            this.drawNorth(g, x, y);
        }
        if (this.southDoor && this.southWall) {
            this.drawSouth(g, x, y);
        }
        g.setColor(Color.WHITE);
        if (this.monsterLair) {
            this.drawMonsterLair(g, x, y);
        }
        if (this.stairs) {
            if (this.address.level < this.addressTo.level) {
                this.drawStairsDown(g, x, y);
            } else {
                this.drawStairsUp(g, x, y);
            }
        } else if (this.message != null) {
            this.drawChar(g, x, y, "M", Color.RED);
        } else if (this.pit) {
            this.drawPit(g, x, y);
        } else if (this.chute) {
            this.drawChute(g, x, y);
        } else if (this.spinner) {
            g.drawString("S", x + 8, y + 16);
        } else if (this.teleport) {
            this.drawTeleport(g, x, y);
        } else if (this.darkness) {
            this.drawDarkness(g, x, y);
        } else if (this.rock) {
            this.drawRock(g, x, y);
        } else if (this.elevator) {
            this.drawElevator(g, x, y, (this.elevatorTo - this.elevatorFrom + 1) / 2);
        } else if (this.monsterID >= 0) {
            this.drawMonster(g, x, y);
        } else if (this.spellsBlocked) {
            this.drawSpellsBlocked(g, x, y);
        } else if (this.unknown != 0) {
            this.drawChar(g, x, y, HexFormatter.format1(this.unknown), Color.GRAY);
        }
    }

    void drawWest(Graphics2D g, int x, int y) {
        g.drawLine(x + 1, y + 1, x + 1, y + MazeCell.cellSize.height - 1);
    }

    void drawEast(Graphics2D g, int x, int y) {
        g.drawLine(x + MazeCell.cellSize.width - 1, y + 1, x + MazeCell.cellSize.width - 1, y + MazeCell.cellSize.height - 1);
    }

    void drawNorth(Graphics2D g, int x, int y) {
        g.drawLine(x + 1, y + 1, x + MazeCell.cellSize.width - 1, y + 1);
    }

    void drawSouth(Graphics2D g, int x, int y) {
        g.drawLine(x + 1, y + MazeCell.cellSize.height - 1, x + MazeCell.cellSize.width - 1, y + MazeCell.cellSize.height - 1);
    }

    void drawStairsUp(Graphics2D g, int x, int y) {
        g.drawLine(x + 6, y + 18, x + 6, y + 14);
        g.drawLine(x + 6, y + 14, x + 10, y + 14);
        g.drawLine(x + 10, y + 14, x + 10, y + 10);
        g.drawLine(x + 10, y + 10, x + 14, y + 10);
        g.drawLine(x + 14, y + 10, x + 14, y + 6);
        g.drawLine(x + 14, y + 6, x + 18, y + 6);
    }

    void drawStairsDown(Graphics2D g, int x, int y) {
        g.drawLine(x + 4, y + 7, x + 8, y + 7);
        g.drawLine(x + 8, y + 7, x + 8, y + 11);
        g.drawLine(x + 8, y + 11, x + 12, y + 11);
        g.drawLine(x + 12, y + 11, x + 12, y + 15);
        g.drawLine(x + 12, y + 15, x + 16, y + 15);
        g.drawLine(x + 16, y + 15, x + 16, y + 19);
    }

    void drawPit(Graphics2D g, int x, int y) {
        g.drawLine(x + 5, y + 14, x + 5, y + 19);
        g.drawLine(x + 5, y + 19, x + 17, y + 19);
        g.drawLine(x + 17, y + 14, x + 17, y + 19);
    }

    void drawChute(Graphics2D g, int x, int y) {
        g.drawLine(x + 6, y + 6, x + 10, y + 6);
        g.drawLine(x + 10, y + 6, x + 18, y + 18);
    }

    void drawElevator(Graphics2D g, int x, int y, int rows) {
        int i = 0;
        while (i < rows) {
            g.drawOval(x + 7, y + i * 5 + 5, 2, 2);
            g.drawOval(x + 14, y + i * 5 + 5, 2, 2);
            ++i;
        }
    }

    void drawMonsterLair(Graphics2D g, int x, int y) {
        g.setColor(Color.YELLOW);
        g.fillOval(x + 4, y + 4, 2, 2);
        g.setColor(Color.WHITE);
    }

    void drawTeleport(Graphics2D g, int x, int y) {
        g.setColor(Color.GREEN);
        g.fillOval(x + 8, y + 8, 8, 8);
        g.setColor(Color.WHITE);
    }

    void drawSpellsBlocked(Graphics2D g, int x, int y) {
        g.setColor(Color.YELLOW);
        g.fillOval(x + 8, y + 8, 8, 8);
        g.setColor(Color.WHITE);
    }

    void drawMonster(Graphics2D g, int x, int y) {
        g.setColor(Color.RED);
        g.fillOval(x + 8, y + 8, 8, 8);
        g.setColor(Color.WHITE);
    }

    void drawDarkness(Graphics2D g, int x, int y) {
        g.setColor(Color.gray);
        int h = 0;
        while (h < 15) {
            int offset = 0;
            while (offset < 15) {
                g.drawOval(x + offset + 4, y + h + 4, 1, 1);
                offset += 7;
            }
            h += 7;
        }
        g.setColor(Color.white);
    }

    void drawRock(Graphics2D g, int x, int y) {
        int h = 0;
        while (h < 15) {
            int offset = 0;
            while (offset < 15) {
                g.drawOval(x + offset + 4, y + h + 4, 1, 1);
                offset += 7;
            }
            h += 7;
        }
    }

    void drawChar(Graphics2D g, int x, int y, String c, Color colour) {
        g.setColor(colour);
        g.fillRect(x + 7, y + 6, 11, 11);
        g.setColor(Color.WHITE);
        g.drawString(c, x + 8, y + 16);
    }

    void drawHotDogStand(Graphics2D g, int x, int y) {
        g.drawRect(x + 5, y + 11, 12, 6);
        g.drawOval(x + 6, y + 18, 3, 3);
        g.drawOval(x + 13, y + 18, 3, 3);
        g.drawLine(x + 8, y + 6, x + 8, y + 10);
        g.drawLine(x + 14, y + 6, x + 14, y + 10);
        g.drawLine(x + 5, y + 5, x + 17, y + 5);
    }

    String getTooltipText() {
        StringBuilder sign = new StringBuilder("<html><pre>");
        sign.append("&nbsp;<b>");
        sign.append(String.valueOf(this.address.row) + "N ");
        sign.append(String.valueOf(this.address.column) + "E</b>&nbsp;<br>");
        if (this.message != null) {
            sign.append(this.message.toHTMLString());
        }
        if (this.elevator) {
            sign.append("&nbsp;Elevator: L" + this.elevatorFrom + "-L" + this.elevatorTo + "&nbsp;");
        }
        if (this.stairs) {
            sign.append("&nbsp;Stairs to ");
            if (this.addressTo.level == 0) {
                sign.append("castle&nbsp;");
            } else {
                sign.append("level " + this.addressTo.level + "&nbsp;");
            }
        }
        if (this.teleport) {
            sign.append("&nbsp;Teleport to ");
            if (this.addressTo.level == 0) {
                sign.append("castle&nbsp;");
            } else {
                sign.append("L" + this.addressTo.level + " " + this.addressTo.row + "N " + this.addressTo.column + "E&nbsp;");
            }
        }
        if (this.pit) {
            sign.append("&nbsp;Pit");
        }
        if (this.spinner) {
            sign.append("&nbsp;Spinner&nbsp;");
        }
        if (this.chute) {
            sign.append("&nbsp;Chute");
        }
        if (this.darkness) {
            sign.append("&nbsp;Darkness&nbsp;");
        }
        if (this.rock) {
            sign.append("&nbsp;Rock&nbsp;");
        }
        if (this.spellsBlocked) {
            sign.append("&nbsp;Spells fizzle out&nbsp;");
        }
        if (this.monsterID >= 0) {
            if (this.monsters == null || this.monsterID >= this.monsters.size()) {
                sign.append("&nbsp;Monster&nbsp;");
            } else {
                Monster monster = this.monsters.get(this.monsterID);
                sign.append("&nbsp;<b>" + monster.getRealName() + "&nbsp;</b>");
                while (monster.partnerOdds == 100) {
                    monster = this.monsters.get(monster.partnerID);
                    sign.append("<br>&nbsp;<b>" + monster.getRealName() + "&nbsp;</b>");
                }
            }
        }
        if (this.itemRequired != null) {
            sign.append("&nbsp;<b>Requires: ");
            sign.append(String.valueOf(this.itemRequired.getName()) + "&nbsp;</b>");
        }
        if (this.itemObtained != null) {
            sign.append("&nbsp;<b>Obtain: ");
            sign.append(String.valueOf(this.itemObtained.getName()) + "&nbsp;</b>");
        }
        sign.append("</pre></html>");
        return sign.toString();
    }
}

