/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.wizardry;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.utilities.Utility;

class ExperienceLevel
extends AbstractFile {
    private final long[] expLevels = new long[13];

    ExperienceLevel(String name, byte[] buffer) {
        super(name, buffer);
        int seq = 0;
        int ptr = 0;
        while (ptr < buffer.length) {
            if (buffer[ptr] == 0) break;
            long points = (long)(Utility.getShort(buffer, ptr) + Utility.getShort(buffer, ptr + 2) * 10000) + (long)Utility.getShort(buffer, ptr + 4) * 100000000L;
            this.expLevels[seq++] = points;
            ptr += 6;
        }
    }

    long getExperiencePoints(int level) {
        if (level == 0) {
            return this.expLevels[0];
        }
        return level < 13 ? this.expLevels[level - 1] : (long)(level - 13) * this.expLevels[0] + this.expLevels[12];
    }

    @Override
    public String getText() {
        StringBuilder line = new StringBuilder(String.valueOf(this.name) + "\n\nLevel   Points Needed\n");
        int i = 2;
        while (i <= 26) {
            line.append(String.format("  %2d   %,13d%n", i, this.getExperiencePoints(i)));
            ++i;
        }
        line.append(String.format("%n       %,13d+", this.expLevels[0]));
        return line.toString();
    }
}

