/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.visicalc;

import com.bytezone.diskbrowser.visicalc.Cell;
import com.bytezone.diskbrowser.visicalc.Function;
import com.bytezone.diskbrowser.visicalc.Value;

abstract class ValueFunction
extends Function {
    protected Value source;

    abstract double calculateValue();

    ValueFunction(Cell cell, String text) {
        super(cell, text);
        this.source = cell.getExpressionValue(this.functionText);
        this.values.add(this.source);
        this.valueType = Value.ValueType.NUMBER;
    }

    @Override
    public void calculate() {
        this.valueResult = Value.ValueResult.VALID;
        this.source.calculate();
        if (!this.source.isValid()) {
            this.valueResult = this.source.getValueResult();
            return;
        }
        this.value = this.calculateValue();
        if (Double.isNaN(this.value)) {
            this.valueResult = Value.ValueResult.ERROR;
        }
    }

    @Override
    public String getType() {
        return "ValueFunction";
    }
}

