/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.visicalc;

import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.visicalc.Abs;
import com.bytezone.diskbrowser.visicalc.Acos;
import com.bytezone.diskbrowser.visicalc.Address;
import com.bytezone.diskbrowser.visicalc.And;
import com.bytezone.diskbrowser.visicalc.Asin;
import com.bytezone.diskbrowser.visicalc.Atan;
import com.bytezone.diskbrowser.visicalc.Average;
import com.bytezone.diskbrowser.visicalc.Cell;
import com.bytezone.diskbrowser.visicalc.Choose;
import com.bytezone.diskbrowser.visicalc.Cos;
import com.bytezone.diskbrowser.visicalc.Count;
import com.bytezone.diskbrowser.visicalc.Error;
import com.bytezone.diskbrowser.visicalc.Exp;
import com.bytezone.diskbrowser.visicalc.False;
import com.bytezone.diskbrowser.visicalc.Function;
import com.bytezone.diskbrowser.visicalc.If;
import com.bytezone.diskbrowser.visicalc.Int;
import com.bytezone.diskbrowser.visicalc.IsError;
import com.bytezone.diskbrowser.visicalc.IsNa;
import com.bytezone.diskbrowser.visicalc.Ln;
import com.bytezone.diskbrowser.visicalc.Log10;
import com.bytezone.diskbrowser.visicalc.Lookup;
import com.bytezone.diskbrowser.visicalc.Max;
import com.bytezone.diskbrowser.visicalc.Min;
import com.bytezone.diskbrowser.visicalc.Na;
import com.bytezone.diskbrowser.visicalc.Not;
import com.bytezone.diskbrowser.visicalc.Npv;
import com.bytezone.diskbrowser.visicalc.Or;
import com.bytezone.diskbrowser.visicalc.Pi;
import com.bytezone.diskbrowser.visicalc.Sin;
import com.bytezone.diskbrowser.visicalc.Sqrt;
import com.bytezone.diskbrowser.visicalc.Sum;
import com.bytezone.diskbrowser.visicalc.Tan;
import com.bytezone.diskbrowser.visicalc.True;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class Sheet {
    private static final Pattern addressPattern = Pattern.compile("([AB]?[A-Z])([0-9]{1,3}):");
    private static final byte END_OF_LINE_TOKEN = -115;
    private static final int FORMAT_LENGTH = 3;
    private final Map<Integer, Cell> rowOrderCells = new TreeMap<Integer, Cell>();
    private final Map<Integer, Cell> columnOrderCells = new TreeMap<Integer, Cell>();
    private final List<String> lines = new ArrayList<String>();
    private final Map<Integer, Integer> columnWidths = new TreeMap<Integer, Integer>();
    private int columnWidth = 9;
    private char globalFormat = (char)32;
    private char recalculation = (char)65;
    private char recalculationOrder = (char)67;
    private int minColumn = 9999;
    private int maxColumn;
    private int minRow = 9999;
    private int maxRow;
    int[] functionTotals = new int[Function.functionList.length];

    public Sheet(byte[] buffer) {
        int last = buffer.length;
        while (buffer[--last] == 0) {
        }
        int ptr = 0;
        while (ptr < last) {
            int length = this.getLineLength(buffer, ptr);
            String line = HexFormatter.getString(buffer, ptr, length);
            assert (!line.isEmpty());
            this.lines.add(line);
            if (line.startsWith("/")) {
                this.doFormat(line);
            } else if (line.startsWith(">")) {
                this.processLine(line);
            } else {
                System.out.printf("Error [%s]%n", line);
            }
            ptr += length + 1;
        }
        this.calculate(this.recalculationOrder);
    }

    private void calculate(char order) {
        Map<Integer, Cell> cells = order == 'R' ? this.rowOrderCells : this.columnOrderCells;
        for (Cell cell : cells.values()) {
            if (!cell.isCellType(Cell.CellType.VALUE)) continue;
            cell.calculate();
        }
    }

    private int getLineLength(byte[] buffer, int offset) {
        int ptr = offset;
        while (buffer[ptr] != -115) {
            ++ptr;
        }
        return ptr - offset;
    }

    /*
     * Unable to fully structure code
     */
    private void processLine(String line) {
        currentCell = null;
        m = Sheet.addressPattern.matcher(line);
        if (m.find()) {
            address = new Address(m.group(1), m.group(2));
            currentCell = this.rowOrderCells.get(address.getRowKey());
            pos = line.indexOf(58);
            line = line.substring(pos + 1);
            if (currentCell == null) {
                currentCell = new Cell(this, address);
                if (!line.startsWith("/G")) {
                    this.addCell(currentCell);
                }
            }
        } else {
            System.out.printf("Invalid cell address: %s%n", new Object[]{line});
            return;
        }
        if (!Sheet.$assertionsDisabled && currentCell == null) {
            throw new AssertionError();
        }
        if (!line.startsWith("/G")) ** GOTO lbl33
        if (line.charAt(2) == 'C' && line.charAt(3) == 'C') {
            width = Integer.parseInt(line.substring(4));
            this.columnWidths.put(currentCell.getAddress().getColumn(), width);
        } else {
            System.out.printf("Unknown Global:[%s]%n", new Object[]{line});
        }
        return;
lbl-1000:
        // 1 sources

        {
            if (line.charAt(1) == '-') {
                currentCell.setFormat(line);
                line = "";
                continue;
            }
            currentCell.setFormat(line.substring(0, 3));
            line = line.substring(3);
lbl33:
            // 3 sources

            ** while (line.startsWith((String)"/"))
        }
lbl34:
        // 1 sources

        if (!line.isEmpty()) {
            currentCell.setValue(line);
        }
    }

    private void addCell(Cell cell) {
        this.rowOrderCells.put(cell.getAddress().getRowKey(), cell);
        this.columnOrderCells.put(cell.getAddress().getColumnKey(), cell);
        this.minRow = Math.min(this.minRow, cell.getAddress().getRow());
        this.minColumn = Math.min(this.minColumn, cell.getAddress().getColumn());
        this.maxRow = Math.max(this.maxRow, cell.getAddress().getRow());
        this.maxColumn = Math.max(this.maxColumn, cell.getAddress().getColumn());
    }

    Cell getCell(String addressText) {
        return this.getCell(new Address(addressText));
    }

    Cell getCell(Address address) {
        Cell cell = this.rowOrderCells.get(address.getRowKey());
        if (cell == null) {
            cell = new Cell(this, address);
            this.addCell(cell);
        }
        return cell;
    }

    boolean cellExists(Address address) {
        return this.rowOrderCells.get(address.getRowKey()) != null;
    }

    public int size() {
        return this.rowOrderCells.size();
    }

    private void doFormat(String line) {
        switch (line.charAt(1)) {
            case 'G': {
                this.setGlobal(line);
                break;
            }
            case 'W': {
                break;
            }
            case 'X': {
                break;
            }
            default: {
                System.out.printf("Skipping [%s]%n", line);
            }
        }
    }

    private void setGlobal(String line) {
        switch (line.charAt(2)) {
            case 'C': {
                this.columnWidth = Integer.parseInt(line.substring(3));
                break;
            }
            case 'O': {
                this.recalculationOrder = line.charAt(3);
                break;
            }
            case 'R': {
                this.recalculation = line.charAt(3);
                break;
            }
            case 'F': {
                this.globalFormat = line.charAt(3);
                break;
            }
            case 'P': {
                break;
            }
            default: {
                System.out.printf("Unknown global format [%s]%n", line);
            }
        }
    }

    public String getTextDisplay(boolean debug) {
        StringBuilder text = new StringBuilder();
        String longLine = "                                                                                                                                ";
        String underline = "--------------------------------------------------------------------------------------------------------------------------";
        int lastRow = 0;
        int lastColumn = 0;
        StringBuilder heading = new StringBuilder("    ");
        int column = 0;
        while (column <= this.maxColumn) {
            int width = this.columnWidth;
            if (this.columnWidths.containsKey(column)) {
                width = this.columnWidths.get(column);
            }
            char letter1 = column < 26 ? (char)'-' : (column < 52 ? (char)'A' : 'B');
            char letter2 = (char)(column % 26 + 65);
            if (width == 1) {
                heading.append(letter2);
            } else if (width == 2) {
                heading.append(String.format("%s%s", Character.valueOf(letter1), Character.valueOf(letter2)));
            } else {
                String fmt = String.format("%s%s%%%d.%ds", Character.valueOf(letter1), Character.valueOf(letter2), width - 2, width - 2);
                heading.append(String.format(fmt, underline));
            }
            ++column;
        }
        if (debug) {
            ArrayList<String> counts = new ArrayList<String>();
            int i = 0;
            while (i < this.functionTotals.length) {
                if (this.functionTotals[i] > 0) {
                    String name = Function.functionList[i];
                    if (name.endsWith("(")) {
                        name = name.substring(0, name.length() - 1);
                    }
                    counts.add(String.format("%-10s%d", name, this.functionTotals[i]));
                }
                ++i;
            }
            while (counts.size() < 18) {
                counts.add("");
            }
            text.append(String.format("+%-83.83s+%n", underline));
            text.append(String.format("| Global format : %-18s %-14s %-14s %-14s   |%n", Character.valueOf(this.globalFormat), counts.get(0), counts.get(6), counts.get(12)));
            text.append(String.format("| Column width  : %-2d %-15s %-14s %-14s %-14s   |%n", this.columnWidth, "", counts.get(1), counts.get(7), counts.get(13)));
            text.append(String.format("| Recalc  order : %-18s %-14s %-14s %-14s   |%n", this.recalculationOrder == 'R' ? "Row" : "Column", counts.get(2), counts.get(8), counts.get(14)));
            text.append(String.format("| Recalculation : %-18s %-14s %-14s %-14s   |%n", this.recalculation == 'A' ? "Automatic" : "Manual", counts.get(3), counts.get(9), counts.get(15)));
            text.append(String.format("| Cells         : %-5d  %-11s %-14s %-14s %-14s   |%n", this.size(), "", counts.get(4), counts.get(10), counts.get(16)));
            String rangeText = this.size() > 0 ? String.valueOf(Address.getCellName(this.minRow + 1, this.minColumn)) + ":" + Address.getCellName(this.maxRow + 1, this.maxColumn) : "";
            text.append(String.format("| Range         : %-18s %-14s %-14s %-14s   |%n", rangeText, counts.get(5), counts.get(11), counts.get(17)));
            text.append(String.format("+%-83.83s+%n", underline));
        }
        if (debug) {
            text.append((CharSequence)heading);
            text.append("\n001:");
        }
        for (Cell cell : this.rowOrderCells.values()) {
            Address cellAddress = cell.getAddress();
            while (lastRow < cellAddress.getRow()) {
                ++lastRow;
                lastColumn = 0;
                if (debug) {
                    text.append(String.format("%n%03d:", lastRow + 1));
                    continue;
                }
                text.append("\n");
            }
            while (lastColumn < cellAddress.getColumn()) {
                int width = this.columnWidth;
                if (this.columnWidths.containsKey(lastColumn)) {
                    width = this.columnWidths.get(lastColumn);
                }
                text.append(longLine.substring(0, width));
                ++lastColumn;
            }
            ++lastColumn;
            int colWidth = this.columnWidth;
            if (this.columnWidths.containsKey(cellAddress.getColumn())) {
                colWidth = this.columnWidths.get(cellAddress.getColumn());
            }
            text.append(cell.getFormattedText(colWidth, this.globalFormat));
        }
        if (debug) {
            text.append("\n\n");
            int last = -1;
            for (Cell cell : this.columnOrderCells.values()) {
                if (last < cell.getAddress().getColumn()) {
                    String columnName = Address.getCellName(1, cell.getAddress().getColumn());
                    columnName = columnName.substring(0, columnName.length() - 1);
                    text.append("\n                                    *** Column " + columnName + " ***\n\n");
                    last = cell.getAddress().getColumn();
                }
                text.append(cell);
                text.append("+-----------------------------------------------------------------------------------+");
                text.append("\n\n");
            }
            text.append("File contents:\n\n");
            for (String line : this.lines) {
                text.append(line);
                text.append("\n");
            }
            if (text.length() > 0) {
                text.deleteCharAt(text.length() - 1);
            }
        }
        return text.toString();
    }

    Function getFunction(Cell cell, String text) {
        int functionId = -1;
        int i = 0;
        while (i < Function.functionList.length) {
            if (text.startsWith(Function.functionList[i])) {
                functionId = i;
                int n = i;
                this.functionTotals[n] = this.functionTotals[n] + 1;
                break;
            }
            ++i;
        }
        if (functionId < 0) {
            System.out.printf("Unknown function: [%s]%n", text);
            return new Error(cell, "@ERROR");
        }
        switch (functionId) {
            case 0: {
                return new Abs(cell, text);
            }
            case 1: {
                return new Acos(cell, text);
            }
            case 2: {
                return new And(cell, text);
            }
            case 3: {
                return new Asin(cell, text);
            }
            case 4: {
                return new Atan(cell, text);
            }
            case 5: {
                return new Average(cell, text);
            }
            case 6: {
                return new Count(cell, text);
            }
            case 7: {
                return new Choose(cell, text);
            }
            case 8: {
                return new Cos(cell, text);
            }
            case 9: {
                return new Error(cell, text);
            }
            case 10: {
                return new Exp(cell, text);
            }
            case 11: {
                return new False(cell, text);
            }
            case 12: {
                return new If(cell, text);
            }
            case 13: {
                return new Int(cell, text);
            }
            case 14: {
                return new IsError(cell, text);
            }
            case 15: {
                return new IsNa(cell, text);
            }
            case 16: {
                return new Log10(cell, text);
            }
            case 17: {
                return new Lookup(cell, text);
            }
            case 18: {
                return new Ln(cell, text);
            }
            case 19: {
                return new Min(cell, text);
            }
            case 20: {
                return new Max(cell, text);
            }
            case 21: {
                return new Na(cell, text);
            }
            case 22: {
                return new Not(cell, text);
            }
            case 23: {
                return new Npv(cell, text);
            }
            case 24: {
                return new Or(cell, text);
            }
            case 25: {
                return new Pi(cell, text);
            }
            case 26: {
                return new Sin(cell, text);
            }
            case 27: {
                return new Sum(cell, text);
            }
            case 28: {
                return new Sqrt(cell, text);
            }
            case 29: {
                return new Tan(cell, text);
            }
            case 30: {
                return new True(cell, text);
            }
        }
        System.out.printf("Unknown function ID: %d%n", functionId);
        return new Error(cell, "@ERROR");
    }
}

