/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.visicalc;

import com.bytezone.diskbrowser.visicalc.Address;
import com.bytezone.diskbrowser.visicalc.Cell;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Range
implements Iterable<Address> {
    private static final Pattern rangePattern = Pattern.compile("([A-B]?[A-Z])([0-9]{1,3})\\.\\.\\.([A-B]?[A-Z])([0-9]{1,3})");
    private Address from;
    private Address to;
    private final List<Address> range = new ArrayList<Address>();
    private final Cell cell;
    private boolean isHorizontal;

    Range(Cell cell, String rangeText) {
        this.cell = cell;
        Matcher m = rangePattern.matcher(rangeText);
        if (!m.find()) {
            throw new IllegalArgumentException(rangeText);
        }
        this.from = new Address(m.group(1), m.group(2));
        this.to = new Address(m.group(3), m.group(4));
        this.isHorizontal = this.from.rowMatches(this.to);
        this.populateRange();
    }

    private void populateRange() {
        this.range.add(this.from);
        this.cell.getCell(this.from);
        Address tempFrom = this.from;
        if (this.from.rowMatches(this.to)) {
            while (this.from.compareTo(this.to) < 0) {
                this.from = this.from.nextColumn();
                this.range.add(this.from);
                this.cell.getCell(this.from);
            }
        } else if (this.from.columnMatches(this.to)) {
            while (this.from.compareTo(this.to) < 0) {
                this.from = this.from.nextRow();
                this.range.add(this.from);
                this.cell.getCell(this.from);
            }
        } else {
            throw new IllegalArgumentException("Cannot create range " + this.from.getText() + ", " + this.to.getText());
        }
        this.from = tempFrom;
    }

    static boolean isRange(String text) {
        return rangePattern.matcher(text).matches();
    }

    boolean isHorizontal() {
        return this.isHorizontal;
    }

    boolean isVertical() {
        return !this.isHorizontal;
    }

    @Override
    public Iterator<Address> iterator() {
        return this.range.iterator();
    }

    public int size() {
        return this.range.size();
    }

    public Address get(int index) {
        return index < 0 || index >= this.range.size() ? null : this.range.get(index);
    }

    public String toString() {
        if (this.from == null || this.to == null) {
            StringBuilder text = new StringBuilder();
            for (Address address : this.range) {
                text.append(String.valueOf(address.getText()) + ",");
            }
            if (text.length() > 0) {
                text.deleteCharAt(text.length() - 1);
            }
            return text.toString();
        }
        return String.format("      %s -> %s", this.from.getText(), this.to.getText());
    }
}

