/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.visicalc;

import com.bytezone.diskbrowser.visicalc.Cell;
import com.bytezone.diskbrowser.visicalc.Value;
import com.bytezone.diskbrowser.visicalc.ValueListFunction;

class Npv
extends ValueListFunction {
    Npv(Cell cell, String text) {
        super(cell, text);
        assert (text.startsWith("@NPV(")) : text;
    }

    @Override
    public void calculate() {
        this.value = 0.0;
        this.valueResult = Value.ValueResult.VALID;
        Value source = this.list.get(0);
        source.calculate();
        if (!source.isValid()) {
            this.valueResult = source.getValueResult();
            return;
        }
        double rate = 1.0 + source.getDouble();
        int period = 0;
        int i = 1;
        while (i < this.list.size()) {
            ++period;
            Cell cell = (Cell)this.list.get(i);
            if (!cell.isCellType(Cell.CellType.EMPTY)) {
                if (!cell.isValid()) {
                    this.valueResult = source.getValueResult();
                    return;
                }
                this.value += cell.getDouble() / Math.pow(rate, period);
            }
            ++i;
        }
    }
}

