/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.visicalc;

import com.bytezone.diskbrowser.visicalc.AbstractValue;
import com.bytezone.diskbrowser.visicalc.Cell;
import com.bytezone.diskbrowser.visicalc.Expression;
import com.bytezone.diskbrowser.visicalc.Value;
import java.util.Iterator;
import java.util.regex.Pattern;

class Condition
extends AbstractValue
implements Iterable<Value> {
    private static final Pattern cellAddress = Pattern.compile("[A-B]?[A-Z][0-9]{1,3}");
    private static final String[] comparators = new String[]{"<>", "<=", ">=", "=", "<", ">"};
    private String comparator;
    private String conditionText;
    private String valueText;
    private Value conditionExpression;
    private Value valueExpression;

    Condition(Cell cell, String text) {
        super(cell, text);
        this.valueType = Value.ValueType.BOOLEAN;
        String[] stringArray = comparators;
        int n = comparators.length;
        int n2 = 0;
        while (n2 < n) {
            String comp = stringArray[n2];
            int pos = text.indexOf(comp);
            if (pos > 0) {
                this.conditionText = text.substring(0, pos);
                this.conditionExpression = new Expression(cell, this.conditionText);
                this.values.add(this.conditionExpression);
                this.comparator = comp;
                this.valueText = text.substring(pos + comp.length());
                this.valueExpression = new Expression(cell, this.valueText);
                this.values.add(this.valueExpression);
                break;
            }
            ++n2;
        }
        if (this.comparator == null) {
            if (text.startsWith("@") || cellAddress.matcher(text).matches()) {
                this.conditionText = text;
                this.conditionExpression = new Expression(cell, text).reduce();
                this.values.add(this.conditionExpression);
            } else {
                throw new IllegalArgumentException("No comparator and not a function or address: " + text);
            }
        }
    }

    @Override
    public void calculate() {
        this.valueResult = Value.ValueResult.VALID;
        this.conditionExpression.calculate();
        if (!this.conditionExpression.isValid()) {
            this.valueResult = this.conditionExpression.getValueResult();
            return;
        }
        if (this.conditionExpression.getValueType() == Value.ValueType.BOOLEAN) {
            this.bool = this.conditionExpression.getBoolean();
            return;
        }
        this.valueExpression.calculate();
        if (!this.valueExpression.isValid()) {
            this.valueResult = this.valueExpression.getValueResult();
            return;
        }
        double conditionResult = this.conditionExpression.getDouble();
        double expressionResult = this.valueExpression.getDouble();
        if (this.comparator.equals("=")) {
            this.bool = conditionResult == expressionResult;
        } else if (this.comparator.equals("<>")) {
            this.bool = conditionResult != expressionResult;
        } else if (this.comparator.equals("<")) {
            this.bool = conditionResult < expressionResult;
        } else if (this.comparator.equals(">")) {
            this.bool = conditionResult > expressionResult;
        } else if (this.comparator.equals("<=")) {
            this.bool = conditionResult <= expressionResult;
        } else if (this.comparator.equals(">=")) {
            this.bool = conditionResult >= expressionResult;
        } else {
            System.out.printf("Unexpected comparator result [%s]%n", this.comparator);
        }
    }

    @Override
    public String getFullText() {
        return this.fullText;
    }

    @Override
    public String getType() {
        return "Condition";
    }

    static boolean isCondition(String text) {
        int ptr = 0;
        int depth = 0;
        while (ptr < text.length()) {
            char c = text.charAt(ptr);
            if (c == '(') {
                ++depth;
            } else if (c == ')') {
                --depth;
            } else if (depth == 0 && (c == '=' || c == '<' || c == '>')) {
                return true;
            }
            ++ptr;
        }
        return false;
    }

    @Override
    public Iterator<Value> iterator() {
        return this.values.iterator();
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append("+-----------------------------------------------------------------------------------+\n");
        text.append(String.format("| %-9.9s : %-50.50s %-8.8s %-10.10s|%n", new Object[]{"Predicate", this.getFullText(), this.valueType, this.getValueText(this)}));
        text.append(String.format("| %-9.9s : %-50.50s %-8.8s %-10.10s|%n", new Object[]{"Left", this.conditionText, this.conditionExpression.getValueType(), this.getValueText(this.conditionExpression)}));
        if (this.comparator != null) {
            text.append(String.format("| %-9.9s : %-70.70s|%n", "Comparatr", this.comparator));
            text.append(String.format("| %-9.9s : %-50.50s %-8.8s %-10.10s|%n", new Object[]{"Right", this.valueText, this.valueExpression.getValueType(), this.getValueText(this.valueExpression)}));
        }
        return text.toString();
    }
}

