/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.visicalc;

import com.bytezone.diskbrowser.visicalc.Cell;
import com.bytezone.diskbrowser.visicalc.Value;
import com.bytezone.diskbrowser.visicalc.ValueListFunction;

class Average
extends ValueListFunction {
    Average(Cell cell, String text) {
        super(cell, text);
        assert (text.startsWith("@AVERAGE(")) : text;
    }

    @Override
    public void calculate() {
        double total = 0.0;
        int totalChecked = 0;
        this.valueResult = Value.ValueResult.VALID;
        for (Value v : this.list) {
            if (v instanceof Cell var6_5 && cell.isCellType(Cell.CellType.EMPTY)) continue;
            v.calculate();
            if (v.getValueResult() == Value.ValueResult.NA) continue;
            if (!v.isValid()) {
                this.valueResult = v.getValueResult();
                return;
            }
            total += v.getDouble();
            ++totalChecked;
        }
        if (totalChecked == 0) {
            this.valueResult = Value.ValueResult.ERROR;
            return;
        }
        this.value = total / (double)totalChecked;
    }
}

