/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.visicalc;

import java.util.Arrays;

class Address
implements Comparable<Address> {
    private static final int MAX_ROWS = 255;
    private static final int MAX_COLUMNS = 64;
    private int row;
    private int column;
    private int rowKey;
    private int columnKey;
    private String text;

    public Address(String column, String row) {
        this.set(column, row);
    }

    public Address(int column, int row) {
        assert (column <= 64);
        assert (row <= 255);
        this.row = row;
        this.column = column;
        this.rowKey = row * 64 + column;
        this.columnKey = column * 255 + row;
        int col1 = column / 26;
        int col2 = column % 26;
        String col = col1 > 0 ? String.valueOf((char)(64 + col1) + (65 + col2)) : String.valueOf((char)(65 + col2));
        this.text = String.valueOf(col) + (row + 1);
    }

    public Address(String address) {
        assert (address.length() >= 2);
        if (address.charAt(1) < 'A') {
            this.set(address.substring(0, 1), address.substring(1));
        } else {
            this.set(address.substring(0, 2), address.substring(2));
        }
    }

    public boolean matches(String addressText) {
        Address address = new Address(addressText);
        return this.rowMatches(address) && this.columnMatches(address);
    }

    private void set(String sCol, String sRow) {
        if (sCol.length() == 1) {
            this.column = sCol.charAt(0) - 65;
        } else if (sCol.length() == 2) {
            this.column = (sCol.charAt(0) - 64) * 26 + sCol.charAt(1) - 65;
        } else {
            System.out.println("Bollocks");
        }
        try {
            this.row = Integer.parseInt(sRow) - 1;
            this.rowKey = this.row * 64 + this.column;
            this.columnKey = this.column * 255 + this.row;
            this.text = String.valueOf(sCol) + sRow;
        }
        catch (NumberFormatException e) {
            System.out.printf("sCol:%s,sRow:%s%n", sCol, sRow);
            System.out.printf("NFE: %s%n", sRow);
            System.out.println(Arrays.toString(Thread.currentThread().getStackTrace()));
        }
    }

    boolean rowMatches(Address other) {
        return this.row == other.row;
    }

    boolean columnMatches(Address other) {
        return this.column == other.column;
    }

    int getRow() {
        return this.row;
    }

    int getColumn() {
        return this.column;
    }

    Address nextRow() {
        Address next = new Address(this.column, this.row + 1);
        return next;
    }

    Address nextColumn() {
        Address next = new Address(this.column + 1, this.row);
        return next;
    }

    static String getCellName(int row, int column) {
        char c1 = (char)(65 + column / 26 - 1);
        char c2 = (char)(65 + column % 26);
        return "" + (c1 == '@' ? "" : Character.valueOf(c1)) + c2 + row;
    }

    public String getText() {
        return this.text;
    }

    int getRowKey() {
        return this.rowKey;
    }

    int getColumnKey() {
        return this.columnKey;
    }

    public String getDetails() {
        return String.format("Row:%3d  Col:%3d  rKey:%5d  cKey:%5d", this.row, this.column, this.rowKey, this.columnKey);
    }

    public String toString() {
        return String.format("%-6s Row:%3d Col:%3d Key:%4d", this.text, this.row, this.column, this.rowKey);
    }

    @Override
    public int compareTo(Address o) {
        return this.rowKey - o.rowKey;
    }
}

