/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.utilities;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.zip.CRC32;

public final class Utility {
    public static final byte ASCII_BACKSPACE = 8;
    public static final byte ASCII_LF = 10;
    public static final byte ASCII_CR = 13;
    public static final byte ASCII_QUOTE = 34;
    public static final byte ASCII_DOLLAR = 36;
    public static final byte ASCII_PERCENT = 37;
    public static final byte ASCII_LEFT_BRACKET = 40;
    public static final byte ASCII_RIGHT_BRACKET = 41;
    public static final byte ASCII_COMMA = 44;
    public static final byte ASCII_MINUS = 45;
    public static final byte ASCII_DOT = 46;
    public static final byte ASCII_COLON = 58;
    public static final byte ASCII_SEMI_COLON = 59;
    public static final byte ASCII_EQUALS = 61;
    public static final byte ASCII_CARET = 94;
    private static MathContext mathContext = new MathContext(9);
    private static MathContext mathContext4 = new MathContext(6);
    private static MathContext mathContext8 = new MathContext(15);
    private static final List<String> suffixes = Arrays.asList("po", "dsk", "do", "hdv", "2mg", "d13", "sdk", "shk", "bxy", "bny", "woz", "img", "dimg");
    static int[] crc32_tab;

    static {
        int[] nArray = new int[256];
        nArray[1] = 1996959894;
        nArray[2] = -301047508;
        nArray[3] = -1727442502;
        nArray[4] = 124634137;
        nArray[5] = 1886057615;
        nArray[6] = -379345611;
        nArray[7] = -1637575261;
        nArray[8] = 249268274;
        nArray[9] = 2044508324;
        nArray[10] = -522852066;
        nArray[11] = -1747789432;
        nArray[12] = 162941995;
        nArray[13] = 2125561021;
        nArray[14] = -407360249;
        nArray[15] = -1866523247;
        nArray[16] = 498536548;
        nArray[17] = 1789927666;
        nArray[18] = -205950648;
        nArray[19] = -2067906082;
        nArray[20] = 450548861;
        nArray[21] = 1843258603;
        nArray[22] = -187386543;
        nArray[23] = -2083289657;
        nArray[24] = 325883990;
        nArray[25] = 1684777152;
        nArray[26] = -43845254;
        nArray[27] = -1973040660;
        nArray[28] = 335633487;
        nArray[29] = 1661365465;
        nArray[30] = -99664541;
        nArray[31] = -1928851979;
        nArray[32] = 997073096;
        nArray[33] = 1281953886;
        nArray[34] = -715111964;
        nArray[35] = -1570279054;
        nArray[36] = 1006888145;
        nArray[37] = 1258607687;
        nArray[38] = -770865667;
        nArray[39] = -1526024853;
        nArray[40] = 901097722;
        nArray[41] = 1119000684;
        nArray[42] = -608450090;
        nArray[43] = -1396901568;
        nArray[44] = 853044451;
        nArray[45] = 1172266101;
        nArray[46] = -589951537;
        nArray[47] = -1412350631;
        nArray[48] = 651767980;
        nArray[49] = 1373503546;
        nArray[50] = -925412992;
        nArray[51] = -1076862698;
        nArray[52] = 565507253;
        nArray[53] = 1454621731;
        nArray[54] = -809855591;
        nArray[55] = -1195530993;
        nArray[56] = 671266974;
        nArray[57] = 1594198024;
        nArray[58] = -972236366;
        nArray[59] = -1324619484;
        nArray[60] = 795835527;
        nArray[61] = 1483230225;
        nArray[62] = -1050600021;
        nArray[63] = -1234817731;
        nArray[64] = 1994146192;
        nArray[65] = 31158534;
        nArray[66] = -1731059524;
        nArray[67] = -271249366;
        nArray[68] = 1907459465;
        nArray[69] = 112637215;
        nArray[70] = -1614814043;
        nArray[71] = -390540237;
        nArray[72] = 2013776290;
        nArray[73] = 251722036;
        nArray[74] = -1777751922;
        nArray[75] = -519137256;
        nArray[76] = 2137656763;
        nArray[77] = 141376813;
        nArray[78] = -1855689577;
        nArray[79] = -429695999;
        nArray[80] = 1802195444;
        nArray[81] = 476864866;
        nArray[82] = -2056965928;
        nArray[83] = -228458418;
        nArray[84] = 1812370925;
        nArray[85] = 453092731;
        nArray[86] = -2113342271;
        nArray[87] = -183516073;
        nArray[88] = 1706088902;
        nArray[89] = 314042704;
        nArray[90] = -1950435094;
        nArray[91] = -54949764;
        nArray[92] = 1658658271;
        nArray[93] = 366619977;
        nArray[94] = -1932296973;
        nArray[95] = -69972891;
        nArray[96] = 1303535960;
        nArray[97] = 984961486;
        nArray[98] = -1547960204;
        nArray[99] = -725929758;
        nArray[100] = 1256170817;
        nArray[101] = 1037604311;
        nArray[102] = -1529756563;
        nArray[103] = -740887301;
        nArray[104] = 1131014506;
        nArray[105] = 879679996;
        nArray[106] = -1385723834;
        nArray[107] = -631195440;
        nArray[108] = 1141124467;
        nArray[109] = 855842277;
        nArray[110] = -1442165665;
        nArray[111] = -586318647;
        nArray[112] = 1342533948;
        nArray[113] = 654459306;
        nArray[114] = -1106571248;
        nArray[115] = -921952122;
        nArray[116] = 1466479909;
        nArray[117] = 544179635;
        nArray[118] = -1184443383;
        nArray[119] = -832445281;
        nArray[120] = 1591671054;
        nArray[121] = 702138776;
        nArray[122] = -1328506846;
        nArray[123] = -942167884;
        nArray[124] = 1504918807;
        nArray[125] = 783551873;
        nArray[126] = -1212326853;
        nArray[127] = -1061524307;
        nArray[128] = -306674912;
        nArray[129] = -1698712650;
        nArray[130] = 62317068;
        nArray[131] = 1957810842;
        nArray[132] = -355121351;
        nArray[133] = -1647151185;
        nArray[134] = 81470997;
        nArray[135] = 1943803523;
        nArray[136] = -480048366;
        nArray[137] = -1805370492;
        nArray[138] = 225274430;
        nArray[139] = 2053790376;
        nArray[140] = -468791541;
        nArray[141] = -1828061283;
        nArray[142] = 167816743;
        nArray[143] = 2097651377;
        nArray[144] = -267414716;
        nArray[145] = -2029476910;
        nArray[146] = 503444072;
        nArray[147] = 1762050814;
        nArray[148] = -144550051;
        nArray[149] = -2140837941;
        nArray[150] = 426522225;
        nArray[151] = 1852507879;
        nArray[152] = -19653770;
        nArray[153] = -1982649376;
        nArray[154] = 282753626;
        nArray[155] = 1742555852;
        nArray[156] = -105259153;
        nArray[157] = -1900089351;
        nArray[158] = 397917763;
        nArray[159] = 1622183637;
        nArray[160] = -690576408;
        nArray[161] = -1580100738;
        nArray[162] = 953729732;
        nArray[163] = 1340076626;
        nArray[164] = -776247311;
        nArray[165] = -1497606297;
        nArray[166] = 1068828381;
        nArray[167] = 1219638859;
        nArray[168] = -670225446;
        nArray[169] = -1358292148;
        nArray[170] = 906185462;
        nArray[171] = 1090812512;
        nArray[172] = -547295293;
        nArray[173] = -1469587627;
        nArray[174] = 829329135;
        nArray[175] = 1181335161;
        nArray[176] = -882789492;
        nArray[177] = -1134132454;
        nArray[178] = 628085408;
        nArray[179] = 1382605366;
        nArray[180] = -871598187;
        nArray[181] = -1156888829;
        nArray[182] = 570562233;
        nArray[183] = 1426400815;
        nArray[184] = -977650754;
        nArray[185] = -1296233688;
        nArray[186] = 733239954;
        nArray[187] = 1555261956;
        nArray[188] = -1026031705;
        nArray[189] = -1244606671;
        nArray[190] = 752459403;
        nArray[191] = 1541320221;
        nArray[192] = -1687895376;
        nArray[193] = -328994266;
        nArray[194] = 1969922972;
        nArray[195] = 40735498;
        nArray[196] = -1677130071;
        nArray[197] = -351390145;
        nArray[198] = 1913087877;
        nArray[199] = 83908371;
        nArray[200] = -1782625662;
        nArray[201] = -491226604;
        nArray[202] = 2075208622;
        nArray[203] = 213261112;
        nArray[204] = -1831694693;
        nArray[205] = -438977011;
        nArray[206] = 2094854071;
        nArray[207] = 198958881;
        nArray[208] = -2032938284;
        nArray[209] = -237706686;
        nArray[210] = 1759359992;
        nArray[211] = 534414190;
        nArray[212] = -2118248755;
        nArray[213] = -155638181;
        nArray[214] = 1873836001;
        nArray[215] = 414664567;
        nArray[216] = -2012718362;
        nArray[217] = -15766928;
        nArray[218] = 1711684554;
        nArray[219] = 285281116;
        nArray[220] = -1889165569;
        nArray[221] = -127750551;
        nArray[222] = 1634467795;
        nArray[223] = 376229701;
        nArray[224] = -1609899400;
        nArray[225] = -686959890;
        nArray[226] = 1308918612;
        nArray[227] = 956543938;
        nArray[228] = -1486412191;
        nArray[229] = -799009033;
        nArray[230] = 1231636301;
        nArray[231] = 1047427035;
        nArray[232] = -1362007478;
        nArray[233] = -640263460;
        nArray[234] = 1088359270;
        nArray[235] = 936918000;
        nArray[236] = -1447252397;
        nArray[237] = -558129467;
        nArray[238] = 1202900863;
        nArray[239] = 817233897;
        nArray[240] = -1111625188;
        nArray[241] = -893730166;
        nArray[242] = 1404277552;
        nArray[243] = 615818150;
        nArray[244] = -1160759803;
        nArray[245] = -841546093;
        nArray[246] = 1423857449;
        nArray[247] = 601450431;
        nArray[248] = -1285129682;
        nArray[249] = -1000256840;
        nArray[250] = 1567103746;
        nArray[251] = 711928724;
        nArray[252] = -1274298825;
        nArray[253] = -1022587231;
        nArray[254] = 1510334235;
        nArray[255] = 755167117;
        crc32_tab = nArray;
    }

    private Utility() {
    }

    public static int getTotalSuffixes() {
        return suffixes.size();
    }

    public static String getSuffix(int index) {
        return suffixes.get(index);
    }

    public static boolean test(Graphics2D g) {
        return g.getFontRenderContext().getTransform().equals(AffineTransform.getScaleInstance(2.0, 2.0));
    }

    public static void printStackTrace() {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement ste = stackTraceElementArray[n2];
            System.out.println(ste);
            ++n2;
        }
    }

    public static String rtrim(StringBuilder text) {
        while (text.length() > 0 && text.charAt(text.length() - 1) == '\n') {
            text.deleteCharAt(text.length() - 1);
        }
        return text.toString();
    }

    public static int getIndent(StringBuilder fullText) {
        int ptr = fullText.length() - 1;
        int indent = 0;
        while (ptr >= 0 && fullText.charAt(ptr) != '\n') {
            --ptr;
            ++indent;
        }
        return indent;
    }

    public static int intValue(byte b1, byte b2) {
        return b1 & 0xFF | (b2 & 0xFF) << 8;
    }

    public static int intValue(byte b1, byte b2, byte b3) {
        return b1 & 0xFF | (b2 & 0xFF) << 8 | (b3 & 0xFF) << 16;
    }

    public static int getLong(byte[] buffer, int ptr) {
        try {
            int val = 0;
            int i = 3;
            while (i >= 0) {
                val <<= 8;
                val += buffer[ptr + i] & 0xFF;
                --i;
            }
            return val;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.printf("Index out of range (getLong): %08X  %<d%n", ptr);
            return 0;
        }
    }

    public static int getLongBigEndian(byte[] buffer, int ptr) {
        int val = 0;
        int i = 0;
        while (i < 4) {
            val <<= 8;
            val += buffer[ptr + i] & 0xFF;
            ++i;
        }
        return val;
    }

    public static int getShort(byte[] buffer, int ptr) {
        try {
            return buffer[ptr] & 0xFF | (buffer[ptr + 1] & 0xFF) << 8;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.printf("Index out of range (getShort): %04X  %<d%n", ptr);
            return 0;
        }
    }

    public static int signedShort(byte[] buffer, int ptr) {
        try {
            return (short)(buffer[ptr] & 0xFF | (buffer[ptr + 1] & 0xFF) << 8);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.printf("Index out of range (signedShort): %04X  %<d%n", ptr);
            return 0;
        }
    }

    public static int getShortBigEndian(byte[] buffer, int ptr) {
        int val = 0;
        int i = 0;
        while (i < 2) {
            val <<= 8;
            val |= buffer[ptr + i] & 0xFF;
            ++i;
        }
        return val;
    }

    public static LocalDateTime getAppleDate(byte[] buffer, int offset) {
        int yymmdd = Utility.getShort(buffer, offset);
        if (yymmdd != 0) {
            int year = (yymmdd & 0xFE00) >> 9;
            int month = (yymmdd & 0x1E0) >> 5;
            int day = yymmdd & 0x1F;
            int minute = buffer[offset + 2] & 0x3F;
            int hour = buffer[offset + 3] & 0x1F;
            if (hour > 23) {
                hour = 0;
            }
            if (minute > 59) {
                minute = 0;
            }
            year = year < 70 ? (year += 2000) : (year += 1900);
            try {
                return LocalDateTime.of(year, month, day, hour, minute);
            }
            catch (DateTimeException e) {
                System.out.printf("Bad date/time: %d %d %d %d %d %n", year, month, day, hour, minute);
            }
        }
        return null;
    }

    public static void putAppleDate(byte[] buffer, int offset, LocalDateTime date) {
        if (date != null) {
            int year = date.getYear();
            int month = date.getMonthValue();
            int day = date.getDayOfMonth();
            int hour = date.getHour();
            int minute = date.getMinute();
            year = year < 2000 ? (year -= 1900) : (year -= 2000);
            int val1 = year << 9 | month << 5 | day;
            Utility.writeShort(buffer, offset, val1);
            buffer[offset + 2] = (byte)minute;
            buffer[offset + 3] = (byte)hour;
        }
    }

    public static void writeShort(byte[] buffer, int ptr, int value) {
        buffer[ptr] = (byte)(value & 0xFF);
        buffer[ptr + 1] = (byte)((value & 0xFF00) >>> 8);
    }

    public static void writeTriple(byte[] buffer, int ptr, int value) {
        buffer[ptr] = (byte)(value & 0xFF);
        buffer[ptr + 1] = (byte)((value & 0xFF00) >>> 8);
        buffer[ptr + 2] = (byte)((value & 0xFF0000) >>> 16);
    }

    public static int readTriple(byte[] buffer, int ptr) {
        return buffer[ptr] & 0xFF | (buffer[ptr + 1] & 0xFF) << 8 | (buffer[ptr + 2] & 0xFF) << 16;
    }

    public static String matchFlags(int flag, String[] chars) {
        int weight = (int)Math.pow(2.0, chars.length - 1);
        StringBuilder text = new StringBuilder();
        int i = 0;
        while (i < chars.length) {
            if ((flag & weight) != 0) {
                text.append(chars[i]);
            } else {
                text.append(".");
            }
            weight >>>= 1;
            ++i;
        }
        return text.toString();
    }

    public static double getSANEDouble(byte[] buffer, int offset) {
        long bits = 0L;
        int i = 7;
        while (i >= 0) {
            bits <<= 8;
            bits |= (long)(buffer[offset + i] & 0xFF);
            --i;
        }
        return Double.longBitsToDouble(bits);
    }

    public static double floatValue(byte[] buffer, int ptr) {
        int exponent = buffer[ptr] & 0x7F;
        if (exponent == 0) {
            return 0.0;
        }
        int mantissa = (buffer[ptr + 1] & 0x7F) << 24 | (buffer[ptr + 2] & 0xFF) << 16 | (buffer[ptr + 3] & 0xFF) << 8 | buffer[ptr + 4] & 0xFF;
        boolean negative = (buffer[ptr + 1] & 0x80) != 0;
        double value = 0.5;
        int i = 2;
        int weight = 0x40000000;
        while (i <= 32) {
            if ((mantissa & weight) > 0) {
                value += Math.pow(0.5, i);
            }
            ++i;
            weight >>>= 1;
        }
        BigDecimal bd = new BigDecimal(value *= Math.pow(2.0, exponent));
        double rounded = bd.round(mathContext).doubleValue();
        return negative ? rounded * -1.0 : rounded;
    }

    public static double floatValueMS4(byte[] buffer, int ptr) {
        int exponent = buffer[ptr + 3] & 0x7F;
        if (exponent == 0) {
            return 0.0;
        }
        int mantissa = (buffer[ptr + 2] & 0x7F) << 16 | (buffer[ptr + 1] & 0xFF) << 8 | buffer[ptr] & 0xFF;
        boolean negative = (buffer[ptr + 2] & 0x80) != 0;
        double value = 0.5;
        int i = 2;
        int weight = 0x400000;
        while (i <= 23) {
            if ((mantissa & weight) != 0) {
                value += Math.pow(0.5, i);
            }
            ++i;
            weight >>>= 1;
        }
        BigDecimal bd = new BigDecimal(value *= Math.pow(2.0, exponent));
        double rounded = bd.round(mathContext4).doubleValue();
        return negative ? rounded * -1.0 : rounded;
    }

    public static double floatValueMS8(byte[] buffer, int ptr) {
        int exponent = buffer[ptr + 7] & 0x7F;
        if (exponent == 0) {
            return 0.0;
        }
        long mantissa = (long)(buffer[ptr + 6] & 0x7F) << 48 | (long)(buffer[ptr + 5] & 0xFF) << 40 | (long)(buffer[ptr + 4] & 0xFF) << 32 | (long)(buffer[ptr + 3] & 0xFF) << 24 | (long)((buffer[ptr + 2] & 0xFF) << 16) | (long)((buffer[ptr + 1] & 0xFF) << 8) | (long)(buffer[ptr] & 0xFF);
        boolean negative = (buffer[ptr + 6] & 0x80) != 0;
        double value = 0.5;
        long weight = 0x40000000000000L;
        int i = 2;
        while (i <= 55) {
            if ((mantissa & weight) != 0L) {
                value += Math.pow(0.5, i);
            }
            ++i;
            weight >>>= 1;
        }
        BigDecimal bd = new BigDecimal(value *= Math.pow(2.0, exponent));
        double rounded = bd.round(mathContext8).doubleValue();
        return negative ? rounded * -1.0 : rounded;
    }

    public static GregorianCalendar getPascalDate(byte[] buffer, int offset) {
        int date = Utility.getShort(buffer, offset);
        int month = date & 0xF;
        int day = (date & 0x1F0) >>> 4;
        int year = (date & 0xFE00) >>> 9;
        year = year < 70 ? (year += 2000) : (year += 1900);
        return new GregorianCalendar(year, month - 1, day);
    }

    public static int dimension(int chars, int border, int size, int gap) {
        return border * 2 + chars * (size + gap) - gap;
    }

    public static boolean find(byte[] buffer, byte[] key) {
        int i = 0;
        while (i < buffer.length) {
            if (Utility.matches(buffer, i, key)) {
                System.out.printf("Matches at %04X%n", i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean matches(byte[] buffer, int offset, byte[] key) {
        int ptr = 0;
        while (offset < buffer.length && ptr < key.length) {
            if (buffer[offset++] == key[ptr++]) continue;
            return false;
        }
        return true;
    }

    public static LocalDateTime getDateTime(byte[] buffer, int ptr) {
        try {
            int[] val = new int[6];
            int i = 0;
            while (i < 6) {
                val[i] = Integer.parseInt(String.format("%02X", buffer[ptr + i] & 0xFF));
                ++i;
            }
            LocalDateTime date = LocalDateTime.of(val[3] + 2000, val[5], val[4], val[2], val[1], val[0]);
            return date;
        }
        catch (NumberFormatException | DateTimeException e) {
            return null;
        }
    }

    public static int getSuffixNo(String filename) {
        return suffixes.indexOf(Utility.getSuffix(filename));
    }

    public static String getSuffix(String filename) {
        String lcFilename = filename.toLowerCase();
        if (lcFilename.endsWith(".gz")) {
            lcFilename = lcFilename.substring(0, lcFilename.length() - 3);
        } else if (lcFilename.endsWith(".zip")) {
            lcFilename = lcFilename.substring(0, lcFilename.length() - 4);
        }
        int dotPos = lcFilename.lastIndexOf(46);
        if (dotPos < 0) {
            return "";
        }
        return lcFilename.substring(dotPos + 1);
    }

    public static boolean validFileType(String filename) {
        if (filename.startsWith(".")) {
            return false;
        }
        return suffixes.contains(Utility.getSuffix(filename));
    }

    public static void reverse(byte[] buffer) {
        int lo = 0;
        int hi = buffer.length - 1;
        while (lo < hi) {
            byte temp = buffer[lo];
            buffer[lo++] = buffer[hi];
            buffer[hi--] = temp;
        }
    }

    public static boolean isHighBitSet(byte value) {
        return (value & 0x80) != 0;
    }

    public static boolean isControlCharacter(byte value) {
        int val = value & 0xFF;
        return val > 0 && val < 32;
    }

    public static boolean isDigit(byte value) {
        return value >= 48 && value <= 57;
    }

    public static boolean isLetter(byte value) {
        return value >= 65 && value <= 90;
    }

    public static boolean isPossibleVariable(byte value) {
        return Utility.isDigit(value) || Utility.isLetter(value) || value == 36 || value == 37;
    }

    public static boolean isPossibleNumber(byte value) {
        return Utility.isDigit(value) || value == 46;
    }

    public static boolean isMagic(byte[] buffer, int ptr, byte[] magic) {
        if (ptr + magic.length >= buffer.length) {
            return false;
        }
        int i = 0;
        while (i < magic.length) {
            if (buffer[ptr + i] != magic[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static long getChecksumValue(File file) {
        CRC32 checksum = new CRC32();
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file.getAbsolutePath()));
            byte[] bytes = new byte[1024];
            int len = 0;
            while ((len = is.read(bytes)) >= 0) {
                checksum.update(bytes, 0, len);
            }
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return checksum.getValue();
    }

    public static int getCRC(byte[] buffer, int length, int initialValue) {
        int crc = initialValue;
        int j = 0;
        while (j < length) {
            crc = (crc >>> 8 | crc << 8) & 0xFFFF;
            crc ^= buffer[j] & 0xFF;
            crc ^= (crc & 0xFF) >>> 4;
            crc ^= crc << 12 & 0xFFFF;
            crc ^= (crc & 0xFF) << 5 & 0xFFFF;
            ++j;
        }
        return crc &= 0xFFFF;
    }

    public static int crc32(byte[] buffer, int offset, int length) {
        int crc = -1;
        int eof = offset + length;
        int i = offset;
        while (i < eof) {
            crc = crc32_tab[(crc ^ buffer[i]) & 0xFF] ^ crc >>> 8;
            ++i;
        }
        return ~crc;
    }
}

