/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.utilities;

public class HexFormatter {
    private static String[] hex = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};

    public static String format(byte[] buffer) {
        return HexFormatter.format(buffer, 0, buffer.length);
    }

    public static String formatNoHeader(byte[] buffer) {
        return HexFormatter.formatNoHeader(buffer, 0, buffer.length);
    }

    public static String format(byte[] buffer, int offset, int length) {
        return HexFormatter.format(buffer, offset, length, true, 0);
    }

    public static String format(byte[] buffer, int offset, int length, int startingAddress) {
        return HexFormatter.format(buffer, offset, length, true, startingAddress);
    }

    public static String formatNoHeader(byte[] buffer, int offset, int length) {
        return HexFormatter.format(buffer, offset, length, false, 0);
    }

    public static String formatNoHeader(byte[] buffer, int offset, int length, int startingAddress) {
        return HexFormatter.format(buffer, offset, length, false, startingAddress);
    }

    public static String format(byte[] buffer, int offset, int length, boolean header, int startingAddress) {
        int i;
        boolean startedOnBoundary;
        StringBuilder line = new StringBuilder();
        int[] freq = new int[256];
        boolean bl = startedOnBoundary = offset % 256 == 0;
        if (header) {
            line.append("      ");
            i = 0;
            while (i < 16) {
                line.append("  " + hex[i]);
                ++i;
            }
            if (offset == 0) {
                line.append("\n");
            }
        }
        i = offset;
        while (i < offset + length) {
            if (line.length() > 0 && i > 0) {
                line.append("\n");
            }
            if (i > offset && startedOnBoundary && i % 512 == 0) {
                line.append("\n");
            }
            line.append(String.format("%05X : ", startingAddress + i - offset));
            StringBuffer trans = new StringBuffer();
            StringBuffer hexLine = new StringBuffer();
            int max = Math.min(i + 16, offset + length);
            max = Math.min(max, buffer.length);
            int j = i;
            while (j < max) {
                int c;
                int n = c = buffer[j] & 0xFF;
                freq[n] = freq[n] + 1;
                hexLine.append(String.format("%02X ", c));
                if (c > 127) {
                    c = c < 160 ? (c -= 64) : (c -= 128);
                }
                if (c < 32 || c == 127) {
                    trans.append(".");
                } else {
                    trans.append((char)c);
                }
                ++j;
            }
            while (hexLine.length() < 48) {
                hexLine.append(" ");
            }
            line.append(String.valueOf(hexLine.toString()) + ": " + trans.toString());
            i += 16;
        }
        return line.toString();
    }

    public static String sanitiseString(byte[] buffer, int offset, int length) {
        StringBuilder trans = new StringBuilder();
        int j = offset;
        while (j < offset + length) {
            int c = buffer[j] & 0xFF;
            if (c > 127) {
                c = c < 160 ? (c -= 64) : (c -= 128);
            }
            if (c < 32 || c == 127) {
                trans.append(".");
            } else {
                trans.append((char)c);
            }
            ++j;
        }
        return trans.toString();
    }

    public static String getString(byte[] buffer) {
        return HexFormatter.getString(buffer, 0, buffer.length);
    }

    public static String getString(byte[] buffer, int offset, int length) {
        StringBuilder text = new StringBuilder();
        int i = offset;
        while (i < offset + length) {
            int c = buffer[i] & 0xFF;
            if (c > 127) {
                c = c < 160 ? (c -= 64) : (c -= 128);
            }
            if (c == 13) {
                text.append("\n");
            } else if (c < 32) {
                text.append(".");
            } else {
                text.append((char)c);
            }
            ++i;
        }
        return text.toString();
    }

    public static String getString2(byte[] buffer, int offset, int length) {
        StringBuilder text = new StringBuilder();
        int i = offset;
        while (i < offset + length) {
            int c = buffer[i] & 0xFF;
            if (c == 136) {
                if (text.length() > 0) {
                    text.deleteCharAt(text.length() - 1);
                }
            } else {
                if (c > 127) {
                    c = c < 160 ? (c -= 64) : (c -= 128);
                }
                if (c < 32) {
                    text.append((char)(c + 64));
                } else {
                    text.append((char)c);
                }
            }
            ++i;
        }
        return text.toString();
    }

    public static String getHexString(byte[] buffer, int offset, int length) {
        return HexFormatter.getHexString(buffer, offset, length, true);
    }

    public static String getHexString(byte[] buffer) {
        return HexFormatter.getHexString(buffer, 0, buffer.length);
    }

    public static String getHexString(byte[] buffer, int offset, int length, boolean space) {
        StringBuilder hex = new StringBuilder();
        int max = Math.min(offset + length, buffer.length);
        int i = offset;
        while (i < max) {
            hex.append(String.format("%02X", buffer[i]));
            if (space) {
                hex.append(' ');
            }
            ++i;
        }
        if (length > 0 && space) {
            hex.deleteCharAt(hex.length() - 1);
        }
        return hex.toString();
    }

    public static String getHexStringReversed(byte[] buffer, int offset, int length, boolean space) {
        StringBuilder hex = new StringBuilder();
        int i = length - 1;
        while (i >= 0) {
            hex.append(String.format("%02X", buffer[offset + i]));
            if (space) {
                hex.append(' ');
            }
            --i;
        }
        if (length > 0 && space) {
            hex.deleteCharAt(hex.length() - 1);
        }
        return hex.toString();
    }

    public static String getBitString(byte b) {
        String s = "0000000" + Integer.toBinaryString(b & 0xFF);
        s = s.replaceAll("0", ".");
        return s.substring(s.length() - 8);
    }

    public static char byteValue(byte b) {
        int c = b & 0xFF;
        if (c > 127) {
            c -= 128;
        }
        if (c > 95) {
            c -= 64;
        }
        if (c < 32) {
            return '.';
        }
        return (char)c;
    }

    public static String format4(int value) {
        if (value < 0) {
            return "***err**";
        }
        StringBuilder text = new StringBuilder();
        int i = 0;
        int weight = 4096;
        while (i < 4) {
            int digit = value / weight;
            if (digit < 0 || digit > 15) {
                return "***err**";
            }
            text.append(hex[digit]);
            value %= weight;
            weight /= 16;
            ++i;
        }
        return text.toString();
    }

    public static String format3(int value) {
        return HexFormatter.format4(value).substring(1);
    }

    public static String format2(int value) {
        if (value < 0) {
            value += 256;
        }
        return String.valueOf(hex[value / 16]) + hex[value % 16];
    }

    public static String format1(int value) {
        return hex[value];
    }

    public static String getPascalString(byte[] buffer, int offset) {
        int length = buffer[offset] & 0xFF;
        return HexFormatter.getString(buffer, offset + 1, length);
    }

    public static String getCString(byte[] buffer, int offset) {
        int end = offset;
        while (buffer[end] != 0) {
            ++end;
        }
        return HexFormatter.getString(buffer, offset, end - offset);
    }
}

