/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.utilities;

import java.awt.Font;
import java.awt.GraphicsEnvironment;

public class FontUtility {
    public static final String OS = System.getProperty("os.name").toLowerCase();
    public static final String userHome = System.getProperty("user.home");
    public static final boolean MAC = OS.startsWith("mac os");
    public static final boolean MAC_OS_X = OS.startsWith("mac os x");
    public static final boolean LINUX = OS.equals("linux");
    public static final boolean WINDOWS = OS.startsWith("windows");
    public static final String USER = System.getProperty("user.name");
    private static GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
    public static String[] fontNames = ge.getAvailableFontFamilyNames();
    public static String fontName = MAC_OS_X ? "Monaco" : (WINDOWS ? "Lucida Sans Typewriter" : "Lucida Sans Typewriter");

    public static boolean isFontAvailable(String name) {
        String[] stringArray = fontNames;
        int n = fontNames.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Font getFont(FontType fontType, FontSize fontSize) {
        switch (fontSize) {
            case BASE: {
                return FontUtility.getFont(fontType, 12);
            }
            case BASE_PLUS_1: {
                return FontUtility.getFont(fontType, 14);
            }
            case BASE_PLUS_2: {
                return FontUtility.getFont(fontType, 16);
            }
            case BASE_MINUS_1: {
                return FontUtility.getFont(fontType, 10);
            }
            case BASE_MINUS_2: {
                return FontUtility.getFont(fontType, 8);
            }
        }
        return FontUtility.getFont(fontType, 12);
    }

    public static Font getFont(FontType fontType, int type, int fontSize) {
        assert (FontUtility.isFontAvailable(fontName));
        switch (fontType) {
            case PLAIN: {
                return new Font(fontName, type, fontSize);
            }
            case SANS_SERIF: {
                return new Font(fontName, type, fontSize);
            }
            case SERIF: {
                return new Font("Serif", type, fontSize);
            }
            case MONOSPACED: {
                return new Font("Monospaced", type, fontSize);
            }
        }
        return new Font(fontName, type, fontSize);
    }

    public static Font getFont(FontType fontType, int fontSize) {
        return FontUtility.getFont(fontType, 0, fontSize);
    }

    public static enum FontSize {
        BASE_MINUS_2,
        BASE_MINUS_1,
        BASE,
        BASE_PLUS_1,
        BASE_PLUS_2;

    }

    public static enum FontType {
        PLAIN,
        SANS_SERIF,
        SERIF,
        MONOSPACED;

    }
}

