/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.utilities;

import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class EnvironmentAction
extends AbstractAction {
    public EnvironmentAction() {
        super("Environment...");
        this.putValue("ShortDescription", "Display java details");
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, mask));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TextFormatter textFormatter = new TextFormatter();
        textFormatter.addLine("Java version", System.getProperty("java.runtime.version"));
        textFormatter.addLine();
        String userHome = System.getProperty("user.home");
        String path = System.getProperty("java.class.path");
        String[] stringArray = path.split(File.pathSeparator);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.startsWith(userHome)) {
                s = "~" + s.substring(userHome.length());
            }
            textFormatter.addLine("Classpath", s);
            ++n2;
        }
        JOptionPane.showMessageDialog(null, textFormatter.toLabel(), "Java Environment", 1);
    }

    class TextFormatter {
        List<String> titles = new ArrayList<String>();
        List<String> texts = new ArrayList<String>();

        TextFormatter() {
        }

        void addLine(String title, String text) {
            this.titles.add(title);
            this.texts.add(text);
        }

        void addLine() {
            this.addLine("", "");
        }

        JLabel toLabel() {
            StringBuilder text = new StringBuilder("<html>");
            int i = 0;
            while (i < this.texts.size()) {
                String title = this.titles.get(i);
                if (title.length() == 0) {
                    text.append("<br>");
                } else {
                    text.append(String.format("%s : %s<br>", title, this.texts.get(i)));
                }
                ++i;
            }
            text.append("</html>");
            JLabel label = new JLabel(text.toString());
            label.setFont(new Font("Monospaced", 0, 13));
            return label;
        }
    }
}

