/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.utilities;

public abstract class CPU {
    private byte xReg;
    private byte yReg;
    private byte aReg;
    protected boolean carry;
    protected boolean zero;
    protected boolean interrupt;
    protected boolean decimal;
    protected boolean breakFlag;
    protected boolean overflow;
    protected boolean negative;
    private final byte[] stack = new byte[256];
    private int sp = this.stack.length;
    private boolean debug = false;

    protected void setDebug(boolean value) {
        this.debug = value;
    }

    protected void and(byte mask) {
        this.aReg = (byte)(this.aReg & mask);
        this.zero = this.aReg == 0;
        this.negative = (this.aReg & 0x80) != 0;
        this.debug("AND");
    }

    protected void asl() {
        this.carry = (this.aReg & 0x80) != 0;
        this.aReg = (byte)(this.aReg << 1);
        this.zero = this.aReg == 0;
        this.negative = (this.aReg & 0x80) != 0;
        this.debug("ASL");
    }

    protected void bit(byte value) {
        byte b = (byte)(this.aReg & value);
        this.zero = b == 0;
        this.overflow = (value & 0x40) != 0;
        this.negative = (value & 0x80) != 0;
        this.debug("BIT");
    }

    protected void clc() {
        this.carry = false;
        this.debug("CLC");
    }

    protected void cli() {
        this.interrupt = false;
        this.debug("CLI");
    }

    protected void clv() {
        this.overflow = false;
        this.debug("CLV");
    }

    protected void cmp(byte value) {
        int tmp = (this.aReg & 0xFF) - (value & 0xFF);
        this.zero = tmp == 0;
        this.negative = (tmp & 0x80) != 0;
        this.carry = (this.aReg & 0xFF) >= (value & 0xFF);
        this.debug("CMP");
    }

    protected void cpx(byte value) {
        int tmp = (this.xReg & 0xFF) - (value & 0xFF);
        this.zero = tmp == 0;
        this.negative = (tmp & 0x80) != 0;
        this.carry = (this.xReg & 0xFF) >= (value & 0xFF);
        this.debug("CPX");
    }

    protected void cpy(byte value) {
        int tmp = (this.yReg & 0xFF) - (value & 0xFF);
        this.zero = tmp == 0;
        this.negative = (tmp & 0x80) != 0;
        this.carry = (this.yReg & 0xFF) >= (value & 0xFF);
        this.debug("CPY");
    }

    protected byte dec(byte value) {
        this.zero = (value = (byte)((value & 0xFF) - 1)) == 0;
        this.negative = (value & 0x80) != 0;
        this.debug("DEC");
        return value;
    }

    protected byte inc(byte value) {
        this.zero = (value = (byte)((value & 0xFF) + 1)) == 0;
        this.negative = (value & 0x80) != 0;
        this.debug("INC");
        return value;
    }

    protected void inx() {
        this.xReg = (byte)((this.xReg & 0xFF) + 1);
        this.xReg = (byte)(this.xReg & 0xFF);
        this.zero = this.xReg == 0;
        this.negative = (this.xReg & 0x80) != 0;
        this.debug("INX");
    }

    protected void lda(byte value) {
        this.aReg = value;
        this.zero = this.aReg == 0;
        this.negative = (this.aReg & 0x80) != 0;
        this.debug("LDA");
    }

    protected void lda(byte[] buffer, int offset) {
        this.aReg = buffer[offset];
        this.zero = this.aReg == 0;
        this.negative = (this.aReg & 0x80) != 0;
        this.debug("LDA");
    }

    protected void ldx(byte value) {
        this.xReg = value;
        this.zero = this.xReg == 0;
        this.negative = (this.xReg & 0x80) != 0;
        this.debug("LDX");
    }

    protected void ldy(byte value) {
        this.yReg = value;
        this.zero = this.yReg == 0;
        this.negative = (this.yReg & 0x80) != 0;
        this.debug("LDY");
    }

    protected void lsr() {
        this.negative = false;
        this.carry = (this.aReg & 1) != 0;
        this.aReg = (byte)((this.aReg & 0xFF) >>> 1);
        this.zero = this.aReg == 0;
        this.debug("LSR");
    }

    protected void ora(byte mask) {
        this.aReg = (byte)(this.aReg | mask);
        this.zero = this.aReg == 0;
        this.negative = (this.aReg & 0x80) != 0;
        this.debug("ORA");
    }

    protected void php() {
        int flags = 0;
        if (this.negative) {
            flags = (byte)(flags | 0x80);
        }
        if (this.overflow) {
            flags = (byte)(flags | 0x40);
        }
        if (this.breakFlag) {
            flags = (byte)(flags | 0x10);
        }
        if (this.decimal) {
            flags = (byte)(flags | 8);
        }
        if (this.interrupt) {
            flags = (byte)(flags | 4);
        }
        if (this.zero) {
            flags = (byte)(flags | 2);
        }
        if (this.carry) {
            flags = (byte)(flags | 1);
        }
        this.stack[--this.sp] = flags;
        this.debug("PHP");
    }

    protected void plp() {
        byte flags;
        this.negative = ((flags = this.stack[this.sp++]) & 0x80) != 0;
        this.overflow = (flags & 0x40) != 0;
        this.breakFlag = (flags & 0x10) != 0;
        this.decimal = (flags & 8) != 0;
        this.interrupt = (flags & 4) != 0;
        this.zero = (flags & 2) != 0;
        this.carry = (flags & 1) != 0;
        this.debug("PLP");
    }

    protected void pha() {
        this.stack[--this.sp] = this.aReg;
        this.debug("PHA");
    }

    protected void pla() {
        this.aReg = this.stack[this.sp++];
        this.zero = this.aReg == 0;
        this.negative = (this.aReg & 0x80) != 0;
        this.debug("PLA");
    }

    protected void rol() {
        boolean tempCarry = this.carry;
        this.carry = (this.aReg & 0x80) != 0;
        this.aReg = (byte)(this.aReg << 1);
        if (tempCarry) {
            this.aReg = (byte)(this.aReg | 1);
        }
        this.zero = this.aReg == 0;
        this.negative = (this.aReg & 0x80) != 0;
        this.debug("ROL");
    }

    protected byte rol(byte value) {
        boolean tempCarry = this.carry;
        this.carry = (value & 0x80) != 0;
        value = (byte)(value << 1);
        if (tempCarry) {
            value = (byte)(value | 1);
        }
        this.zero = value == 0;
        this.negative = (value & 0x80) != 0;
        this.debug("ROL");
        return value;
    }

    protected byte ror(byte value) {
        boolean tempCarry = this.carry;
        this.carry = (value & 1) != 0;
        value = (byte)((value & 0xFF) >>> 1);
        if (tempCarry) {
            value = (byte)(value | 0x80);
        }
        this.zero = value == 0;
        this.negative = (value & 0x80) != 0;
        this.debug("ROR");
        return value;
    }

    protected byte sta() {
        this.debug("STA");
        return this.aReg;
    }

    protected void sta(byte[] buffer, int offset) {
        buffer[offset] = this.aReg;
        this.zero = this.aReg == 0;
        this.negative = (this.aReg & 0x80) != 0;
        this.debug("STA");
    }

    protected byte stx() {
        this.debug("STX");
        return this.xReg;
    }

    protected byte sty() {
        this.debug("STY");
        return this.yReg;
    }

    protected void txa() {
        this.aReg = this.xReg;
        this.zero = this.aReg == 0;
        this.negative = (this.aReg & 0x80) != 0;
        this.debug("TXA");
    }

    protected void tya() {
        this.aReg = this.yReg;
        this.zero = this.aReg == 0;
        this.negative = (this.aReg & 0x80) != 0;
        this.debug("TYA");
    }

    protected void tax() {
        this.xReg = this.aReg;
        this.zero = this.xReg == 0;
        this.negative = (this.xReg & 0x80) != 0;
        this.debug("TAX");
    }

    protected void tay() {
        this.yReg = this.aReg;
        this.zero = this.yReg == 0;
        this.negative = (this.yReg & 0x80) != 0;
        this.debug("TAY");
    }

    protected void sei() {
        this.interrupt = true;
        this.debug("SEI");
    }

    protected String debugString() {
        return "";
    }

    protected void debug(String cmd) {
        if (this.debug) {
            String flags = String.format("%s %s - %s %s %s %s %s", this.negative ? "1" : ".", this.overflow ? "1" : ".", this.breakFlag ? "1" : ".", this.decimal ? "1" : ".", this.interrupt ? "1" : ".", this.zero ? "1" : ".", this.carry ? "1" : ".");
            System.out.printf("%3s  A: %02X  X: %02X  Y: %02X  %s  %s%n", cmd, this.aReg, this.xReg, this.yReg, flags, this.debugString());
        }
    }

    protected int indirectY(int base, byte offset, byte page) {
        if (this.debug) {
            System.out.printf("base: %,6d, page: %02X, offset: %02X, yReg: %02X%n", base, page, offset, this.yReg);
        }
        return (page & 0xFF) * 256 + (offset & 0xFF) - base + (this.yReg & 0xFF);
    }
}

