/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.prodos.write;

import com.bytezone.diskbrowser.prodos.write.DirectoryHeader;
import com.bytezone.diskbrowser.prodos.write.ProdosDisk;
import com.bytezone.diskbrowser.utilities.Utility;

public class VolumeDirectoryHeader
extends DirectoryHeader {
    int bitMapPointer = 6;
    int totalBlocks;

    public VolumeDirectoryHeader(ProdosDisk disk, int ptr) {
        super(disk, ptr);
        this.storageType = (byte)15;
    }

    @Override
    void read() {
        super.read();
        this.bitMapPointer = Utility.getShort(this.buffer, this.ptr + 35);
        this.totalBlocks = Utility.getShort(this.buffer, this.ptr + 37);
    }

    @Override
    void write() {
        super.write();
        Utility.writeShort(this.buffer, this.ptr + 35, this.bitMapPointer);
        Utility.writeShort(this.buffer, this.ptr + 37, this.totalBlocks);
    }

    @Override
    String toText() {
        return String.format("%-29s %04X %04X", super.toText(), this.totalBlocks, this.bitMapPointer);
    }

    @Override
    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append("--------------------------------------------");
        text.append("Volume Directory Header\n");
        text.append("--------------------------------------------");
        text.append(super.toString());
        text.append(String.format("Bitmap pointer ... %02X%n", this.bitMapPointer));
        text.append(String.format("Total blocks ..... %d%n", this.totalBlocks));
        text.append("--------------------------------------------");
        return text.toString();
    }
}

