/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.prodos.write;

import com.bytezone.diskbrowser.prodos.write.DirectoryHeader;
import com.bytezone.diskbrowser.prodos.write.FileEntry;
import com.bytezone.diskbrowser.prodos.write.ProdosDisk;
import com.bytezone.diskbrowser.utilities.Utility;
import java.time.LocalDateTime;

public class SubdirectoryHeader
extends DirectoryHeader {
    private int parentPointer;
    private byte parentEntry;
    private byte parentEntryLength;

    public SubdirectoryHeader(ProdosDisk disk, int ptr) {
        super(disk, ptr);
        this.storageType = (byte)14;
        this.access = (byte)-61;
    }

    void setParentDetails(FileEntry fileEntry) {
        this.parentPointer = fileEntry.getBlockNo();
        this.parentEntry = (byte)fileEntry.getEntryNo();
        this.parentEntryLength = (byte)39;
    }

    FileEntry getParentFileEntry() {
        FileEntry fileEntry = new FileEntry(this.disk, this.parentPointer * 512 + (this.parentEntry - 1) * 39 + 4);
        fileEntry.read();
        return fileEntry;
    }

    void updateParentFileEntry() {
        FileEntry fileEntry = this.getParentFileEntry();
        ++fileEntry.blocksUsed;
        fileEntry.eof += 512;
        fileEntry.modifiedDate = LocalDateTime.now();
        fileEntry.write();
    }

    @Override
    void read() {
        super.read();
        this.parentPointer = Utility.getShort(this.buffer, this.ptr + 35);
        this.parentEntry = this.buffer[this.ptr + 37];
        this.parentEntryLength = this.buffer[this.ptr + 38];
        assert (this.parentPointer > 0);
    }

    @Override
    void write() {
        super.write();
        this.buffer[this.ptr + 16] = 117;
        Utility.writeShort(this.buffer, this.ptr + 35, this.parentPointer);
        this.buffer[this.ptr + 37] = this.parentEntry;
        this.buffer[this.ptr + 38] = this.parentEntryLength;
    }

    @Override
    String toText() {
        return String.format("%s %04X:%02X", super.toText(), this.parentPointer, this.parentEntry);
    }

    @Override
    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append("--------------------------------------------");
        text.append("Subdirectory Header\n");
        text.append("--------------------------------------------");
        text.append(super.toString());
        text.append(String.format("Parent pointer ... %04X%n", this.parentPointer));
        text.append(String.format("Parent entry ..... %02X%n", this.parentEntry));
        text.append(String.format("PE length ........ %02X%n", this.parentEntryLength));
        text.append("--------------------------------------------");
        return text.toString();
    }
}

