/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.prodos.write;

import com.bytezone.diskbrowser.prodos.write.DiskFullException;
import com.bytezone.diskbrowser.prodos.write.ExtendedKeyBlock;
import com.bytezone.diskbrowser.prodos.write.FileAlreadyExistsException;
import com.bytezone.diskbrowser.prodos.write.FileEntry;
import com.bytezone.diskbrowser.prodos.write.FileWriter;
import com.bytezone.diskbrowser.prodos.write.SubdirectoryHeader;
import com.bytezone.diskbrowser.prodos.write.VolumeCatalogFullException;
import com.bytezone.diskbrowser.prodos.write.VolumeDirectoryHeader;
import com.bytezone.diskbrowser.utilities.Utility;
import java.io.DataInputStream;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

public class ProdosDisk {
    static final String UNDERLINE = "------------------------------------------------\n";
    static final String message = "DiskBrowser";
    private static final int CATALOG_SIZE = 4;
    private static final int BITS_PER_BLOCK = 4096;
    public static final String[] storageTypes = new String[]{"Deleted", "Seedling", "Sapling", "Tree", "", "", "", "", "", "", "", "", "", "Subdirectory", "Subdirectory Header", "Volume Directory Header"};
    private BitSet volumeBitMap;
    private final int maxBlocks;
    private final byte[] buffer;
    private final byte[] bootSector = new byte[512];
    private VolumeDirectoryHeader volumeDirectoryHeader;
    private Map<Integer, SubdirectoryHeader> subdirectoryHeaders = new TreeMap<Integer, SubdirectoryHeader>();
    private List<String> paths = new ArrayList<String>();

    public ProdosDisk(int blocks, String volumeName) throws IOException, DiskFullException {
        try {
            Throwable throwable = null;
            Iterator<SubdirectoryHeader> iterator = null;
            try (DataInputStream in = new DataInputStream(ProdosDisk.class.getClassLoader().getResourceAsStream("com/bytezone/diskbrowser/prodos/write/block-00.bin"));){
                int count = in.read(this.bootSector);
                if (count != 512) {
                    System.out.println("Error with prodos boot sector");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.maxBlocks = blocks;
        this.buffer = new byte[blocks * 512];
        this.volumeBitMap = new BitSet(blocks);
        int i = 0;
        while (i < blocks) {
            this.volumeBitMap.set(i, true);
            ++i;
        }
        this.createCatalog(volumeName);
        this.volumeDirectoryHeader.write();
        for (SubdirectoryHeader subdirectoryHeader : this.subdirectoryHeaders.values()) {
            subdirectoryHeader.write();
        }
    }

    private void createCatalog(String volumeName) throws DiskFullException {
        this.allocateNextBlock();
        this.allocateNextBlock();
        System.arraycopy(this.bootSector, 0, this.buffer, 0, 512);
        System.arraycopy(message.getBytes(), 0, this.buffer, 768, message.length());
        int i = 0;
        int prevBlockNo = 0;
        while (i < 4) {
            int blockNo = this.allocateNextBlock();
            int ptr = blockNo * 512;
            Utility.writeShort(this.buffer, ptr, prevBlockNo);
            Utility.writeShort(this.buffer, ptr + 2, 0);
            if (prevBlockNo > 0) {
                Utility.writeShort(this.buffer, prevBlockNo * 512 + 2, blockNo);
            }
            prevBlockNo = blockNo;
            if (i == 0) {
                this.volumeDirectoryHeader = new VolumeDirectoryHeader(this, ptr + 4);
                this.volumeDirectoryHeader.fileName = volumeName;
                this.volumeDirectoryHeader.totalBlocks = this.maxBlocks;
                this.volumeDirectoryHeader.creationDate = LocalDateTime.now();
                this.volumeDirectoryHeader.write();
            }
            ++i;
        }
        int indexBlocks = (this.maxBlocks - 1) / 4096 + 1;
        int i2 = 0;
        while (i2 < indexBlocks) {
            this.allocateNextBlock();
            ++i2;
        }
        this.writeVolumeBitMap();
    }

    public int getFreeBlocks() {
        return this.volumeBitMap.cardinality();
    }

    public FileEntry addFile(String path, byte type, int auxType, LocalDateTime created, LocalDateTime modified, byte[] fileBuffer, int eof) throws DiskFullException, VolumeCatalogFullException, FileAlreadyExistsException {
        String fileName;
        String[] subdirectories;
        if (path.isBlank()) {
            throw new IllegalArgumentException("Path is empty");
        }
        this.paths.add(path);
        int pos = path.lastIndexOf(47);
        if (pos > 0) {
            subdirectories = path.substring(0, pos).split("/");
            fileName = path.substring(pos + 1);
        } else {
            subdirectories = new String[]{};
            fileName = path;
        }
        int catalogBlockNo = this.createPath(subdirectories);
        Optional<FileEntry> fileEntryOpt = this.searchDirectory(catalogBlockNo, fileName);
        if (fileEntryOpt.isPresent()) {
            System.out.println("File already exists: " + path);
            System.out.println(fileEntryOpt.get());
            throw new FileAlreadyExistsException(fileName);
        }
        FileEntry fileEntry = this.findFreeSlot(catalogBlockNo);
        if (fileEntry != null) {
            fileEntry.fileName = fileName;
            fileEntry.version = 0;
            fileEntry.minVersion = 0;
            fileEntry.headerPointer = catalogBlockNo;
            fileEntry.fileType = type;
            fileEntry.auxType = auxType;
            fileEntry.creationDate = created;
            fileEntry.modifiedDate = modified;
            FileWriter fileWriter = new FileWriter(this);
            fileWriter.writeFile(fileBuffer, eof);
            fileEntry.storageType = fileWriter.storageType;
            fileEntry.keyPointer = fileWriter.keyPointer;
            fileEntry.blocksUsed = fileWriter.blocksUsed;
            fileEntry.eof = fileWriter.eof;
            fileEntry.write();
            this.updateFileCount(fileEntry.headerPointer);
        }
        return fileEntry;
    }

    private int createPath(String[] subdirectories) throws DiskFullException, VolumeCatalogFullException {
        int catalogBlockNo = 2;
        FileEntry fileEntry = null;
        int i = 0;
        while (i < subdirectories.length) {
            Optional<FileEntry> fileEntryOpt = this.searchDirectory(catalogBlockNo, subdirectories[i]);
            fileEntry = fileEntryOpt.isEmpty() ? this.createSubdirectory(catalogBlockNo, subdirectories[i]) : fileEntryOpt.get();
            catalogBlockNo = fileEntry.keyPointer;
            ++i;
        }
        return catalogBlockNo;
    }

    public void addResourceFork(FileEntry fileEntry, byte[] fileBuffer, int eof) throws DiskFullException {
        int blockNo = this.allocateNextBlock();
        FileWriter fileWriter = new FileWriter(this);
        fileWriter.writeFile(fileBuffer, eof);
        ExtendedKeyBlock extendedKeyBlock = new ExtendedKeyBlock(this, blockNo * 512);
        extendedKeyBlock.addMiniEntry(ExtendedKeyBlock.ForkType.DATA, fileEntry);
        extendedKeyBlock.addMiniEntry(ExtendedKeyBlock.ForkType.RESOURCE, fileWriter);
        fileEntry.keyPointer = blockNo;
        fileEntry.storageType = (byte)5;
        fileEntry.blocksUsed += fileWriter.blocksUsed + 1;
        fileEntry.eof = 512;
        fileEntry.write();
        extendedKeyBlock.write();
    }

    private boolean verify(String path) {
        String fileName;
        String[] subdirectories;
        int pos = path.lastIndexOf(47);
        if (pos > 0) {
            subdirectories = path.substring(0, pos).split("/");
            fileName = path.substring(pos + 1);
        } else {
            subdirectories = new String[]{};
            fileName = path;
        }
        int catalogBlockNo = 2;
        FileEntry fileEntry = null;
        int i = 0;
        while (i < subdirectories.length) {
            Optional<FileEntry> fileEntryOpt = this.searchDirectory(catalogBlockNo, subdirectories[i]);
            if (fileEntryOpt.isEmpty()) {
                System.out.println("path doesn't exist");
                return false;
            }
            fileEntry = fileEntryOpt.get();
            catalogBlockNo = fileEntry.keyPointer;
            ++i;
        }
        Optional<FileEntry> fileEntryOpt = this.searchDirectory(catalogBlockNo, fileName);
        return fileEntryOpt.isPresent();
    }

    void verify() {
        for (SubdirectoryHeader subdirectoryHeader : this.subdirectoryHeaders.values()) {
            FileEntry fileEntry = subdirectoryHeader.getParentFileEntry();
            if (fileEntry.fileName.equals(subdirectoryHeader.fileName)) continue;
            System.out.printf("fail: %s%n", subdirectoryHeader.fileName);
        }
    }

    void display() {
        this.volumeDirectoryHeader.list();
        for (SubdirectoryHeader subdirectoryHeader : this.subdirectoryHeaders.values()) {
            subdirectoryHeader.list();
        }
    }

    public void close() {
        this.writeVolumeBitMap();
        this.volumeDirectoryHeader.write();
        for (SubdirectoryHeader subdirectoryHeader : this.subdirectoryHeaders.values()) {
            subdirectoryHeader.write();
        }
    }

    private Optional<FileEntry> searchDirectory(int blockNo, String fileName) {
        int offset;
        int emptySlotPtr = 0;
        do {
            offset = blockNo * 512;
            int ptr = offset + 4;
            int i = 0;
            while (i < 13) {
                int storageTypeNameLength = this.buffer[ptr] & 0xFF;
                if (storageTypeNameLength == 0) {
                    if (emptySlotPtr == 0) {
                        emptySlotPtr = ptr;
                    }
                } else {
                    int nameLength = this.buffer[ptr] & 0xF;
                    int storageType = (this.buffer[ptr] & 0xF0) >>> 4;
                    if (storageType < 14 && fileName.equals(new String(this.buffer, ptr + 1, nameLength))) {
                        FileEntry fileEntry = new FileEntry(this, ptr);
                        fileEntry.read();
                        return Optional.of(fileEntry);
                    }
                }
                ptr += 39;
                ++i;
            }
        } while ((blockNo = Utility.getShort(this.buffer, offset + 2)) > 0);
        return Optional.empty();
    }

    private FileEntry createSubdirectory(int blockNo, String name) throws DiskFullException, VolumeCatalogFullException {
        FileEntry fileEntry = this.findFreeSlot(blockNo);
        if (fileEntry == null) {
            System.out.println("failed");
            return null;
        }
        fileEntry.storageType = (byte)13;
        fileEntry.fileName = name;
        fileEntry.keyPointer = this.allocateNextBlock();
        fileEntry.blocksUsed = 1;
        fileEntry.eof = 512;
        fileEntry.fileType = (byte)15;
        fileEntry.headerPointer = blockNo;
        fileEntry.creationDate = LocalDateTime.now();
        fileEntry.modifiedDate = LocalDateTime.now();
        fileEntry.write();
        this.updateFileCount(fileEntry.headerPointer);
        SubdirectoryHeader subdirectoryHeader = new SubdirectoryHeader(this, fileEntry.keyPointer * 512 + 4);
        subdirectoryHeader.fileName = name;
        subdirectoryHeader.creationDate = LocalDateTime.now();
        subdirectoryHeader.fileCount = 0;
        subdirectoryHeader.setParentDetails(fileEntry);
        subdirectoryHeader.write();
        this.subdirectoryHeaders.put(fileEntry.keyPointer, subdirectoryHeader);
        return fileEntry;
    }

    private void updateFileCount(int catalogBlock) {
        if (catalogBlock == 2) {
            this.volumeDirectoryHeader.fileCount = this.volumeDirectoryHeader.fileCount + 1;
            this.volumeDirectoryHeader.write();
        } else {
            SubdirectoryHeader subdirectoryHeader = this.subdirectoryHeaders.get(catalogBlock);
            subdirectoryHeader.fileCount = subdirectoryHeader.fileCount + 1;
            subdirectoryHeader.write();
        }
    }

    int allocateNextBlock() throws DiskFullException {
        int nextBlock = this.volumeBitMap.nextSetBit(0);
        if (nextBlock < 0) {
            throw new DiskFullException("Disk Full");
        }
        this.volumeBitMap.set(nextBlock, false);
        return nextBlock;
    }

    private FileEntry findFreeSlot(int blockNo) throws DiskFullException, VolumeCatalogFullException {
        int offset;
        if (blockNo == 2 && this.volumeDirectoryHeader.fileCount == 51) {
            throw new VolumeCatalogFullException("Volume Directory is full");
        }
        SubdirectoryHeader subdirectoryHeader = this.subdirectoryHeaders.get(blockNo);
        int lastBlockNo = 0;
        do {
            offset = blockNo * 512;
            int ptr = offset + 4;
            int i = 0;
            while (i < 13) {
                if (this.buffer[ptr] == 0) {
                    return new FileEntry(this, ptr);
                }
                ptr += 39;
                ++i;
            }
            lastBlockNo = blockNo;
        } while ((blockNo = Utility.getShort(this.buffer, offset + 2)) > 0);
        if (subdirectoryHeader == null) {
            throw new VolumeCatalogFullException("Volume Directory is full");
        }
        blockNo = this.allocateNextBlock();
        int ptr = blockNo * 512;
        Utility.writeShort(this.buffer, lastBlockNo * 512 + 2, blockNo);
        Utility.writeShort(this.buffer, ptr, lastBlockNo);
        subdirectoryHeader.updateParentFileEntry();
        return new FileEntry(this, ptr + 4);
    }

    private void writeVolumeBitMap() {
        int ptr = 3072;
        int val = 0;
        int blockNo = 0;
        while (blockNo < this.maxBlocks) {
            val <<= 1;
            if (this.volumeBitMap.get(blockNo++)) {
                val |= 1;
            }
            if (blockNo % 8 != 0) continue;
            this.buffer[ptr++] = (byte)val;
            val = 0;
        }
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append(this.volumeDirectoryHeader);
        text.append("\n");
        for (SubdirectoryHeader subdirectoryHeader : this.subdirectoryHeaders.values()) {
            text.append(subdirectoryHeader);
            text.append("\n");
            text.append(subdirectoryHeader.getParentFileEntry());
            text.append("\n");
        }
        return text.toString();
    }
}

