/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.prodos.write;

public class IndexBlock {
    int blockNo;
    int[] blocks = new int[256];
    int totalBlocks;

    public IndexBlock(int dataBlockNo) {
        this.blockNo = dataBlockNo;
    }

    void setPosition(int position, int actualBlockNo) {
        if (this.blocks[position] == 0) {
            ++this.totalBlocks;
        }
        this.blocks[position] = actualBlockNo;
    }

    int getPosition(int position) {
        return this.blocks[position];
    }

    void write(byte[] buffer) {
        int ptr = this.blockNo * 512;
        int i = 0;
        while (i < this.blocks.length) {
            if (this.blocks[i] == 0) {
                buffer[ptr + i] = 0;
                buffer[ptr + i + 256] = 0;
            } else {
                int blockNo = this.blocks[i];
                buffer[ptr + i] = (byte)(blockNo & 0xFF);
                buffer[ptr + i + 256] = (byte)((blockNo & 0xFF00) >>> 8);
            }
            ++i;
        }
    }

    public String toString() {
        return String.format("Index Block: %04X contains %d entries%n", this.blockNo, this.totalBlocks);
    }
}

