/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.prodos.write;

import com.bytezone.diskbrowser.prodos.write.DiskFullException;
import com.bytezone.diskbrowser.prodos.write.IndexBlock;
import com.bytezone.diskbrowser.prodos.write.MasterIndexBlock;
import com.bytezone.diskbrowser.prodos.write.ProdosDisk;

public class FileWriter {
    private final ProdosDisk disk;
    private IndexBlock indexBlock = null;
    private MasterIndexBlock masterIndexBlock = null;
    byte storageType;
    int keyPointer;
    int blocksUsed;
    int eof;

    FileWriter(ProdosDisk disk) {
        this.disk = disk;
    }

    void writeFile(byte[] dataBuffer, int eof) throws DiskFullException {
        this.eof = Math.min(eof, dataBuffer.length);
        int dataPtr = 0;
        int remaining = this.eof;
        while (dataPtr < this.eof) {
            int actualBlockNo = this.allocateNextBlock();
            this.map(dataPtr / 512, actualBlockNo);
            int bufferPtr = actualBlockNo * 512;
            int transfer = Math.min(remaining, 512);
            System.arraycopy(dataBuffer, dataPtr, this.disk.getBuffer(), bufferPtr, transfer);
            dataPtr += transfer;
            remaining -= transfer;
        }
        this.writeIndices();
    }

    void writeRecord(int recordNo, byte[] dataBuffer, int recordLength) throws DiskFullException {
        assert (recordLength > 0);
        int destPtr = recordLength * recordNo;
        int remaining = Math.min(recordLength, dataBuffer.length);
        int max = destPtr + remaining;
        int dataPtr = 0;
        if (this.eof < max) {
            this.eof = max;
        }
        while (destPtr < max) {
            int logicalBlockNo = destPtr / 512;
            int blockOffset = destPtr % 512;
            int tfr = Math.min(512 - blockOffset, remaining);
            int actualBlockNo = this.getActualBlockNo(logicalBlockNo);
            int bufferPtr = actualBlockNo * 512 + blockOffset;
            System.arraycopy(dataBuffer, dataPtr, this.disk.getBuffer(), bufferPtr, tfr);
            destPtr += tfr;
            dataPtr += tfr;
            remaining -= tfr;
        }
        this.writeIndices();
    }

    private int allocateNextBlock() throws DiskFullException {
        ++this.blocksUsed;
        return this.disk.allocateNextBlock();
    }

    private int getActualBlockNo(int logicalBlockNo) throws DiskFullException {
        int actualBlockNo = 0;
        switch (this.storageType) {
            case 3: {
                actualBlockNo = this.masterIndexBlock.get(logicalBlockNo / 256).getPosition(logicalBlockNo % 256);
                break;
            }
            case 2: {
                if (logicalBlockNo >= 256) break;
                actualBlockNo = this.indexBlock.getPosition(logicalBlockNo);
                break;
            }
            case 1: {
                if (logicalBlockNo != 0) break;
                actualBlockNo = this.keyPointer;
            }
        }
        if (actualBlockNo == 0) {
            actualBlockNo = this.allocateNextBlock();
            this.map(logicalBlockNo, actualBlockNo);
        }
        return actualBlockNo;
    }

    private void writeIndices() {
        if (this.storageType == 3) {
            this.masterIndexBlock.write(this.disk.getBuffer());
        } else if (this.storageType == 2) {
            this.indexBlock.write(this.disk.getBuffer());
        }
    }

    private void map(int logicalBlockNo, int actualBlockNo) throws DiskFullException {
        if (logicalBlockNo >= 256) {
            if (this.storageType != 3) {
                this.masterIndexBlock = new MasterIndexBlock(this.allocateNextBlock());
                if (this.storageType == 2) {
                    this.masterIndexBlock.set(0, this.indexBlock);
                } else if (this.storageType == 1) {
                    this.indexBlock = new IndexBlock(this.allocateNextBlock());
                    this.indexBlock.setPosition(0, this.keyPointer);
                    this.masterIndexBlock.set(0, this.indexBlock);
                }
                this.keyPointer = this.masterIndexBlock.blockNo;
                this.storageType = (byte)3;
                this.indexBlock = null;
            }
            this.getIndexBlock(logicalBlockNo / 256).setPosition(logicalBlockNo % 256, actualBlockNo);
        } else if (logicalBlockNo > 0) {
            if (this.storageType == 3) {
                this.getIndexBlock(0).setPosition(logicalBlockNo, actualBlockNo);
            } else if (this.storageType == 2) {
                this.indexBlock.setPosition(logicalBlockNo, actualBlockNo);
            } else {
                this.indexBlock = new IndexBlock(this.allocateNextBlock());
                if (this.storageType == 1) {
                    this.indexBlock.setPosition(0, this.keyPointer);
                }
                this.keyPointer = this.indexBlock.blockNo;
                this.storageType = (byte)2;
                this.indexBlock.setPosition(logicalBlockNo, actualBlockNo);
            }
        } else if (logicalBlockNo == 0) {
            if (this.storageType == 3) {
                this.getIndexBlock(0).setPosition(0, actualBlockNo);
            } else if (this.storageType == 2) {
                this.indexBlock.setPosition(0, actualBlockNo);
            } else {
                this.keyPointer = actualBlockNo;
                this.storageType = 1;
            }
        } else {
            System.out.println("Error: " + logicalBlockNo);
        }
    }

    private IndexBlock getIndexBlock(int position) throws DiskFullException {
        IndexBlock indexBlock = this.masterIndexBlock.get(position);
        if (indexBlock == null) {
            indexBlock = new IndexBlock(this.allocateNextBlock());
            this.masterIndexBlock.set(position, indexBlock);
        }
        return indexBlock;
    }
}

