/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.prodos;

import com.bytezone.diskbrowser.applefile.ProdosDirectory;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.gui.DataSource;
import com.bytezone.diskbrowser.prodos.DirectoryHeader;
import com.bytezone.diskbrowser.prodos.ProdosDisk;
import com.bytezone.diskbrowser.utilities.Utility;
import java.util.ArrayList;
import java.util.List;

public class VolumeDirectoryHeader
extends DirectoryHeader {
    protected final int bitMapBlock;
    protected int totalBlocks;
    protected int freeBlocks;
    protected int usedBlocks;
    protected int totalBitMapBlocks;

    VolumeDirectoryHeader(ProdosDisk parentDisk, byte[] entryBuffer) {
        super(parentDisk, entryBuffer, 2, 1);
        byte[] buffer;
        this.bitMapBlock = Utility.getShort(entryBuffer, 35);
        this.totalBlocks = Utility.getShort(entryBuffer, 37);
        this.totalBitMapBlocks = (this.totalBlocks - 1) / 512 + 1;
        int block = 2;
        do {
            this.dataBlocks.add(this.disk.getDiskAddress(block));
        } while ((block = Utility.getShort(buffer = this.disk.readBlock(block), 2)) > 0);
        int bitMapBytes = (this.totalBlocks - 1) / 8 + 1;
        byte[] buffer2 = new byte[bitMapBytes];
        int bitMapBlocks = (bitMapBytes - 1) / this.disk.getBlocksPerTrack() + 1;
        int lastBitMapBlock = this.bitMapBlock + bitMapBlocks - 1;
        int ptr = 0;
        block = this.bitMapBlock;
        while (block <= lastBitMapBlock) {
            int bytesToCopy = buffer2.length - ptr;
            byte[] temp = this.disk.readBlock(block);
            if (bytesToCopy > temp.length) {
                bytesToCopy = temp.length;
            }
            System.arraycopy(temp, 0, buffer2, ptr, bytesToCopy);
            ptr += bytesToCopy;
            ++block;
        }
        int max = (Math.min(this.totalBlocks, this.disk.getTotalBlocks()) - 1) / 8 + 1;
        block = 0;
        int i = 0;
        while (i < max) {
            byte b = buffer2[i];
            int j = 0;
            while (j < 8) {
                boolean free;
                boolean bl = free = (b & 0x80) != 0;
                if (free) {
                    ++this.freeBlocks;
                }
                parentDisk.setSectorFree(block++, free);
                b = (byte)(b << 1);
                ++j;
            }
            ++i;
        }
        this.usedBlocks = this.totalBlocks - this.freeBlocks;
    }

    @Override
    public DataSource getDataSource() {
        byte[] buf;
        ArrayList<byte[]> blockList = new ArrayList<byte[]>();
        int block = 2;
        do {
            buf = this.disk.readBlock(block);
            blockList.add(buf);
        } while ((block = Utility.getShort(buf, 2)) > 0);
        byte[] fullBuffer = new byte[blockList.size() * 507];
        int offset = 0;
        for (byte[] bfr : blockList) {
            System.arraycopy(bfr, 4, fullBuffer, offset, 507);
            offset += 507;
        }
        return new ProdosDirectory(this.parentDisk, this.name, fullBuffer, this.totalBlocks, this.freeBlocks, this.usedBlocks);
    }

    @Override
    public List<DiskAddress> getSectors() {
        ArrayList<DiskAddress> sectors = new ArrayList<DiskAddress>();
        sectors.addAll(this.dataBlocks);
        return sectors;
    }

    @Override
    public String getText() {
        return String.format("%s  %04X %02X", super.getText(), this.totalBlocks, this.bitMapBlock);
    }

    @Override
    public String toString() {
        return this.name;
    }
}

