/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.prodos;

import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.gui.DataSource;
import com.bytezone.diskbrowser.prodos.DirectoryHeader;
import com.bytezone.diskbrowser.prodos.FileEntry;
import com.bytezone.diskbrowser.prodos.ProdosDisk;
import com.bytezone.diskbrowser.utilities.Utility;
import java.util.List;

public class SubDirectoryHeader
extends DirectoryHeader {
    private final int parentPointer;
    private final int parentSequence;
    private final int parentSize;
    private final int blockNo;

    SubDirectoryHeader(ProdosDisk parentDisk, byte[] entryBuffer, FileEntry parent, int blockNo) {
        super(parentDisk, entryBuffer, blockNo, 1);
        this.parentDirectory = parent.parentDirectory;
        this.blockNo = blockNo;
        this.parentPointer = Utility.getShort(entryBuffer, 35);
        this.parentSequence = entryBuffer[37] & 0xFF;
        this.parentSize = entryBuffer[38] & 0xFF;
    }

    @Override
    public DataSource getDataSource() {
        return null;
    }

    @Override
    public List<DiskAddress> getSectors() {
        return null;
    }

    public int getBlockNo() {
        return this.blockNo;
    }

    @Override
    public String getText() {
        return String.format("%s  %04X:%02X", super.getText(), this.parentPointer, this.parentSequence);
    }

    @Override
    public String toString() {
        String locked = this.access == 1 ? "*" : " ";
        return String.format("   %s%-40s %15s", locked, "/" + this.name, this.created.format(ProdosDisk.df));
    }
}

