/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.prodos;

import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.utilities.Utility;
import java.util.ArrayList;
import java.util.List;

public class ResourceFork {
    private static String[] resourceTypes = new String[]{"", "rIcon", "rPicture", "rControlList", "rControlTemplate", "rC1InputString", "rPString", "rStringList", "rMenuBar", "rMenu", "rMenuItem", "rTextForLETextBox2", "", "rCt1lColorTbl", "rWindParaml", "rWindParam2", "rWindColor", "rTextBlock", "rStyleBlock", "rToolStartup", "rResName", "rAlertString", "rText", "", "", "", "rTwoRects", "", "rListRef", "rcString", "", "", "rErrorString", "rKTransTable", "", "rCloutputString", "", "rTERuler", "", "", "", "", ""};
    byte[] buffer;
    ResourceFileHeader resourceFileHeader;

    public ResourceFork(byte[] buffer) {
        this.buffer = buffer;
        this.resourceFileHeader = new ResourceFileHeader(buffer);
    }

    public boolean isValid() {
        return this.resourceFileHeader.resourceMap != null;
    }

    public String toString() {
        return this.resourceFileHeader.toString();
    }

    class ResourceFileHeader {
        int fileVersion;
        int fileToMap;
        int fileMapSize;
        ResourceMap resourceMap;

        ResourceFileHeader(byte[] buffer) {
            this.fileVersion = Utility.getLong(buffer, 0);
            this.fileToMap = Utility.getLong(buffer, 4);
            this.fileMapSize = Utility.getLong(buffer, 8);
            if (this.fileVersion == 0) {
                this.resourceMap = new ResourceMap(buffer, this.fileToMap, this.fileMapSize);
            }
        }

        public String toString() {
            StringBuilder text = new StringBuilder();
            text.append(String.format("Version ....... %04X  %<d%n", this.fileVersion));
            text.append(String.format("Map offset .... %04X  %<d%n", this.fileToMap));
            text.append(String.format("Map size ...... %04X  %<d%n%n", this.fileMapSize));
            text.append(String.format("%s", this.resourceMap));
            return text.toString();
        }
    }

    class ResourceFreeBlock {
        int blockOffset;
        int blockSize;

        public ResourceFreeBlock(byte[] buffer, int ptr) {
            this.blockOffset = Utility.getLong(buffer, ptr);
            this.blockSize = Utility.getLong(buffer, ptr + 4);
        }

        public String toString() {
            StringBuilder text = new StringBuilder();
            text.append(String.format("Offset ........ %04X  %<d%n", this.blockOffset));
            text.append(String.format("Size .......... %04X  %<d%n", this.blockSize));
            return text.toString();
        }
    }

    class ResourceMap {
        int mapNext;
        int mapFlags;
        int mapOffset;
        int mapSize;
        int mapToIndex;
        int mapFileNum;
        int mapId;
        int mapIndexSize;
        int mapIndexUsed;
        int mapFreeListSize;
        int mapFreeListUsed;
        List<ResourceFreeBlock> resourceFreeBlocks = new ArrayList<ResourceFreeBlock>();
        List<ResourceReferenceRecord> resourceReferenceRecords = new ArrayList<ResourceReferenceRecord>();

        ResourceMap(byte[] buffer, int ptr, int size) {
            int offset = ptr;
            if (ptr > buffer.length) {
                System.out.println("bad");
                return;
            }
            this.mapNext = Utility.getLong(buffer, ptr);
            this.mapFlags = Utility.getShort(buffer, ptr + 4);
            this.mapOffset = Utility.getLong(buffer, ptr + 6);
            this.mapSize = Utility.getLong(buffer, ptr + 10);
            this.mapToIndex = Utility.getShort(buffer, ptr + 14);
            this.mapFileNum = Utility.getShort(buffer, ptr + 16);
            this.mapId = Utility.getShort(buffer, ptr + 18);
            this.mapIndexSize = Utility.getLong(buffer, ptr + 20);
            this.mapIndexUsed = Utility.getLong(buffer, ptr + 24);
            this.mapFreeListSize = Utility.getShort(buffer, ptr + 28);
            this.mapFreeListUsed = Utility.getShort(buffer, ptr + 30);
            ptr = offset + 32;
            int i = 0;
            while (i < this.mapFreeListUsed) {
                this.resourceFreeBlocks.add(new ResourceFreeBlock(buffer, ptr));
                ptr += 8;
                ++i;
            }
            ptr = offset + this.mapToIndex;
            i = 0;
            while (i < this.mapIndexUsed) {
                this.resourceReferenceRecords.add(new ResourceReferenceRecord(buffer, ptr));
                ptr += 20;
                ++i;
            }
        }

        public String toString() {
            StringBuilder text = new StringBuilder();
            text.append(String.format("Map next ............ %04X  %<d%n", this.mapNext));
            text.append(String.format("Map flags ........... %04X  %<d%n", this.mapFlags));
            text.append(String.format("Map offset .......... %04X  %<d%n", this.mapOffset));
            text.append(String.format("Map size ............ %04X  %<d%n", this.mapSize));
            text.append(String.format("Map to index ........ %04X  %<d%n", this.mapToIndex));
            text.append(String.format("Map file num ........ %04X  %<d%n", this.mapFileNum));
            text.append(String.format("Map ID .............. %04X  %<d%n", this.mapId));
            text.append(String.format("Map index size ...... %04X  %<d%n", this.mapIndexSize));
            text.append(String.format("Map index used ...... %04X  %<d%n", this.mapIndexUsed));
            text.append(String.format("Map free list size .. %04X  %<d%n", this.mapFreeListSize));
            text.append(String.format("Map free list used .. %04X  %<d%n%n", this.mapFreeListUsed));
            for (ResourceFreeBlock resourceFreeBlock : this.resourceFreeBlocks) {
                text.append(resourceFreeBlock);
            }
            text.append("\n");
            for (ResourceReferenceRecord resourceReferenceRecord : this.resourceReferenceRecords) {
                text.append(resourceReferenceRecord);
            }
            return text.toString();
        }
    }

    class ResourceReferenceRecord {
        int resType;
        int resId;
        int resOffset;
        int resAttr;
        int resSize;
        int resHandle;
        byte[] buffer;
        int ptr;

        public ResourceReferenceRecord(byte[] buffer, int ptr) {
            this.resType = Utility.getShort(buffer, ptr);
            this.resId = Utility.getLong(buffer, ptr + 2);
            this.resOffset = Utility.getLong(buffer, ptr + 6);
            this.resAttr = Utility.getShort(buffer, ptr + 10);
            this.resSize = Utility.getLong(buffer, ptr + 12);
            this.resHandle = Utility.getLong(buffer, ptr + 16);
            this.buffer = buffer;
            this.ptr = ptr;
        }

        public String toString() {
            StringBuilder text = new StringBuilder();
            String resourceTypeText = "";
            int index = this.resType & 0xFF;
            if (this.resType > 32768 && index < resourceTypes.length) {
                resourceTypeText = resourceTypes[index];
            }
            text.append(String.format("Type .......... %04X  %s%n", this.resType, resourceTypeText));
            text.append(String.format("ID ............ %04X  %<d%n", this.resId));
            text.append(String.format("Offset ........ %04X  %<d%n", this.resOffset));
            text.append(String.format("Attr .......... %04X  %<d%n", this.resAttr));
            text.append(String.format("Size .......... %04X  %<d%n", this.resSize));
            text.append(String.format("Handle ........ %04X  %<d%n%n", this.resHandle));
            text.append(HexFormatter.format(this.buffer, this.resOffset, this.resSize));
            text.append("\n\n");
            return text.toString();
        }
    }
}

