/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.prodos;

import com.bytezone.diskbrowser.disk.AbstractSector;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;

class ProdosExtendedKeySector
extends AbstractSector {
    ProdosExtendedKeySector(Disk disk, byte[] buffer, DiskAddress diskAddress) {
        super(disk, buffer, diskAddress);
    }

    @Override
    public String createText() {
        StringBuilder text = this.getHeader("Prodos Extended Key Block");
        int i = 0;
        while (i < 512) {
            String type = i == 0 ? "Data" : "Resource";
            this.addText(text, this.buffer, i, 1, String.valueOf(type) + " fork storage type (" + this.getType(this.buffer[i]) + ")");
            this.addTextAndDecimal(text, this.buffer, i + 1, 2, "Key block");
            this.addTextAndDecimal(text, this.buffer, i + 3, 2, "Blocks used");
            this.addTextAndDecimal(text, this.buffer, i + 5, 3, "EOF");
            text.append("\n");
            if (i == 0 && this.buffer[8] != 0) {
                int j = 0;
                while (j <= 18) {
                    this.addTextAndDecimal(text, this.buffer, j + 8, 1, "Size");
                    this.addTextAndDecimal(text, this.buffer, j + 9, 1, "Type");
                    this.addTextAndDecimal(text, this.buffer, j + 10, 16, "Finder info");
                    j += 18;
                }
            }
            i += 256;
        }
        return text.toString();
    }

    private String getType(byte flag) {
        switch (flag & 0xF) {
            case 1: {
                return "Seedling";
            }
            case 2: {
                return "Sapling";
            }
            case 3: {
                return "Tree";
            }
        }
        return "???";
    }
}

