/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.prodos;

import com.bytezone.diskbrowser.applefile.AppleFileSource;
import com.bytezone.diskbrowser.applefile.BootSector;
import com.bytezone.diskbrowser.disk.AbstractFormattedDisk;
import com.bytezone.diskbrowser.disk.AppleDisk;
import com.bytezone.diskbrowser.disk.DefaultAppleFileSource;
import com.bytezone.diskbrowser.disk.DefaultSector;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.disk.SectorType;
import com.bytezone.diskbrowser.gui.DataSource;
import com.bytezone.diskbrowser.gui.ProdosPreferences;
import com.bytezone.diskbrowser.prodos.DirectoryHeader;
import com.bytezone.diskbrowser.prodos.FileEntry;
import com.bytezone.diskbrowser.prodos.ProdosBitMapSector;
import com.bytezone.diskbrowser.prodos.ProdosCatalogSector;
import com.bytezone.diskbrowser.prodos.ProdosExtendedKeySector;
import com.bytezone.diskbrowser.prodos.ProdosIndexSector;
import com.bytezone.diskbrowser.prodos.SubDirectoryHeader;
import com.bytezone.diskbrowser.prodos.VolumeDirectoryHeader;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.utilities.Utility;
import java.awt.Color;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class ProdosDisk
extends AbstractFormattedDisk {
    static ProdosPreferences prodosPreferences;
    static final DateTimeFormatter df;
    static final DateTimeFormatter tf;
    final SectorType dosSector = new SectorType("Bootstrap Loader", Color.lightGray);
    final SectorType catalogSector = new SectorType("Catalog", new Color(0, 200, 0));
    final SectorType volumeMapSector = new SectorType("Volume Map", Color.blue);
    final SectorType subcatalogSector = new SectorType("Subcatalog", Color.magenta);
    final SectorType masterIndexSector = new SectorType("Master Index", Color.orange);
    final SectorType indexSector = new SectorType("Index", Color.cyan);
    final SectorType dataSector = new SectorType("Data", Color.red);
    final SectorType extendedKeySector = new SectorType("Extended key", Color.gray);
    private final List<DirectoryHeader> headerEntries = new ArrayList<DirectoryHeader>();
    private final DefaultMutableTreeNode volumeNode;
    private VolumeDirectoryHeader volumeDirectoryHeader;
    private static final boolean debug = false;

    static {
        df = DateTimeFormatter.ofPattern("d-LLL-yy");
        tf = DateTimeFormatter.ofPattern("H:mm");
    }

    public static void setProdosPreferences(ProdosPreferences prodosPreferences) {
        ProdosDisk.prodosPreferences = prodosPreferences;
    }

    public ProdosDisk(Disk disk) {
        super(disk);
        this.sectorTypesList.add(this.dosSector);
        this.sectorTypesList.add(this.catalogSector);
        this.sectorTypesList.add(this.subcatalogSector);
        this.sectorTypesList.add(this.volumeMapSector);
        this.sectorTypesList.add(this.masterIndexSector);
        this.sectorTypesList.add(this.indexSector);
        this.sectorTypesList.add(this.dataSector);
        this.sectorTypesList.add(this.extendedKeySector);
        int block = 0;
        while (block < 2) {
            if (!disk.isBlockEmpty(disk.getDiskAddress(block))) {
                this.sectorTypes[block] = this.dosSector;
            }
            ++block;
        }
        DiskAddress da = disk.getDiskAddress(0);
        byte[] buffer = disk.readBlock(da);
        this.bootSector = new BootSector(disk, buffer, "Prodos", da);
        DefaultMutableTreeNode root = this.getCatalogTreeRoot();
        this.volumeNode = new DefaultMutableTreeNode("empty volume node");
        root.add(this.volumeNode);
        this.processDirectoryBlock(2, null, this.volumeNode);
        this.makeNodeVisible(this.volumeNode.getFirstLeaf());
        for (DiskAddress da2 : disk) {
            int blockNo = da2.getBlockNo();
            if (this.freeBlocks.get(blockNo)) {
                if (this.stillAvailable(da2)) continue;
                ++this.falsePositives;
                continue;
            }
            if (!this.stillAvailable(da2)) continue;
            ++this.falseNegatives;
        }
        if (ProdosDisk.prodosPreferences.sortDirectories) {
            this.sortNodes(this.volumeNode);
            ((DefaultTreeModel)this.catalogTree.getModel()).reload();
        }
    }

    private void processDirectoryBlock(int block, FileEntry parent, DefaultMutableTreeNode parentNode) {
        byte[] sectorBuffer;
        DirectoryHeader localHeader = null;
        SectorType currentSectorType = null;
        do {
            sectorBuffer = this.disk.readBlock(block);
            if (!this.disk.isBlockEmpty(block)) {
                this.sectorTypes[block] = currentSectorType;
            }
            int max = this.disk.getBlockSize() - 39;
            int ptr = 4;
            int entryNo = 0;
            while (ptr < max) {
                int storageType = (sectorBuffer[ptr] & 0xF0) >> 4;
                if (storageType != 0) {
                    byte[] entry = new byte[39];
                    System.arraycopy(sectorBuffer, ptr, entry, 0, 39);
                    switch (storageType) {
                        case 15: {
                            assert (this.headerEntries.size() == 0);
                            this.volumeDirectoryHeader = new VolumeDirectoryHeader(this, entry);
                            assert (this.volumeDirectoryHeader.entryLength == 39);
                            this.headerEntries.add(this.volumeDirectoryHeader);
                            currentSectorType = this.catalogSector;
                            if (!this.disk.isBlockEmpty(block)) {
                                this.sectorTypes[block] = currentSectorType;
                            }
                            int i = 0;
                            while (i < this.volumeDirectoryHeader.totalBitMapBlocks) {
                                this.sectorTypes[this.volumeDirectoryHeader.bitMapBlock + i] = this.volumeMapSector;
                                ++i;
                            }
                            parentNode.setUserObject(this.volumeDirectoryHeader);
                            localHeader = this.volumeDirectoryHeader;
                            break;
                        }
                        case 14: {
                            localHeader = new SubDirectoryHeader(this, entry, parent, block);
                            this.headerEntries.add(localHeader);
                            currentSectorType = this.subcatalogSector;
                            if (this.disk.isBlockEmpty(block)) break;
                            this.sectorTypes[block] = currentSectorType;
                            break;
                        }
                        case 13: {
                            FileEntry fileEntry = new FileEntry(this, entry, localHeader, block, entryNo);
                            this.fileEntries.add(fileEntry);
                            DefaultMutableTreeNode directoryNode = new DefaultMutableTreeNode(fileEntry);
                            directoryNode.setAllowsChildren(true);
                            parentNode.add(directoryNode);
                            this.processDirectoryBlock(fileEntry.keyPtr, fileEntry, directoryNode);
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            FileEntry fileEntry = new FileEntry(this, entry, localHeader, block, entryNo);
                            this.fileEntries.add(fileEntry);
                            DefaultMutableTreeNode node = new DefaultMutableTreeNode(fileEntry);
                            node.setAllowsChildren(false);
                            parentNode.add(node);
                            break;
                        }
                        default: {
                            System.out.println("Unknown storage type : " + storageType);
                            System.out.println(HexFormatter.format(entry, 0, entry.length));
                        }
                    }
                }
                ptr += 39;
                ++entryNo;
            }
        } while ((block = Utility.getShort(sectorBuffer, 2)) > 0);
        for (AppleFileSource fe : this.fileEntries) {
            String name = fe.getUniqueName();
            if (!name.endsWith(".AUX")) continue;
            String partner1 = name.substring(0, name.length() - 4);
            String partner2 = String.valueOf(name.substring(0, name.length() - 4)) + ".BIN";
            for (AppleFileSource fe2 : this.fileEntries) {
                if (!fe2.getUniqueName().equals(partner1) && !fe2.getUniqueName().equals(partner2)) continue;
                ((FileEntry)fe2).link((FileEntry)fe);
                ((FileEntry)fe).link((FileEntry)fe2);
            }
        }
    }

    public static boolean isCorrectFormat(AppleDisk disk) {
        disk.setInterleave(1);
        if (ProdosDisk.checkFormat(disk)) {
            return true;
        }
        disk.setInterleave(0);
        return ProdosDisk.checkFormat(disk);
    }

    public static boolean checkFormat(AppleDisk disk) {
        byte[] buffer = disk.readBlock(2);
        if (buffer[35] != 39 || buffer[36] != 13) {
            return false;
        }
        int bitMapBlock = Utility.getShort(buffer, 39);
        return bitMapBlock >= 3 && bitMapBlock <= 10;
    }

    public List<DirectoryHeader> getDirectoryHeaders() {
        return this.headerEntries;
    }

    VolumeDirectoryHeader getVolumeDirectoryHeader() {
        return this.volumeDirectoryHeader;
    }

    public DataSource getFile(int fileNo) {
        if (fileNo == 0) {
            return this.volumeDirectoryHeader.getDataSource();
        }
        return ((AppleFileSource)this.fileEntries.get(fileNo - 1)).getDataSource();
    }

    @Override
    public AppleFileSource getCatalog() {
        return new DefaultAppleFileSource("Catalog", this.volumeDirectoryHeader.getDataSource(), (FormattedDisk)this);
    }

    @Override
    public DataSource getFormattedSector(DiskAddress da) {
        if (da.isZero()) {
            return this.bootSector;
        }
        byte[] buffer = this.disk.readBlock(da);
        SectorType type = this.sectorTypes[da.getBlockNo()];
        if (type == this.catalogSector || type == this.subcatalogSector) {
            return new ProdosCatalogSector(this, this.disk, buffer, da);
        }
        if (type == this.volumeMapSector) {
            return new ProdosBitMapSector(this, this.disk, buffer, da);
        }
        if (type == this.masterIndexSector || type == this.indexSector) {
            return new ProdosIndexSector(this.getSectorFilename(da), this.disk, buffer, da);
        }
        if (type == this.extendedKeySector) {
            return new ProdosExtendedKeySector(this.disk, buffer, da);
        }
        if (type == this.dosSector) {
            return new DefaultSector("Boot sector", this.disk, buffer, da);
        }
        String name = this.getSectorFilename(da);
        if (name != null) {
            return new DefaultSector(name, this.disk, buffer, da);
        }
        return super.getFormattedSector(da);
    }

    @Override
    public List<DiskAddress> getFileSectors(int fileNo) {
        if (fileNo == 0) {
            return this.volumeDirectoryHeader.getSectors();
        }
        return ((AppleFileSource)this.fileEntries.get(fileNo - 1)).getSectors();
    }

    void sortNodes(DefaultMutableTreeNode node) {
        int totalChildren = node.getChildCount();
        if (totalChildren == 0) {
            return;
        }
        ArrayList<DefaultMutableTreeNode> children = new ArrayList<DefaultMutableTreeNode>(totalChildren);
        int i = 0;
        while (i < totalChildren) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            children.add(child);
            if (!child.isLeaf()) {
                this.sortNodes(child);
            }
            ++i;
        }
        if (totalChildren > 1) {
            node.removeAllChildren();
            children.sort(new NodeComparator());
            for (DefaultMutableTreeNode child : children) {
                node.add(child);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder text = new StringBuilder();
        String timeC = this.volumeDirectoryHeader.created == null ? "" : this.volumeDirectoryHeader.created.format(tf);
        text.append(String.format("Disk name          : %s%n", this.getDisplayPath()));
        text.append(String.format("Volume name        : %s%n", this.volumeDirectoryHeader.name));
        text.append(String.format("Creation date      : %s%n", timeC));
        text.append(String.format("ProDOS version     : %d%n", this.volumeDirectoryHeader.version));
        text.append(String.format("Min ProDOS version : %d%n", this.volumeDirectoryHeader.minVersion));
        text.append(String.format("Access rights      : %d%n", this.volumeDirectoryHeader.access));
        text.append(String.format("Entry length       : %d%n", this.volumeDirectoryHeader.entryLength));
        text.append(String.format("Entries per block  : %d%n", this.volumeDirectoryHeader.entriesPerBlock));
        text.append(String.format("File count         : %d%n", this.volumeDirectoryHeader.fileCount));
        text.append(String.format("Bitmap block       : %d%n", this.volumeDirectoryHeader.bitMapBlock));
        text.append(String.format("Total blocks       : %d%n", this.volumeDirectoryHeader.totalBlocks));
        text.append(String.format("Interleave         : %d", this.disk.getInterleave()));
        return text.toString();
    }

    class NodeComparator
    implements Comparator<DefaultMutableTreeNode> {
        NodeComparator() {
        }

        @Override
        public int compare(DefaultMutableTreeNode o1, DefaultMutableTreeNode o2) {
            boolean folder1 = o1.getAllowsChildren();
            boolean folder2 = o2.getAllowsChildren();
            if (folder1 && !folder2) {
                return -1;
            }
            if (!folder1 && folder2) {
                return 1;
            }
            String name1 = ((FileEntry)o1.getUserObject()).name;
            String name2 = ((FileEntry)o2.getUserObject()).name;
            return name1.compareTo(name2);
        }
    }
}

