/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.prodos;

import com.bytezone.diskbrowser.disk.AbstractSector;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.prodos.ProdosDisk;
import java.awt.Dimension;

class ProdosBitMapSector
extends AbstractSector {
    private final ProdosDisk parent;

    ProdosBitMapSector(ProdosDisk parent, Disk disk, byte[] buffer, DiskAddress da) {
        super(disk, buffer, da);
        this.parent = parent;
    }

    @Override
    public String createText() {
        Dimension grid = this.parent.getGridLayout();
        int relativeBlock = this.diskAddress.getBlockNo() - this.parent.getVolumeDirectoryHeader().bitMapBlock;
        int startBit = relativeBlock * 4096;
        if (startBit >= grid.width * grid.height) {
            return "This sector is not used - the physical file size makes it unnecessary";
        }
        int width = (grid.width - 1) / 8 + 1;
        StringBuilder text = this.getHeader("Volume Bit Map Block");
        int startRow = relativeBlock * 512 / width;
        int endRow = startRow + 512 / width;
        int block = startBit;
        int byteNo = 0;
        int row = startRow;
        while (row < endRow) {
            StringBuilder details = new StringBuilder();
            int col = 0;
            while (col < grid.width) {
                details.append(this.parent.isSectorFree(block++) ? ". " : "X ");
                ++col;
            }
            this.addText(text, this.buffer, byteNo, width, details.toString());
            byteNo += width;
            ++row;
        }
        text.deleteCharAt(text.length() - 1);
        return text.toString();
    }
}

