/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.prodos;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.applefile.ApplesoftBasicProgram;
import com.bytezone.diskbrowser.applefile.AssemblerProgram;
import com.bytezone.diskbrowser.applefile.BasicProgramGS;
import com.bytezone.diskbrowser.applefile.BasicTextFile;
import com.bytezone.diskbrowser.applefile.CharacterRom;
import com.bytezone.diskbrowser.applefile.DefaultAppleFile;
import com.bytezone.diskbrowser.applefile.DeviceDriver;
import com.bytezone.diskbrowser.applefile.DosMasterFile;
import com.bytezone.diskbrowser.applefile.DoubleHiResImage;
import com.bytezone.diskbrowser.applefile.ErrorMessageFile;
import com.bytezone.diskbrowser.applefile.ExoBuffer;
import com.bytezone.diskbrowser.applefile.FaddenHiResImage;
import com.bytezone.diskbrowser.applefile.FileSystemTranslator;
import com.bytezone.diskbrowser.applefile.FileTypeDescriptorTable;
import com.bytezone.diskbrowser.applefile.FinderData;
import com.bytezone.diskbrowser.applefile.FontFile;
import com.bytezone.diskbrowser.applefile.HiResImage;
import com.bytezone.diskbrowser.applefile.IconFile;
import com.bytezone.diskbrowser.applefile.IntegerBasicProgram;
import com.bytezone.diskbrowser.applefile.LodeRunner;
import com.bytezone.diskbrowser.applefile.MerlinSource;
import com.bytezone.diskbrowser.applefile.ObjectModule;
import com.bytezone.diskbrowser.applefile.OriginalHiResImage;
import com.bytezone.diskbrowser.applefile.PascalArea;
import com.bytezone.diskbrowser.applefile.PascalCode;
import com.bytezone.diskbrowser.applefile.ProdosDirectory;
import com.bytezone.diskbrowser.applefile.QuickDrawFont;
import com.bytezone.diskbrowser.applefile.SHRPictureFile1;
import com.bytezone.diskbrowser.applefile.SHRPictureFile2;
import com.bytezone.diskbrowser.applefile.Selector;
import com.bytezone.diskbrowser.applefile.ShapeTable;
import com.bytezone.diskbrowser.applefile.SimpleText;
import com.bytezone.diskbrowser.applefile.StoredVariables;
import com.bytezone.diskbrowser.applefile.TextBuffer;
import com.bytezone.diskbrowser.appleworks.AppleworksADBFile;
import com.bytezone.diskbrowser.appleworks.AppleworksSSFile;
import com.bytezone.diskbrowser.appleworks.AppleworksWPFile;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.gui.DataSource;
import com.bytezone.diskbrowser.prodos.CatalogEntry;
import com.bytezone.diskbrowser.prodos.DirectoryHeader;
import com.bytezone.diskbrowser.prodos.ProdosConstants;
import com.bytezone.diskbrowser.prodos.ProdosDisk;
import com.bytezone.diskbrowser.prodos.ResourceFork;
import com.bytezone.diskbrowser.prodos.VolumeDirectoryHeader;
import com.bytezone.diskbrowser.utilities.Utility;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

class FileEntry
extends CatalogEntry
implements ProdosConstants {
    private final int fileType;
    final int keyPtr;
    private final int blocksUsed;
    private final int endOfFile;
    private final int auxType;
    private final LocalDateTime modified;
    private final int headerPointer;
    private DataSource file;
    private final DiskAddress catalogBlock;
    private ResourceFork resourceFork;
    private DiskAddress masterIndexBlock;
    private final List<DiskAddress> indexBlocks = new ArrayList<DiskAddress>();
    private boolean invalid;
    private FileEntry link;

    FileEntry(ProdosDisk fDisk, byte[] entryBuffer, DirectoryHeader parent, int parentBlock, int entryNo) {
        super(fDisk, entryBuffer, parentBlock, entryNo);
        assert (parent != null);
        this.parentDirectory = parent;
        this.catalogBlock = this.disk.getDiskAddress(parentBlock);
        this.fileType = entryBuffer[16] & 0xFF;
        this.keyPtr = Utility.getShort(entryBuffer, 17);
        this.blocksUsed = Utility.getShort(entryBuffer, 19);
        this.endOfFile = Utility.intValue(entryBuffer[21], entryBuffer[22], entryBuffer[23]);
        this.auxType = Utility.getShort(entryBuffer, 31);
        this.modified = Utility.getAppleDate(entryBuffer, 33);
        this.headerPointer = Utility.getShort(entryBuffer, 37);
        block0 : switch (this.storageType) {
            case 1: 
            case 2: 
            case 3: {
                this.addDataBlocks(this.storageType, this.keyPtr, this.dataBlocks);
                break;
            }
            case 5: {
                this.readForks();
                break;
            }
            case 13: {
                DiskAddress diskAddress;
                int block = this.keyPtr;
                while ((diskAddress = this.disk.getDiskAddress(block)) != null) {
                    this.dataBlocks.add(diskAddress);
                    byte[] buffer = this.disk.readBlock(block);
                    if ((block = Utility.getShort(buffer, 2)) > 0) continue;
                    break block0;
                }
                break;
            }
            case 4: {
                int i = this.keyPtr;
                while (i < this.disk.getTotalBlocks()) {
                    this.dataBlocks.add(this.disk.getDiskAddress(i));
                    this.parentDisk.setSectorType(i, this.parentDisk.dataSector);
                    ++i;
                }
                break;
            }
            default: {
                System.out.println("Unknown storage type: " + this.storageType);
            }
        }
    }

    private void readForks() {
        this.parentDisk.setSectorType(this.keyPtr, this.parentDisk.extendedKeySector);
        this.indexBlocks.add(this.disk.getDiskAddress(this.keyPtr));
        byte[] buffer2 = this.disk.readBlock(this.keyPtr);
        int i = 0;
        while (i < 512) {
            int storageType = buffer2[i] & 0xF;
            int keyBlock = Utility.getShort(buffer2, i + 1);
            int eof = Utility.readTriple(buffer2, i + 3);
            if (i < 256) {
                this.addDataBlocks(storageType, keyBlock, this.dataBlocks);
            } else {
                this.addDataBlocks(storageType, keyBlock, this.resourceBlocks);
            }
            i += 256;
        }
        this.resourceFork = new ResourceFork(this.disk.readBlocks(this.resourceBlocks));
        if (!this.resourceFork.isValid()) {
            System.out.printf("Invalid Resource Fork: %s%n", this.getUniqueName());
        }
    }

    private void addDataBlocks(int storageType, int keyPtr, List<DiskAddress> dataBlocks) {
        DiskAddress emptyDiskAddress = this.disk.getDiskAddress(0);
        ArrayList<Integer> blocks = new ArrayList<Integer>();
        switch (storageType) {
            case 1: {
                if (!this.isValid(keyPtr)) break;
                blocks.add(keyPtr);
                break;
            }
            case 2: {
                if (!this.isValid(keyPtr)) break;
                blocks.addAll(this.readIndex(keyPtr));
                break;
            }
            case 3: {
                if (!this.isValid(keyPtr)) break;
                for (Integer indexBlock : this.readMasterIndex(keyPtr)) {
                    if (!this.isValid(indexBlock)) continue;
                    blocks.addAll(this.readIndex(indexBlock));
                }
            }
        }
        while (blocks.size() > 0 && (Integer)blocks.get(blocks.size() - 1) == 0) {
            blocks.remove(blocks.size() - 1);
        }
        for (Integer block : blocks) {
            if (block == 0) {
                dataBlocks.add(emptyDiskAddress);
                continue;
            }
            this.parentDisk.setSectorType(block, this.parentDisk.dataSector);
            dataBlocks.add(this.disk.getDiskAddress(block));
        }
    }

    private List<Integer> readIndex(int blockPtr) {
        ArrayList<Integer> blocks = new ArrayList<Integer>(256);
        if (blockPtr == 0) {
            int i = 0;
            while (i < 256) {
                blocks.add(0);
                ++i;
            }
        } else {
            this.parentDisk.setSectorType(blockPtr, this.parentDisk.indexSector);
            this.indexBlocks.add(this.disk.getDiskAddress(blockPtr));
            byte[] buffer = this.disk.readBlock(blockPtr);
            int i = 0;
            while (i < 256) {
                int blockNo = buffer[i] & 0xFF | (buffer[i + 256] & 0xFF) << 8;
                blocks.add(this.isValid(blockNo) ? blockNo : 0);
                ++i;
            }
        }
        return blocks;
    }

    private List<Integer> readMasterIndex(int keyPtr) {
        this.masterIndexBlock = this.disk.getDiskAddress(keyPtr);
        this.parentDisk.setSectorType(keyPtr, this.parentDisk.masterIndexSector);
        this.indexBlocks.add(this.disk.getDiskAddress(keyPtr));
        byte[] buffer = this.disk.readBlock(keyPtr);
        int highest = 128;
        while (highest-- > 0) {
            if (buffer[highest] != 0 || buffer[highest + 256] != 0) break;
        }
        ArrayList<Integer> blocks = new ArrayList<Integer>(highest + 1);
        int i = 0;
        while (i <= highest) {
            int blockNo = buffer[i] & 0xFF | (buffer[i + 256] & 0xFF) << 8;
            blocks.add(this.isValid(blockNo) ? blockNo : 0);
            ++i;
        }
        return blocks;
    }

    private boolean isValid(int blockNo) {
        return this.disk.isValidAddress(blockNo) && !this.parentDisk.isSectorFree(blockNo);
    }

    @Override
    public DataSource getDataSource() {
        if (this.file != null) {
            return this.file;
        }
        if (this.invalid) {
            this.file = new DefaultAppleFile(this.name, null);
            return this.file;
        }
        if (this.fileType == 4 && this.auxType > 0) {
            return this.getRandomAccessTextFile();
        }
        byte[] buffer = this.getBuffer();
        byte[] exactBuffer = this.getExactBuffer(buffer);
        try {
            block1 : switch (this.fileType) {
                case 241: {
                    if (this.endOfFile == 8192 && this.auxType == 0) {
                        this.file = new OriginalHiResImage(this.name, exactBuffer, this.auxType);
                        break;
                    }
                    if (this.endOfFile == 2048 && "SELECTOR.LIST".equals(this.name)) {
                        this.file = new Selector(this.name, exactBuffer);
                        break;
                    }
                }
                case 6: 
                case 245: 
                case 254: 
                case 255: {
                    if (SimpleText.isHTML(exactBuffer)) {
                        this.file = new SimpleText(this.name, exactBuffer);
                        break;
                    }
                    if (HiResImage.isGif(exactBuffer) || HiResImage.isPng(exactBuffer)) {
                        this.file = new OriginalHiResImage(this.name, exactBuffer, this.auxType);
                        break;
                    }
                    if (this.name.endsWith(".BMP") && HiResImage.isBmp(exactBuffer)) {
                        this.file = new OriginalHiResImage(this.name, exactBuffer, this.auxType);
                        break;
                    }
                    if (this.name.endsWith(".3200")) {
                        this.file = new SHRPictureFile2(this.name, exactBuffer, 193, 2, this.endOfFile);
                        break;
                    }
                    if (this.name.endsWith(".3201") || HiResImage.isAPP(exactBuffer)) {
                        this.file = new SHRPictureFile2(this.name, exactBuffer, 192, 99, this.endOfFile);
                        break;
                    }
                    if (this.name.endsWith(".FNT") && FontFile.isFont(exactBuffer)) {
                        this.file = new FontFile(this.name, exactBuffer, this.auxType);
                        break;
                    }
                    if (this.name.endsWith(".FONT") && FontFile.isFont(exactBuffer)) {
                        this.file = new FontFile(this.name, exactBuffer, this.auxType);
                        break;
                    }
                    if (ShapeTable.isShapeTable(exactBuffer)) {
                        this.file = new ShapeTable(this.name, exactBuffer);
                        break;
                    }
                    if (this.link != null) {
                        if (this.name.endsWith(".AUX")) {
                            this.file = new DoubleHiResImage(this.name, this.link.getBuffer(), exactBuffer);
                            break;
                        }
                        this.file = new DoubleHiResImage(this.name, exactBuffer, this.link.getBuffer());
                        break;
                    }
                    if (this.name.endsWith(".PAC") || this.name.endsWith(".A2FC") || this.endOfFile == 16384 && this.auxType == 8192) {
                        this.file = new DoubleHiResImage(this.name, exactBuffer);
                        break;
                    }
                    if (this.endOfFile == 16384 && this.auxType == 16384) {
                        this.file = new DoubleHiResImage(this.name, exactBuffer);
                        break;
                    }
                    if (ExoBuffer.isExomizer(exactBuffer, this.auxType)) {
                        ExoBuffer exoBuffer = new ExoBuffer(exactBuffer);
                        byte[] outBuffer = exoBuffer.getExpandedBuffer();
                        switch (outBuffer.length) {
                            case 8192: {
                                this.file = new OriginalHiResImage(this.name, outBuffer, 16384);
                                break block1;
                            }
                            case 16384: {
                                this.file = new DoubleHiResImage(this.name, outBuffer);
                                break block1;
                            }
                            case 32768: {
                                this.file = new SHRPictureFile2(this.name, outBuffer, 193, 8192, 32768);
                                break block1;
                            }
                        }
                        this.file = new AssemblerProgram(this.name, exactBuffer, this.auxType);
                        break;
                    }
                    if (this.oneOf(this.endOfFile, 8184, 8191, 8192, 16384) && this.oneOf(this.auxType, 8191, 8192, 16384, 24576)) {
                        this.file = new OriginalHiResImage(this.name, exactBuffer, this.auxType);
                        break;
                    }
                    if (this.endOfFile == 38400 && this.name.startsWith("LVL.")) {
                        this.file = new LodeRunner(this.name, exactBuffer);
                        break;
                    }
                    if (this.auxType == 4096 && CharacterRom.isRom(exactBuffer)) {
                        this.file = new CharacterRom(this.name, exactBuffer);
                        break;
                    }
                    if (this.auxType == 0 && this.endOfFile == 32768) {
                        this.file = new SHRPictureFile2(this.name, exactBuffer, 193, 0, this.endOfFile);
                        break;
                    }
                    if ((this.name.equals("DOS.3.3") || this.name.equals("DDOS.3.3")) && this.endOfFile == 10240 && DosMasterFile.isDos33(this.parentDisk, exactBuffer)) {
                        this.file = new DosMasterFile(this.name, exactBuffer);
                        break;
                    }
                    this.file = new AssemblerProgram(this.name, exactBuffer, this.auxType);
                    if (exactBuffer.length < buffer.length) {
                        ((AssemblerProgram)this.file).setExtraBuffer(buffer, exactBuffer.length, buffer.length - exactBuffer.length);
                    }
                    break;
                }
                case 4: {
                    assert (this.auxType == 0);
                    if (this.name.endsWith(".S")) {
                        this.file = new MerlinSource(this.name, exactBuffer, this.auxType, this.endOfFile);
                        break;
                    }
                    if (this.name.endsWith("PLA")) {
                        this.file = new SimpleText(this.name, exactBuffer);
                        break;
                    }
                    if (this.name.endsWith(".GIF") && HiResImage.isGif(exactBuffer)) {
                        this.file = new OriginalHiResImage(this.name, exactBuffer, this.auxType);
                        break;
                    }
                    this.file = new BasicTextFile(this.name, exactBuffer, this.auxType, this.endOfFile);
                    break;
                }
                case 252: {
                    this.file = new ApplesoftBasicProgram(this.name, exactBuffer);
                    break;
                }
                case 171: {
                    if (buffer[0] == 4 && buffer[1] == 16) {
                        this.file = new BasicProgramGS(this.name, exactBuffer);
                        break;
                    }
                    this.file = new DefaultAppleFile(this.name, exactBuffer);
                    break;
                }
                case 250: {
                    this.file = new IntegerBasicProgram(this.name, exactBuffer);
                    break;
                }
                case 15: {
                    VolumeDirectoryHeader vdh = this.parentDisk.getVolumeDirectoryHeader();
                    this.file = new ProdosDirectory(this.parentDisk, this.name, buffer, vdh.totalBlocks, vdh.freeBlocks, vdh.usedBlocks);
                    break;
                }
                case 253: {
                    if (this.endOfFile == 0) {
                        System.out.println("Stored Variables EOF = 0");
                        this.file = new StoredVariables(this.name, buffer);
                        break;
                    }
                    this.file = new StoredVariables(this.name, exactBuffer);
                    break;
                }
                case 226: {
                    this.file = new DefaultAppleFile(String.valueOf(this.name) + " (Appletalk file)", buffer);
                    break;
                }
                case 80: {
                    this.file = new SimpleText(this.name, exactBuffer);
                    break;
                }
                case 26: {
                    this.file = new AppleworksWPFile(String.valueOf(this.name) + " (Appleworks Word Processor)", buffer);
                    break;
                }
                case 25: {
                    this.file = new AppleworksADBFile(String.valueOf(this.name) + " (Appleworks Database File)", buffer);
                    break;
                }
                case 27: {
                    this.file = new AppleworksSSFile(String.valueOf(this.name) + " (Appleworks Spreadsheet File)", buffer);
                    break;
                }
                case 176: {
                    this.file = new SimpleText(this.name, exactBuffer);
                    break;
                }
                case 179: {
                    this.file = new ObjectModule(this.name, exactBuffer, this.auxType);
                    break;
                }
                case 187: {
                    this.file = new DeviceDriver(this.name, exactBuffer, this.auxType);
                    break;
                }
                case 183: {
                    this.file = new DefaultAppleFile(this.name, exactBuffer);
                    break;
                }
                case 202: {
                    this.file = new IconFile(this.name, exactBuffer);
                    break;
                }
                case 192: {
                    if (this.auxType == 2) {
                        this.file = new SHRPictureFile1(this.name, exactBuffer, this.fileType, this.auxType, this.endOfFile);
                        break;
                    }
                    if (this.endOfFile < 546) {
                        this.file = new DefaultAppleFile(this.name, exactBuffer);
                        break;
                    }
                    this.file = new SHRPictureFile2(this.name, exactBuffer, this.fileType, this.auxType, this.endOfFile);
                    break;
                }
                case 194: {
                    this.file = new SHRPictureFile2(this.name, exactBuffer, this.fileType, this.auxType, this.endOfFile);
                    break;
                }
                case 193: {
                    this.file = new SHRPictureFile2(this.name, exactBuffer, this.fileType, this.auxType, this.endOfFile);
                    break;
                }
                case 8: {
                    if (this.auxType == 32870) {
                        this.file = new FaddenHiResImage(this.name, exactBuffer, this.fileType, this.auxType, this.endOfFile);
                        break;
                    }
                    if (this.auxType < 16384) {
                        this.file = new OriginalHiResImage(this.name, exactBuffer, 8192);
                        System.out.printf("FOT %02X%n", exactBuffer[121]);
                        break;
                    }
                    if (this.auxType == 16384) {
                        System.out.println("FOT - packed hi res");
                        this.file = new DefaultAppleFile(this.name, exactBuffer);
                        break;
                    }
                    if (this.auxType == 16385) {
                        System.out.println("FOT - double hi res");
                        this.file = new DefaultAppleFile(this.name, exactBuffer);
                        break;
                    }
                    this.file = new DefaultAppleFile(this.name, exactBuffer);
                    break;
                }
                case 7: {
                    this.file = new FontFile(this.name, exactBuffer, this.auxType);
                    break;
                }
                case 200: {
                    this.file = new QuickDrawFont(this.name, exactBuffer, this.fileType, this.auxType);
                    break;
                }
                case 66: {
                    this.file = new FileTypeDescriptorTable(this.name, exactBuffer);
                    break;
                }
                case 189: {
                    this.file = new FileSystemTranslator(this.name, exactBuffer);
                    break;
                }
                case 239: {
                    this.file = new PascalArea(this.name, exactBuffer);
                    break;
                }
                case 130: 
                case 177: 
                case 188: 
                case 195: {
                    this.file = new DefaultAppleFile(this.name, exactBuffer);
                    break;
                }
                case 2: {
                    this.file = new PascalCode(this.name, exactBuffer, 0);
                    break;
                }
                case 0: {
                    if (this.name.endsWith(".TIFF") && HiResImage.isTiff(exactBuffer)) {
                        this.file = new OriginalHiResImage(this.name, exactBuffer, this.auxType);
                        break;
                    }
                    this.file = new DefaultAppleFile(this.name, exactBuffer);
                    break;
                }
                case 201: {
                    this.file = new FinderData(this.name, exactBuffer);
                    break;
                }
                default: {
                    this.file = new DefaultAppleFile(this.name, exactBuffer);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.file = new ErrorMessageFile(this.name, buffer, e);
            e.printStackTrace();
        }
        if (this.resourceFork != null) {
            ((AbstractFile)this.file).setResourceFork(this.resourceFork);
        }
        return this.file;
    }

    private boolean oneOf(int val, int ... values) {
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int value = nArray[n2];
            if (val == value) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private DataSource getRandomAccessTextFile() {
        switch (this.storageType) {
            case 3: {
                return this.getTreeTextFile();
            }
            case 2: {
                return this.getSaplingTextFile();
            }
            case 1: {
                return this.getSeedlingTextFile();
            }
        }
        System.out.println("Impossible: text file: " + this.storageType);
        return null;
    }

    private DataSource getTreeTextFile() {
        ArrayList<TextBuffer> buffers = new ArrayList<TextBuffer>();
        ArrayList<DiskAddress> addresses = new ArrayList<DiskAddress>();
        int logicalBlock = 0;
        byte[] mainIndexBuffer = this.disk.readBlock(this.keyPtr);
        int i = 0;
        while (i < 256) {
            int indexBlock = Utility.intValue(mainIndexBuffer[i], mainIndexBuffer[i + 256]);
            if (indexBlock > 0) {
                logicalBlock = this.readIndexBlock(indexBlock, addresses, buffers, logicalBlock);
            } else {
                if (addresses.size() > 0) {
                    byte[] tempBuffer = this.disk.readBlocks(addresses);
                    buffers.add(new TextBuffer(tempBuffer, this.auxType, logicalBlock - addresses.size()));
                    addresses.clear();
                }
                logicalBlock += 256;
            }
            ++i;
        }
        if (buffers.size() == 1 && this.name.endsWith(".S")) {
            return new MerlinSource(this.name, ((TextBuffer)buffers.get((int)0)).buffer, this.auxType, this.endOfFile);
        }
        return new BasicTextFile(this.name, buffers, this.auxType, this.endOfFile);
    }

    private DataSource getSaplingTextFile() {
        ArrayList<TextBuffer> buffers = new ArrayList<TextBuffer>();
        ArrayList<DiskAddress> addresses = new ArrayList<DiskAddress>();
        this.readIndexBlock(this.keyPtr, addresses, buffers, 0);
        if (buffers.size() == 1 && this.name.endsWith(".S")) {
            return new MerlinSource(this.name, ((TextBuffer)buffers.get((int)0)).buffer, this.auxType, this.endOfFile);
        }
        return new BasicTextFile(this.name, buffers, this.auxType, this.endOfFile);
    }

    private DataSource getSeedlingTextFile() {
        byte[] buffer = this.getBuffer();
        if (this.endOfFile < buffer.length) {
            byte[] exactBuffer = new byte[this.endOfFile];
            System.arraycopy(buffer, 0, exactBuffer, 0, this.endOfFile);
            buffer = exactBuffer;
        }
        if (this.name.endsWith(".S")) {
            return new MerlinSource(this.name, buffer, this.auxType, this.endOfFile);
        }
        return new BasicTextFile(this.name, buffer, this.auxType, this.endOfFile);
    }

    private byte[] getBuffer() {
        switch (this.storageType) {
            case 1: 
            case 2: 
            case 3: {
                return this.disk.readBlocks(this.dataBlocks);
            }
            case 13: {
                byte[] fullBuffer = new byte[this.dataBlocks.size() * 507];
                int offset = 0;
                for (DiskAddress da : this.dataBlocks) {
                    byte[] buffer = this.disk.readBlock(da);
                    System.arraycopy(buffer, 4, fullBuffer, offset, 507);
                    offset += 507;
                }
                return fullBuffer;
            }
            case 5: {
                return this.disk.readBlocks(this.dataBlocks);
            }
            case 4: {
                return this.disk.readBlocks(this.dataBlocks);
            }
        }
        System.out.println("Unknown storage type in getBuffer : " + this.storageType);
        return new byte[512];
    }

    private byte[] getExactBuffer(byte[] buffer) {
        byte[] exactBuffer;
        if (buffer.length < this.endOfFile) {
            exactBuffer = new byte[this.endOfFile];
            System.arraycopy(buffer, 0, exactBuffer, 0, buffer.length);
        } else if (buffer.length == this.endOfFile || this.endOfFile == 512 || this.endOfFile == 0) {
            exactBuffer = buffer;
        } else {
            exactBuffer = new byte[this.endOfFile];
            System.arraycopy(buffer, 0, exactBuffer, 0, this.endOfFile);
        }
        return exactBuffer;
    }

    private int readIndexBlock(int indexBlock, List<DiskAddress> addresses, List<TextBuffer> buffers, int logicalBlock) {
        byte[] indexBuffer = this.disk.readBlock(indexBlock);
        int j = 0;
        while (j < 256) {
            int block = Utility.intValue(indexBuffer[j], indexBuffer[j + 256]);
            if (block > 0) {
                addresses.add(this.disk.getDiskAddress(block));
            } else if (addresses.size() > 0) {
                byte[] tempBuffer = this.disk.readBlocks(addresses);
                buffers.add(new TextBuffer(tempBuffer, this.auxType, logicalBlock - addresses.size()));
                addresses.clear();
            }
            ++logicalBlock;
            ++j;
        }
        return logicalBlock;
    }

    @Override
    public List<DiskAddress> getSectors() {
        ArrayList<DiskAddress> sectors = new ArrayList<DiskAddress>();
        sectors.add(this.catalogBlock);
        if (this.masterIndexBlock != null) {
            sectors.add(this.masterIndexBlock);
        }
        sectors.addAll(this.indexBlocks);
        sectors.addAll(this.dataBlocks);
        sectors.addAll(this.resourceBlocks);
        return sectors;
    }

    @Override
    public boolean contains(DiskAddress da) {
        if (da == null) {
            return false;
        }
        if (da.equals(this.masterIndexBlock)) {
            return true;
        }
        for (DiskAddress block : this.indexBlocks) {
            if (!da.matches(block)) continue;
            return true;
        }
        for (DiskAddress block : this.dataBlocks) {
            if (!da.matches(block)) continue;
            return true;
        }
        for (DiskAddress block : this.resourceBlocks) {
            if (!da.matches(block)) continue;
            return true;
        }
        return false;
    }

    void link(FileEntry fileEntry) {
        this.link = fileEntry;
    }

    @Override
    public String toString() {
        if (ProdosConstants.fileTypes[this.fileType].equals("DIR")) {
            return this.name;
        }
        String locked = this.access == 0 ? "*" : " ";
        return String.valueOf(String.format("%s  %03d %s", ProdosConstants.fileTypes[this.fileType], this.blocksUsed, locked)) + this.name;
    }
}

