/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.prodos;

import com.bytezone.diskbrowser.prodos.CatalogEntry;
import com.bytezone.diskbrowser.prodos.ProdosConstants;
import com.bytezone.diskbrowser.prodos.ProdosDisk;
import com.bytezone.diskbrowser.utilities.Utility;

public abstract class DirectoryHeader
extends CatalogEntry
implements ProdosConstants {
    final int entryLength;
    final int entriesPerBlock;
    final int fileCount;

    DirectoryHeader(ProdosDisk parentDisk, byte[] entryBuffer, int blockNo, int entryNo) {
        super(parentDisk, entryBuffer, blockNo, entryNo);
        this.entryLength = entryBuffer[31] & 0xFF;
        this.entriesPerBlock = entryBuffer[32] & 0xFF;
        this.fileCount = Utility.getShort(entryBuffer, 33);
    }

    @Override
    public String getText() {
        return String.format("%s  %04X", super.getText(), this.fileCount);
    }

    public void listFileEntries(StringBuilder text) {
        byte[] buffer;
        int blockNo = this.blockNo;
        do {
            buffer = this.disk.readBlock(blockNo);
            int ptr = 4;
            int entryNo = 1;
            int i = 0;
            while (i < 13) {
                int nameLength = buffer[ptr] & 0xF;
                int storageType = (buffer[ptr] & 0xF0) >>> 4;
                if (nameLength > 0 && storageType < 14) {
                    String name = new String(buffer, ptr + 1, nameLength);
                    int blocksUsed = Utility.getShort(buffer, ptr + 19);
                    int fileType = buffer[ptr + 16] & 0xFF;
                    int keyPointer = Utility.getShort(buffer, ptr + 17);
                    int headerPointer = Utility.getShort(buffer, ptr + 37);
                    text.append(String.format("%04X:%02X  %-15s  %s  %04X  %s  %04X  %04X%n", blockNo, entryNo, name, storageTypes[storageType], blocksUsed, fileTypes[fileType], keyPointer, headerPointer));
                }
                ptr += 39;
                ++entryNo;
                ++i;
            }
        } while ((blockNo = Utility.getShort(buffer, 2)) != 0);
    }
}

