/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.prodos;

import com.bytezone.diskbrowser.applefile.AppleFileSource;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.prodos.DirectoryHeader;
import com.bytezone.diskbrowser.prodos.ProdosDisk;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.utilities.Utility;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

abstract class CatalogEntry
implements AppleFileSource {
    static String[] storageTypes = new String[]{"Del", "Sdl", "Sap", "Tre", "Pas", "Ext", "", "", "", "", "", "", "", "DIR", "SDH", "VDH"};
    Disk disk;
    ProdosDisk parentDisk;
    int blockNo;
    int entryNo;
    String name;
    int storageType;
    LocalDateTime created;
    int version;
    int minVersion;
    int access;
    List<DiskAddress> dataBlocks = new ArrayList<DiskAddress>();
    List<DiskAddress> resourceBlocks = new ArrayList<DiskAddress>();
    DirectoryHeader parentDirectory;

    CatalogEntry(ProdosDisk parentDisk, byte[] entryBuffer, int blockNo, int entryNo) {
        this.parentDisk = parentDisk;
        this.disk = parentDisk.getDisk();
        this.blockNo = blockNo;
        this.entryNo = entryNo;
        this.name = HexFormatter.getString(entryBuffer, 1, entryBuffer[0] & 0xF);
        this.storageType = (entryBuffer[0] & 0xF0) >> 4;
        this.created = Utility.getAppleDate(entryBuffer, 24);
        this.version = entryBuffer[28] & 0xFF;
        this.minVersion = entryBuffer[29] & 0xFF;
        this.access = entryBuffer[30] & 0xFF;
    }

    public String getName() {
        return this.name;
    }

    public String getText() {
        return String.format("%04X:%02X  %-15s  %s", this.blockNo, this.entryNo, this.name, storageTypes[this.storageType]);
    }

    @Override
    public String getUniqueName() {
        if (this.parentDirectory == null) {
            return this.name;
        }
        return String.valueOf(this.parentDirectory.getUniqueName()) + "/" + this.name;
    }

    @Override
    public FormattedDisk getFormattedDisk() {
        return this.parentDisk;
    }

    @Override
    public boolean contains(DiskAddress da) {
        for (DiskAddress diskAddress : this.dataBlocks) {
            if (!diskAddress.matches(da)) continue;
            return true;
        }
        for (DiskAddress diskAddress : this.resourceBlocks) {
            if (!diskAddress.matches(da)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append(String.format("Name .......... %s%n", this.name));
        text.append(String.format("Storage type... %02X%n", this.storageType));
        text.append(String.format("Created ....... %s%n", this.created == null ? "" : this.created.format(ProdosDisk.df)));
        text.append(String.format("Version ....... %d%n", this.version));
        return text.toString();
    }
}

