/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.pascal;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.applefile.DefaultAppleFile;
import com.bytezone.diskbrowser.pascal.CatalogEntry;
import com.bytezone.diskbrowser.pascal.PascalDisk;
import com.bytezone.diskbrowser.utilities.Utility;

class VolumeEntry
extends CatalogEntry {
    final int totalFiles;
    final int totalBlocks;

    VolumeEntry(PascalDisk parent, byte[] buffer) {
        super(parent, buffer);
        this.totalBlocks = Utility.getShort(buffer, 14);
        this.totalFiles = Utility.getShort(buffer, 16);
        this.date = Utility.getPascalDate(buffer, 20);
    }

    @Override
    public AbstractFile getDataSource() {
        if (this.file != null) {
            return this.file;
        }
        byte[] buffer = this.parent.getDisk().readBlocks(this.blocks);
        this.file = new DefaultAppleFile(this.name, buffer);
        return this.file;
    }
}

