/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.pascal;

import com.bytezone.diskbrowser.applefile.AppleFileSource;
import com.bytezone.diskbrowser.applefile.BootSector;
import com.bytezone.diskbrowser.disk.AbstractFormattedDisk;
import com.bytezone.diskbrowser.disk.AppleDisk;
import com.bytezone.diskbrowser.disk.DefaultAppleFileSource;
import com.bytezone.diskbrowser.disk.DefaultSector;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.disk.SectorType;
import com.bytezone.diskbrowser.gui.DataSource;
import com.bytezone.diskbrowser.pascal.CatalogEntry;
import com.bytezone.diskbrowser.pascal.FileEntry;
import com.bytezone.diskbrowser.pascal.PascalCatalogSector;
import com.bytezone.diskbrowser.pascal.VolumeEntry;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.utilities.Utility;
import com.bytezone.diskbrowser.wizardry.Relocator;
import java.awt.Color;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

public class PascalDisk
extends AbstractFormattedDisk {
    static final int CATALOG_ENTRY_SIZE = 26;
    private final DateFormat df = DateFormat.getDateInstance(3);
    private final VolumeEntry volumeEntry;
    private final PascalCatalogSector diskCatalogSector;
    protected Relocator relocator;
    final String[] fileTypes = new String[]{"Volume", "Bad ", "Code", "Text", "Info", "Data", "Graf", "Foto", "SecureDir"};
    SectorType diskBootSector = new SectorType("Boot", Color.lightGray);
    SectorType catalogSector = new SectorType("Catalog", Color.magenta);
    SectorType dataSector = new SectorType("Data", new Color(0, 200, 0));
    SectorType codeSector = new SectorType("Code", Color.red);
    SectorType textSector = new SectorType("Text", Color.blue);
    SectorType infoSector = new SectorType("Info", Color.orange);
    SectorType grafSector = new SectorType("Graf", Color.cyan);
    SectorType fotoSector = new SectorType("Foto", Color.gray);
    SectorType badSector = new SectorType("Bad", Color.darkGray);
    SectorType[] sectors = new SectorType[]{this.catalogSector, this.badSector, this.codeSector, this.textSector, this.infoSector, this.dataSector, this.grafSector, this.fotoSector};

    public PascalDisk(Disk disk) {
        super(disk);
        this.sectorTypesList.add(this.diskBootSector);
        this.sectorTypesList.add(this.catalogSector);
        this.sectorTypesList.add(this.dataSector);
        this.sectorTypesList.add(this.codeSector);
        this.sectorTypesList.add(this.textSector);
        this.sectorTypesList.add(this.infoSector);
        this.sectorTypesList.add(this.grafSector);
        this.sectorTypesList.add(this.fotoSector);
        this.sectorTypesList.add(this.badSector);
        List<DiskAddress> blocks = disk.getDiskAddressList(0, 1);
        this.bootSector = new BootSector(disk, disk.readBlocks(blocks), "Pascal");
        int i = 0;
        while (i < 2) {
            if (!disk.isBlockEmpty(i)) {
                this.sectorTypes[i] = this.diskBootSector;
                this.freeBlocks.set(i, false);
            }
            ++i;
        }
        i = 2;
        while (i < disk.getTotalBlocks()) {
            this.freeBlocks.set(i, true);
            ++i;
        }
        byte[] buffer = disk.readBlock(2);
        byte[] data = new byte[26];
        System.arraycopy(buffer, 0, data, 0, 26);
        this.volumeEntry = new VolumeEntry(this, data);
        DefaultMutableTreeNode root = this.getCatalogTreeRoot();
        DefaultMutableTreeNode volumeNode = new DefaultMutableTreeNode(this.volumeEntry);
        root.add(volumeNode);
        ArrayList<DiskAddress> sectors = new ArrayList<DiskAddress>();
        int max = Math.min(this.volumeEntry.lastBlock, disk.getTotalBlocks());
        int i2 = 2;
        while (i2 < max) {
            DiskAddress da = disk.getDiskAddress(i2);
            if (!disk.isBlockEmpty(da)) {
                this.sectorTypes[i2] = this.catalogSector;
            }
            sectors.add(da);
            this.freeBlocks.set(i2, false);
            ++i2;
        }
        this.diskCatalogSector = new PascalCatalogSector(disk, disk.readBlocks(sectors), sectors);
        ArrayList<DiskAddress> addresses = new ArrayList<DiskAddress>();
        int i3 = 2;
        while (i3 < max) {
            addresses.add(disk.getDiskAddress(i3));
            ++i3;
        }
        buffer = disk.readBlocks(addresses);
        i3 = 1;
        while (i3 <= this.volumeEntry.totalFiles) {
            int ptr = i3 * 26;
            data = new byte[26];
            System.arraycopy(buffer, ptr, data, 0, 26);
            FileEntry fileEntry = new FileEntry(this, data);
            this.fileEntries.add(fileEntry);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(fileEntry);
            fileEntry.setNode(node);
            if (fileEntry.fileType == 2) {
                node.setAllowsChildren(true);
                fileEntry.getDataSource();
            } else {
                node.setAllowsChildren(false);
            }
            volumeNode.add(node);
            int j = fileEntry.firstBlock;
            while (j < fileEntry.lastBlock) {
                this.freeBlocks.set(j, false);
                ++j;
            }
            ++i3;
        }
        volumeNode.setUserObject(this.getCatalog());
        this.makeNodeVisible(volumeNode.getFirstLeaf());
    }

    public static boolean isCorrectFormat(AppleDisk disk, boolean debug) {
        disk.setInterleave(1);
        if (PascalDisk.checkFormat(disk, debug)) {
            return true;
        }
        disk.setInterleave(0);
        return PascalDisk.checkFormat(disk, debug);
    }

    private static boolean checkFormat(AppleDisk disk, boolean debug) {
        byte[] buffer = disk.readBlock(2);
        int nameLength = buffer[6] & 0xFF;
        if (nameLength < 1 || nameLength > 7) {
            if (debug) {
                System.out.println("bad name length : " + nameLength);
            }
            return false;
        }
        if (debug) {
            String name = HexFormatter.getPascalString(buffer, 6);
            System.out.println("Name ok : " + name);
        }
        int from = Utility.getShort(buffer, 0);
        int to = Utility.getShort(buffer, 2);
        if (from != 0 || to != 6) {
            if (debug) {
                System.out.printf("from: %d, to: %d%n", from, to);
            }
            return false;
        }
        int blocks = Utility.getShort(buffer, 14);
        if (blocks != 280 && blocks != 1600) {
            if (debug) {
                System.out.printf("Blocks > 280: %d%n", blocks);
            }
            return false;
        }
        ArrayList<DiskAddress> addresses = new ArrayList<DiskAddress>();
        int i = 2;
        while (i < to) {
            addresses.add(disk.getDiskAddress(i));
            ++i;
        }
        buffer = disk.readBlocks(addresses);
        int files = Utility.getShort(buffer, 16);
        if (files < 0 || files > 77) {
            if (debug) {
                System.out.printf("Files: %d%n", files);
            }
            return false;
        }
        if (debug) {
            System.out.println("Files found : " + files);
        }
        int i2 = 1;
        while (i2 <= files) {
            int ptr = i2 * 26;
            int firstBlock = Utility.getShort(buffer, ptr);
            int lastBlock = Utility.getShort(buffer, ptr + 2);
            int kind = Utility.getShort(buffer, ptr + 4);
            if (lastBlock < firstBlock) {
                return false;
            }
            if (kind == 0) {
                return false;
            }
            nameLength = buffer[ptr + 6] & 0xFF;
            if (nameLength < 1 || nameLength > 15) {
                return false;
            }
            int lastByte = Utility.getShort(buffer, ptr + 22);
            GregorianCalendar date = Utility.getPascalDate(buffer, 24);
            if (debug) {
                System.out.printf("%4d  %4d  %d  %-15s %d %s%n", firstBlock, lastBlock, kind, new String(buffer, ptr + 7, nameLength), lastByte, date);
            }
            ++i2;
        }
        return true;
    }

    @Override
    public DataSource getFormattedSector(DiskAddress da) {
        SectorType st = this.sectorTypes[da.getBlockNo()];
        if (st == this.diskBootSector) {
            return this.bootSector;
        }
        if (st == this.catalogSector) {
            return this.diskCatalogSector;
        }
        String name = this.getSectorFilename(da);
        if (name != null) {
            return new DefaultSector(name, this.disk, this.disk.readBlock(da), da);
        }
        return super.getFormattedSector(da);
    }

    @Override
    public String getSectorFilename(DiskAddress da) {
        for (AppleFileSource ce : this.fileEntries) {
            if (!((CatalogEntry)ce).contains(da)) continue;
            return ((CatalogEntry)ce).name;
        }
        return null;
    }

    @Override
    public List<DiskAddress> getFileSectors(int fileNo) {
        if (fileNo < 0 || fileNo >= this.fileEntries.size()) {
            return null;
        }
        return ((AppleFileSource)this.fileEntries.get(fileNo)).getSectors();
    }

    public DataSource getFile(int fileNo) {
        if (fileNo < 0 || fileNo >= this.fileEntries.size()) {
            return null;
        }
        return ((AppleFileSource)this.fileEntries.get(fileNo)).getDataSource();
    }

    @Override
    public AppleFileSource getCatalog() {
        String newLine = String.format("%n", new Object[0]);
        String newLine2 = String.valueOf(newLine) + newLine;
        String line = "----   ---------------   ----   --------  -------   ----   ----   ----" + newLine;
        String date = this.volumeEntry.date == null ? "--" : this.df.format(this.volumeEntry.date.getTime());
        StringBuilder text = new StringBuilder();
        text.append("File : " + this.getDisplayPath() + newLine2);
        text.append("Volume : " + this.volumeEntry.name + newLine);
        text.append("Date   : " + date + newLine2);
        text.append("Blks   Name              Type     Date     Length   Frst   Last   Blks\n");
        text.append(line);
        int usedBlocks = 6;
        for (AppleFileSource fe : this.fileEntries) {
            FileEntry ce = (FileEntry)fe;
            int size = ce.lastBlock - ce.firstBlock;
            usedBlocks += size;
            date = ce.date == null ? "--" : this.df.format(ce.date.getTime());
            int bytes = (size - 1) * 512 + ce.bytesUsedInLastBlock;
            String fileType = ce.fileType < 0 || ce.fileType >= this.fileTypes.length ? "????" : this.fileTypes[ce.fileType];
            text.append(String.format("%4d   %-15s   %s   %8s %,8d   $%03X   $%03X   $%03X%n", size, ce.name, fileType, date, bytes, ce.firstBlock, ce.lastBlock, size));
        }
        text.append(line);
        text.append(String.format("Blocks free : %3d  Blocks used : %3d  Total blocks : %3d%n", this.volumeEntry.totalBlocks - usedBlocks, usedBlocks, this.volumeEntry.totalBlocks));
        return new DefaultAppleFileSource(this.volumeEntry.name, text.toString(), (FormattedDisk)this);
    }
}

