/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.pascal;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.applefile.AppleFileSource;
import com.bytezone.diskbrowser.applefile.PascalSegment;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.gui.DataSource;
import com.bytezone.diskbrowser.pascal.PascalDisk;
import java.util.ArrayList;
import java.util.List;

class PascalCodeObject
implements AppleFileSource {
    private final PascalDisk parent;
    private final AbstractFile segment;
    private final List<DiskAddress> blocks = new ArrayList<DiskAddress>();

    PascalCodeObject(PascalDisk parent, PascalSegment segment, int firstBlock) {
        this.parent = parent;
        this.segment = segment;
        int lo = firstBlock + segment.blockNo;
        int hi = lo + (segment.size - 1) / 512;
        Disk disk = parent.getDisk();
        int max = Math.min(hi, 279);
        int i = lo;
        while (i <= max) {
            this.blocks.add(disk.getDiskAddress(i));
            ++i;
        }
    }

    @Override
    public DataSource getDataSource() {
        return this.segment;
    }

    @Override
    public FormattedDisk getFormattedDisk() {
        return this.parent;
    }

    @Override
    public List<DiskAddress> getSectors() {
        return this.blocks;
    }

    @Override
    public boolean contains(DiskAddress da) {
        for (DiskAddress sector : this.blocks) {
            if (!sector.matches(da)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getUniqueName() {
        return this.segment.getName();
    }

    public String toString() {
        return this.segment.getName();
    }
}

