/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.pascal;

import com.bytezone.diskbrowser.disk.AbstractSector;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.utilities.Utility;
import java.text.DateFormat;
import java.util.GregorianCalendar;
import java.util.List;

class PascalCatalogSector
extends AbstractSector {
    private final DateFormat df = DateFormat.getDateInstance(3);
    private static String[] fileTypes = new String[]{"Volume", "Bad", "Code", "Text", "Info", "Data", "Graf", "Foto", "SecureDir"};

    PascalCatalogSector(Disk disk, byte[] buffer, List<DiskAddress> diskAddress) {
        super(disk, buffer);
    }

    @Override
    public String createText() {
        StringBuilder text = this.getHeader("Pascal Catalog Sectors");
        this.addTextAndDecimal(text, this.buffer, 0, 2, "First directory block");
        this.addTextAndDecimal(text, this.buffer, 2, 2, "Last directory block");
        this.addText(text, this.buffer, 4, 2, "File type : " + fileTypes[this.buffer[5]]);
        String name = HexFormatter.getPascalString(this.buffer, 6);
        this.addText(text, this.buffer, 6, 4, "");
        this.addText(text, this.buffer, 10, 4, "Volume name : " + name);
        this.addTextAndDecimal(text, this.buffer, 14, 2, "Blocks on disk");
        this.addTextAndDecimal(text, this.buffer, 16, 2, "Files on disk");
        this.addTextAndDecimal(text, this.buffer, 18, 2, "First block of volume");
        GregorianCalendar calendar = Utility.getPascalDate(this.buffer, 20);
        String date = calendar == null ? "--" : this.df.format(calendar.getTime());
        this.addText(text, this.buffer, 20, 2, "Most recent date setting : " + date);
        this.addTextAndDecimal(text, this.buffer, 22, 4, "Reserved");
        int ptr = 26;
        int totalFiles = Utility.getShort(this.buffer, 16);
        while (ptr < this.buffer.length && totalFiles > 0) {
            if (this.buffer[ptr + 6] == 0) break;
            text.append("\n");
            this.addTextAndDecimal(text, this.buffer, ptr + 0, 2, "File's first block");
            this.addTextAndDecimal(text, this.buffer, ptr + 2, 2, "File's last block");
            int type = this.buffer[ptr + 4] & 0xF;
            if (type < fileTypes.length) {
                this.addText(text, this.buffer, ptr + 4, 1, "File type : " + fileTypes[type]);
            }
            int wildcard = this.buffer[ptr + 4] & 0xC0;
            this.addText(text, this.buffer, ptr + 5, 1, "Wildcard : " + wildcard);
            name = HexFormatter.getPascalString(this.buffer, ptr + 6);
            this.addText(text, this.buffer, ptr + 6, 4, "");
            this.addText(text, this.buffer, ptr + 10, 4, "");
            this.addText(text, this.buffer, ptr + 14, 4, "");
            this.addText(text, this.buffer, ptr + 18, 4, "File name : " + name);
            this.addTextAndDecimal(text, this.buffer, ptr + 22, 2, "Bytes in file's last block");
            calendar = Utility.getPascalDate(this.buffer, ptr + 24);
            date = calendar == null ? "--" : this.df.format(calendar.getTime());
            this.addText(text, this.buffer, ptr + 24, 2, "Date : " + date);
            ptr += 26;
            --totalFiles;
        }
        return text.toString();
    }
}

