/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.pascal;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.applefile.AssemblerProgram;
import com.bytezone.diskbrowser.applefile.Charset;
import com.bytezone.diskbrowser.applefile.DefaultAppleFile;
import com.bytezone.diskbrowser.applefile.PascalCode;
import com.bytezone.diskbrowser.applefile.PascalInfo;
import com.bytezone.diskbrowser.applefile.PascalSegment;
import com.bytezone.diskbrowser.applefile.PascalText;
import com.bytezone.diskbrowser.pascal.CatalogEntry;
import com.bytezone.diskbrowser.pascal.PascalCodeObject;
import com.bytezone.diskbrowser.pascal.PascalDisk;
import com.bytezone.diskbrowser.utilities.FileFormatException;
import com.bytezone.diskbrowser.utilities.Utility;
import javax.swing.tree.DefaultMutableTreeNode;

public class FileEntry
extends CatalogEntry {
    private DefaultMutableTreeNode node;

    public FileEntry(PascalDisk parent, byte[] buffer) {
        super(parent, buffer);
        this.bytesUsedInLastBlock = Utility.getShort(buffer, 22);
        this.date = Utility.getPascalDate(buffer, 24);
        int max = Math.min(this.lastBlock, parent.getDisk().getTotalBlocks());
        int i = this.firstBlock;
        while (i < max) {
            if (this.fileType < parent.sectors.length) {
                parent.sectorTypes[i] = parent.sectors[this.fileType];
            } else {
                System.out.println("Unknown pascal file type : " + this.fileType);
                parent.sectorTypes[i] = parent.dataSector;
            }
            ++i;
        }
    }

    void setNode(DefaultMutableTreeNode node) {
        this.node = node;
    }

    public void setFile(AbstractFile file) {
        this.file = file;
    }

    @Override
    public AbstractFile getDataSource() {
        if (this.file != null) {
            return this.file;
        }
        if (this.firstBlock == this.lastBlock) {
            this.file = new DefaultAppleFile(this.name, new byte[0]);
            this.node.setAllowsChildren(false);
            return this.file;
        }
        byte[] buffer = this.getExactBuffer();
        switch (this.fileType) {
            case 2: {
                try {
                    this.file = new PascalCode(this.name, buffer, this.firstBlock);
                    this.node.removeAllChildren();
                    for (PascalSegment pascalSegment : (PascalCode)this.file) {
                        DefaultMutableTreeNode segmentNode = new DefaultMutableTreeNode(new PascalCodeObject(this.parent, pascalSegment, this.firstBlock));
                        segmentNode.setAllowsChildren(false);
                        this.node.add(segmentNode);
                    }
                }
                catch (FileFormatException e) {
                    this.file = this.name.equals("SYSTEM.INTERP") ? new AssemblerProgram(this.name, buffer, 53248) : new AssemblerProgram(this.name, buffer, 0);
                    this.node.setAllowsChildren(false);
                }
                break;
            }
            case 3: {
                this.file = new PascalText(this.name, buffer);
                break;
            }
            case 4: {
                this.file = new PascalInfo(this.name, buffer);
                break;
            }
            case 5: {
                if (this.name.equals("SYSTEM.CHARSET")) {
                    this.file = new Charset(this.name, buffer);
                    break;
                }
                this.file = new DefaultAppleFile(this.name, buffer);
                break;
            }
            case 0: {
                break;
            }
            default: {
                this.file = new DefaultAppleFile(this.name, buffer);
            }
        }
        return this.file;
    }

    private byte[] getExactBuffer() {
        byte[] exactBuffer;
        byte[] buffer = this.parent.getDisk().readBlocks(this.blocks);
        if (buffer.length > 0 && this.bytesUsedInLastBlock < 512) {
            int exactLength = buffer.length - 512 + this.bytesUsedInLastBlock;
            exactBuffer = new byte[exactLength];
            System.arraycopy(buffer, 0, exactBuffer, 0, exactLength);
        } else {
            exactBuffer = buffer;
        }
        return exactBuffer;
    }
}

