/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.nufx;

import com.bytezone.diskbrowser.nufx.Binary2Header;
import com.bytezone.diskbrowser.utilities.DateTime;
import com.bytezone.diskbrowser.utilities.FileFormatException;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.utilities.Utility;

public class MasterHeader {
    private static final byte[] NuFile = new byte[]{78, -11, 70, -23, 108, -27};
    private static final byte[] BIN2 = new byte[]{10, 71, 76};
    private final int crc;
    private final int totalRecords;
    private final DateTime created;
    private final DateTime modified;
    private final int version;
    private final int reserved;
    private final int eof;
    boolean bin2;
    Binary2Header binary2Header;

    public MasterHeader(byte[] buffer) throws FileFormatException {
        int ptr = 0;
        while (!Utility.isMagic(buffer, ptr, NuFile)) {
            if (this.isBin2(buffer, ptr)) {
                this.binary2Header = new Binary2Header(buffer, 0);
                if (this.binary2Header.fileType == -32 && (this.binary2Header.auxType == 32768 || this.binary2Header.auxType == 32770)) {
                    ptr += 128;
                    this.bin2 = true;
                    continue;
                }
                System.out.printf("Not NuFX: %02X  %04X%n", this.binary2Header.fileType, this.binary2Header.auxType);
                System.out.println(this.binary2Header);
            }
            System.out.println(HexFormatter.format(buffer, 0, 256));
            throw new FileFormatException("NuFile not found");
        }
        this.crc = Utility.getShort(buffer, ptr + 6);
        this.totalRecords = Utility.getLong(buffer, ptr + 8);
        this.created = new DateTime(buffer, ptr + 12);
        this.modified = new DateTime(buffer, ptr + 20);
        this.version = Utility.getShort(buffer, ptr + 28);
        this.reserved = Utility.getShort(buffer, ptr + 30);
        this.eof = Utility.getLong(buffer, ptr + 38);
        byte[] crcBuffer = new byte[40];
        System.arraycopy(buffer, ptr + 8, crcBuffer, 0, crcBuffer.length);
        if (this.crc != Utility.getCRC(crcBuffer, crcBuffer.length, 0)) {
            System.out.println("***** Master CRC mismatch *****");
            throw new FileFormatException("Master CRC failed");
        }
    }

    int getTotalRecords() {
        return this.totalRecords;
    }

    String getCreated() {
        return this.created.format();
    }

    String getModified() {
        return this.modified.format();
    }

    String getCreated2() {
        return this.created.format2();
    }

    String getModified2() {
        return this.modified.format2();
    }

    long getEof() {
        return this.eof;
    }

    private boolean isBin2(byte[] buffer, int ptr) {
        return Utility.isMagic(buffer, ptr, BIN2) && buffer[ptr + 18] == 2;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append(String.format("Master CRC ..... %,d  (%04X)%n", this.crc, this.crc));
        text.append(String.format("Records ........ %,d%n", this.totalRecords));
        text.append(String.format("Created ........ %s%n", this.created.format()));
        text.append(String.format("Modified ....... %s%n", this.modified.format()));
        text.append(String.format("Version ........ %,d%n", this.version));
        text.append(String.format("Reserved ....... %016X%n", this.reserved));
        text.append(String.format("Master EOF ..... %,d", this.eof));
        return text.toString();
    }
}

