/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.nufx;

public class LZW3 {
    static final int[] bitMasks;
    static final int CLEAR_CODE = 256;
    static final int EOF_CODE = 257;
    static final int FIRST_FREE_CODE = 258;
    int nBitMod1;
    int nBitMask;
    int finChar;
    int oldCode;
    int inCode;
    int freeCode;
    int maxCode;
    int k;
    int bitOffset;
    int[] hashNext = new int[4096];
    int[] hashChar = new int[4096];
    int ptr = 0;
    int iCode;
    int[] stack = new int[32768];
    int stackIdx = 0;
    byte[] srcBuf;
    byte[] dstBuf;

    static {
        int[] nArray = new int[13];
        nArray[9] = 511;
        nArray[10] = 1023;
        nArray[11] = 2047;
        nArray[12] = 4095;
        bitMasks = nArray;
    }

    public int unpack(byte[] src, byte[] dst, int max) {
        assert (max <= dst.length);
        this.srcBuf = src;
        this.dstBuf = dst;
        this.initTable();
        this.bitOffset = 0;
        while (true) {
            int y;
            if (this.ptr > max) {
                System.out.println("LZW3 overrun");
                return -1;
            }
            this.iCode = this.readCode();
            if (this.iCode == 257) break;
            if (this.iCode == 256) {
                this.initTable();
                this.oldCode = this.iCode = this.readCode();
                this.k = this.iCode;
                this.finChar = this.iCode;
                this.dstBuf[this.ptr++] = (byte)this.iCode;
                continue;
            }
            int a = this.inCode = this.iCode;
            if (this.iCode >= this.freeCode) {
                this.stack[this.stackIdx++] = this.finChar;
                a = this.oldCode;
            }
            while (a >= 256) {
                y = a;
                a = this.hashChar[y];
                this.stack[this.stackIdx++] = a;
                a = this.hashNext[y];
            }
            this.finChar = a;
            this.k = a;
            y = 0;
            this.dstBuf[this.ptr + y++] = (byte)a;
            while (this.stackIdx > 0) {
                a = this.stack[--this.stackIdx];
                this.dstBuf[this.ptr + y++] = (byte)a;
            }
            this.ptr += y;
            this.addCode();
            this.oldCode = this.inCode;
            if (this.freeCode < this.maxCode || this.nBitMod1 == 12) continue;
            ++this.nBitMod1;
            this.nBitMask = bitMasks[this.nBitMod1];
            this.maxCode <<= 1;
        }
        return this.ptr;
    }

    private void initTable() {
        this.nBitMod1 = 9;
        this.nBitMask = bitMasks[this.nBitMod1];
        this.maxCode = 1 << this.nBitMod1;
        this.freeCode = 258;
    }

    private int readCode() {
        int bitIdx = this.bitOffset & 7;
        int byteIdx = this.bitOffset >>> 3;
        int iCode = this.srcBuf[byteIdx] & 0xFF | (this.srcBuf[byteIdx + 1] & 0xFF) << 8 | (this.srcBuf[byteIdx + 2] & 0xFF) << 16;
        iCode >>>= bitIdx;
        this.bitOffset += this.nBitMod1;
        return iCode &= this.nBitMask;
    }

    private void addCode() {
        this.hashChar[this.freeCode] = this.k;
        this.hashNext[this.freeCode] = this.oldCode;
        ++this.freeCode;
    }
}

