/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.nufx;

import com.bytezone.diskbrowser.nufx.LZW;
import com.bytezone.diskbrowser.utilities.Utility;

class LZW1
extends LZW {
    public LZW1(byte[] buffer) {
        super(buffer);
    }

    @Override
    void unpack() {
        this.crc = Utility.getShort(this.buffer, 0);
        this.crcBase = 0;
        this.volume = this.buffer[2] & 0xFF;
        this.runLengthChar = (byte)(this.buffer[3] & 0xFF);
        int ptr = 4;
        while (ptr < this.buffer.length - 2) {
            int rleLength = Utility.getShort(this.buffer, ptr);
            boolean lzwPerformed = (this.buffer[ptr + 2] & 0xFF) != 0;
            ptr += 3;
            if (lzwPerformed) {
                this.setBuffer(ptr);
                byte[] lzwBuffer = this.undoLZW(rleLength);
                if (rleLength == 4096) {
                    this.chunks.add(lzwBuffer);
                } else {
                    this.chunks.add(this.undoRLE(lzwBuffer, 0, lzwBuffer.length));
                }
                ptr += this.bytesRead();
                continue;
            }
            if (rleLength == 4096) {
                byte[] originalBuffer = new byte[4096];
                System.arraycopy(this.buffer, ptr, originalBuffer, 0, originalBuffer.length);
                this.chunks.add(originalBuffer);
            } else {
                this.chunks.add(this.undoRLE(this.buffer, ptr, rleLength));
            }
            ptr += rleLength;
        }
    }

    byte[] undoLZW(int rleLength) {
        byte[] lzwBuffer = new byte[rleLength];
        int ptr = 0;
        int nextEntry = 256;
        String prev = "";
        while (ptr < rleLength) {
            String s;
            int codeWord = this.readInt(this.width(nextEntry + 1));
            String string = s = nextEntry == codeWord ? String.valueOf(prev) + prev.charAt(0) : st[codeWord];
            if (nextEntry < st.length) {
                LZW1.st[nextEntry++] = String.valueOf(prev) + s.charAt(0);
            }
            int i = 0;
            while (i < s.length()) {
                lzwBuffer[ptr++] = (byte)s.charAt(i);
                ++i;
            }
            prev = s;
        }
        return lzwBuffer;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append(String.format("  crc ............... %,d  (%04X)%n", this.crc, this.crc));
        text.append(String.format("  volume ............ %,d%n", this.volume));
        text.append(String.format("  RLE char .......... $%02X", this.runLengthChar));
        return text.toString();
    }
}

