/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.nufx;

import com.bytezone.diskbrowser.utilities.Utility;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

abstract class LZW {
    static final String[] st = new String[4096];
    static final int TRACK_LENGTH = 4096;
    final List<byte[]> chunks = new ArrayList<byte[]>();
    int volume;
    byte runLengthChar;
    int crc;
    int crcBase;
    int v3eof;
    private int byteBuffer;
    private int bitsLeft;
    private int ptr;
    private int startPtr;
    byte[] buffer;
    boolean unpacked;

    static {
        int i = 0;
        while (i < 256) {
            LZW.st[i] = "" + (char)i;
            ++i;
        }
    }

    LZW(byte[] buffer) {
        this.buffer = Objects.requireNonNull(buffer);
    }

    abstract void unpack();

    void setBuffer(int ptr) {
        this.startPtr = this.ptr = ptr;
        this.bitsLeft = 0;
    }

    int bytesRead() {
        return this.ptr - this.startPtr;
    }

    int readInt(int width) {
        if (width < 8 || width > 12) {
            throw new RuntimeException("Illegal value of r = " + width);
        }
        int x = 0;
        int i = 0;
        int weight = 1;
        while (i < width) {
            if (this.readBoolean()) {
                x |= weight;
            }
            ++i;
            weight <<= 1;
        }
        return x;
    }

    private boolean readBoolean() {
        if (this.bitsLeft == 0) {
            this.byteBuffer = this.buffer[this.ptr++] & 0xFF;
            this.bitsLeft = 8;
        }
        --this.bitsLeft;
        boolean bit = (this.byteBuffer << this.bitsLeft & 0x80) != 0;
        return bit;
    }

    byte[] undoRLE(byte[] inBuffer, int inPtr, int length) {
        byte[] outBuffer = new byte[4096];
        int outPtr = 0;
        int max = inPtr + length;
        while (inPtr < max) {
            byte b;
            if ((b = inBuffer[inPtr++]) == this.runLengthChar) {
                b = inBuffer[inPtr++];
                int rpt = inBuffer[inPtr++] & 0xFF;
                while (rpt-- >= 0) {
                    outBuffer[outPtr++] = b;
                }
                continue;
            }
            outBuffer[outPtr++] = b;
        }
        assert (outPtr == 4096);
        return outBuffer;
    }

    int getSize() {
        if (!this.unpacked) {
            this.unpack();
            this.unpacked = true;
        }
        return this.chunks.size() * 4096;
    }

    byte[] getData() {
        if (!this.unpacked) {
            this.unpack();
            this.unpacked = true;
        }
        byte[] buffer = new byte[this.getSize()];
        int trackNumber = 0;
        for (byte[] track : this.chunks) {
            System.arraycopy(track, 0, buffer, trackNumber++ * 4096, 4096);
        }
        int length = this.v3eof != 0 ? this.v3eof : buffer.length;
        int calculatedCrc = Utility.getCRC(buffer, length, this.crcBase);
        if (this.crc != calculatedCrc) {
            System.out.printf("%n*** Thread CRC failed ***  %04X  %04X%n", this.crc, calculatedCrc);
        }
        return buffer;
    }

    int width(int maximumValue) {
        return 32 - Integer.numberOfLeadingZeros(maximumValue);
    }
}

