/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.nib;

import com.bytezone.diskbrowser.nib.ByteTranslator6and2;
import com.bytezone.diskbrowser.nib.DiskNibbleException;
import com.bytezone.diskbrowser.nib.DiskReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WozFile {
    private static final byte[] address16prologue = new byte[]{-43, -86, -106};
    private static final byte[] address13prologue = new byte[]{-43, -86, -75};
    private static final byte[] dataPrologue = new byte[]{-43, -86, -83};
    private static final byte[] epilogue = new byte[]{-34, -86, -21};
    private static final int BLOCK_SIZE = 512;
    private static final int SECTOR_SIZE = 256;
    private static final int TRK_SIZE = 6656;
    private static final int DATA_SIZE = 6646;
    private static int[][] interleave;
    public final File file;
    private Info info;
    private Meta meta;
    private int diskSectors;
    private byte[] addressPrologue;
    private byte[] diskBuffer;
    private List<Track> tracks;
    private final boolean debug1 = false;
    private final boolean showTracks = false;
    private final ByteTranslator6and2 byteTranslator6and2;

    static {
        int[][] nArrayArray = new int[2][];
        int[] nArray = new int[16];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[10] = 10;
        nArray[11] = 11;
        nArray[12] = 12;
        nArray[13] = 13;
        nArray[14] = 14;
        nArray[15] = 15;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[16];
        nArray2[1] = 7;
        nArray2[2] = 14;
        nArray2[3] = 6;
        nArray2[4] = 13;
        nArray2[5] = 5;
        nArray2[6] = 12;
        nArray2[7] = 4;
        nArray2[8] = 11;
        nArray2[9] = 3;
        nArray2[10] = 10;
        nArray2[11] = 2;
        nArray2[12] = 9;
        nArray2[13] = 1;
        nArray2[14] = 8;
        nArray2[15] = 15;
        nArrayArray[1] = nArray2;
        interleave = nArrayArray;
    }

    /*
     * Exception decompiling
     */
    public WozFile(File file) throws DiskNibbleException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[7] lbl93 : CaseStatement: default:\u000a, @NONE, blocks:[7] lbl93 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean validateChunk(byte[] buffer, int ptr) throws DiskNibbleException {
        int size = this.val32(buffer, ptr + 4);
        if (size <= 0 || size + ptr + 8 > buffer.length) {
            if (this.info != null) {
                System.out.println(this.info);
            }
            throw new DiskNibbleException(String.format("Invalid chunk size: %08X%n", size));
        }
        int i = 0;
        while (i < 4) {
            int val = buffer[ptr + i] & 0xFF;
            if (val < 65 || val > 90) {
                if (this.info != null) {
                    System.out.println(this.info);
                }
                throw new DiskNibbleException(String.format("Invalid chunk name character: %02X%n", val));
            }
            ++i;
        }
        return true;
    }

    public byte[] getDiskBuffer() {
        return this.diskBuffer;
    }

    public int getDiskType() {
        return this.info.diskType;
    }

    public int getSides() {
        return this.info.sides;
    }

    public int getTracks() {
        return this.tracks.size();
    }

    public int getSectorsPerTrack() {
        return this.diskSectors;
    }

    private void setPrologue(int diskSectors) {
        this.diskSectors = diskSectors;
        this.addressPrologue = diskSectors == 13 ? address13prologue : address16prologue;
    }

    private void tmap(byte[] buffer, int ptr) {
        ptr += 8;
    }

    private List<Track> trks(byte[] rawBuffer, int ptr) {
        ArrayList<Track> tracks = new ArrayList<Track>();
        ptr += 8;
        int reclen = this.info.wozVersion == 1 ? 6656 : 8;
        int max = this.info.wozVersion == 1 ? 35 : 160;
        int i = 0;
        while (i < max) {
            try {
                Track trk = new Track(i, rawBuffer, ptr);
                if (trk.bitCount == 0) break;
                tracks.add(trk);
            }
            catch (DiskNibbleException e) {
                e.printStackTrace();
            }
            ptr += reclen;
            ++i;
        }
        return tracks;
    }

    private int val8(byte[] buffer, int ptr) {
        return buffer[ptr] & 0xFF;
    }

    private int val16(byte[] buffer, int ptr) {
        return buffer[ptr] & 0xFF | (buffer[ptr + 1] & 0xFF) << 8;
    }

    private int val32(byte[] buffer, int ptr) {
        return buffer[ptr] & 0xFF | (buffer[ptr + 1] & 0xFF) << 8 | (buffer[ptr + 2] & 0xFF) << 16 | (buffer[ptr + 3] & 0xFF) << 24;
    }

    private int decode4and4(byte[] buffer, int offset) {
        int odds = (buffer[offset] & 0xFF) << 1 | 1;
        int evens = buffer[offset + 1] & 0xFF;
        return odds & evens;
    }

    private byte[] readFile(File file) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                return in.readAllBytes();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        if (this.meta != null) {
            return String.valueOf(this.info.toString()) + "\n\n" + this.meta.toString();
        }
        return this.info.toString();
    }

    public static void main(String[] args) {
        String home = "/Users/denismolony/";
        String wozBase1 = String.valueOf(home) + "Dropbox/Examples/woz test images/WOZ 1.0/";
        String wozBase2 = String.valueOf(home) + "Dropbox/Examples/woz test images/WOZ 2.0/";
        String wozBase3 = String.valueOf(home) + "Dropbox/Examples/woz test images/WOZ 2.0/3.5/";
        File[] files = new File[]{new File(String.valueOf(home) + "code/python/wozardry-2.0/bill.woz"), new File(String.valueOf(wozBase2) + "DOS 3.3 System Master.woz"), new File(String.valueOf(wozBase1) + "DOS 3.3 System Master.woz"), new File(String.valueOf(wozBase3) + "Apple IIgs System Disk 1.1.woz")};
        try {
            new WozFile(files[3]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class Info {
        int wozVersion;
        int diskType;
        int writeProtected;
        int synchronised;
        int cleaned;
        String creator;
        int sides;
        int bootSectorFormat;
        int optimalBitTiming;
        int compatibleHardware;
        int requiredRam;
        int largestTrack;

        Info(byte[] buffer, int ptr) {
            this.wozVersion = WozFile.this.val8(buffer, ptr + 8);
            this.diskType = WozFile.this.val8(buffer, ptr + 9);
            this.writeProtected = WozFile.this.val8(buffer, ptr + 10);
            this.synchronised = WozFile.this.val8(buffer, ptr + 11);
            this.cleaned = WozFile.this.val8(buffer, ptr + 12);
            this.creator = new String(buffer, ptr + 13, 32);
            if (this.wozVersion >= 2) {
                this.sides = WozFile.this.val8(buffer, ptr + 45);
                this.bootSectorFormat = WozFile.this.val8(buffer, ptr + 46);
                this.optimalBitTiming = WozFile.this.val8(buffer, ptr + 47);
                this.compatibleHardware = WozFile.this.val16(buffer, ptr + 48);
                this.requiredRam = WozFile.this.val16(buffer, ptr + 50);
                this.largestTrack = WozFile.this.val16(buffer, ptr + 52);
            }
        }

        public String toString() {
            StringBuilder text = new StringBuilder("WOZ info:\n\n");
            String diskTypeText = this.diskType == 1 ? "5.25" : "3.5";
            text.append(String.format("Version ............. %d%n", this.wozVersion));
            text.append(String.format("Disk type ........... %d  (%s\")%n", this.diskType, diskTypeText));
            text.append(String.format("Write protected ..... %d%n", this.writeProtected));
            text.append(String.format("Synchronized ........ %d%n", this.synchronised));
            text.append(String.format("Cleaned ............. %d%n", this.cleaned));
            text.append(String.format("Creator ............. %s", this.creator));
            if (this.wozVersion > 1) {
                String bootSectorFormatText = this.bootSectorFormat == 0 ? "Unknown" : (this.bootSectorFormat == 1 ? "16 sector" : (this.bootSectorFormat == 2 ? "13 sector" : "Hybrid"));
                text.append(String.format("%nSides ............... %d%n", this.sides));
                text.append(String.format("Boot sector format .. %d  (%s)%n", this.bootSectorFormat, bootSectorFormatText));
                text.append(String.format("Optimal bit timing .. %d%n", this.optimalBitTiming));
                text.append(String.format("Compatible hardware . %d%n", this.compatibleHardware));
                text.append(String.format("Required RAM ........ %d%n", this.requiredRam));
                text.append(String.format("Largest track ....... %d", this.largestTrack));
            }
            return text.toString();
        }
    }

    class Meta {
        List<String> lines = new ArrayList<String>();

        Meta(byte[] buffer, int ptr, int length) {
            String[] chunks;
            String dots = " ......................";
            String metaData = new String(buffer, ptr + 8, length);
            String[] stringArray = chunks = metaData.split("\n");
            int n = chunks.length;
            int n2 = 0;
            while (n2 < n) {
                String chunk = stringArray[n2];
                String[] parts = chunk.split("\t");
                if (parts.length >= 2) {
                    this.lines.add(String.format("%-21.21s %s", String.valueOf(parts[0]) + dots, parts[1]));
                } else {
                    this.lines.add(String.format("%-21.21s", String.valueOf(parts[0]) + dots));
                }
                ++n2;
            }
        }

        public String toString() {
            StringBuilder text = new StringBuilder("WOZ meta:\n\n");
            for (String line : this.lines) {
                text.append(String.format("%s%n", line));
            }
            if (text.length() > 0) {
                text.deleteCharAt(text.length() - 1);
            }
            return text.toString();
        }
    }

    public class Sector
    implements Comparable<Sector> {
        private final Track track;
        private int trackNo;
        private int sectorNo;
        private int volume;
        private int checksum;
        private final int addressOffset;
        private int dataOffset;

        Sector(Track track, int addressOffset) {
            this.track = track;
            if (WozFile.this.info.diskType == 1) {
                this.volume = WozFile.this.decode4and4(track.newBuffer, addressOffset + 3);
                this.trackNo = WozFile.this.decode4and4(track.newBuffer, addressOffset + 5);
                this.sectorNo = WozFile.this.decode4and4(track.newBuffer, addressOffset + 7);
                this.checksum = WozFile.this.decode4and4(track.newBuffer, addressOffset + 9);
            } else {
                try {
                    byte b1 = WozFile.this.byteTranslator6and2.decode(track.newBuffer[addressOffset + 3]);
                    this.sectorNo = WozFile.this.byteTranslator6and2.decode(track.newBuffer[addressOffset + 4]);
                    byte b3 = WozFile.this.byteTranslator6and2.decode(track.newBuffer[addressOffset + 5]);
                    byte format = WozFile.this.byteTranslator6and2.decode(track.newBuffer[addressOffset + 6]);
                    this.checksum = WozFile.this.byteTranslator6and2.decode(track.newBuffer[addressOffset + 7]);
                    this.trackNo = b1 & 0x3F | (b3 & 0x1F) << 6;
                    this.volume = (b3 & 0x20) >>> 5;
                    int chk = b1 ^ this.sectorNo ^ b3 ^ format;
                    assert (chk == this.checksum);
                }
                catch (DiskNibbleException e) {
                    e.printStackTrace();
                }
            }
            this.addressOffset = addressOffset;
            this.dataOffset = track.findNext(dataPrologue, addressOffset + 11);
            if (this.dataOffset > addressOffset + 200) {
                this.dataOffset = -1;
            }
        }

        void pack35(byte[] diskBuffer, int ptr) throws DiskNibbleException {
            DiskReader diskReader = DiskReader.getInstance(0);
            byte[] decodedBuffer = diskReader.decodeSector(this.track.newBuffer, this.dataOffset + 4);
            System.arraycopy(decodedBuffer, 12, diskBuffer, ptr, 512);
        }

        public String toString() {
            String fld = WozFile.this.info.diskType == 1 ? "Vol" : (WozFile.this.info.diskType == 2 ? "Sde" : "???");
            String dataOffsetText = this.dataOffset < 0 ? "" : String.format("%04X", this.dataOffset);
            return String.format("%s: %02X  Trk: %02X  Sct: %02X  Chk: %02X  Add: %04X  Dat: %s", fld, this.volume, this.trackNo, this.sectorNo, this.checksum, this.addressOffset, dataOffsetText);
        }

        @Override
        public int compareTo(Sector o) {
            if (this.trackNo != o.trackNo) {
                return this.trackNo - o.trackNo;
            }
            if (this.volume != o.volume) {
                return this.volume - o.volume;
            }
            return this.sectorNo - o.sectorNo;
        }
    }

    class Track
    implements Iterable<Sector> {
        private int trackNo;
        private int startingBlock;
        private int blockCount;
        private int bitCount;
        private int bytesUsed;
        private byte[] rawBuffer;
        private byte[] newBuffer;
        private int bitIndex;
        private int byteIndex;
        private int trackIndex;
        private int revolutions;
        List<Sector> sectors = new ArrayList<Sector>();

        public Track(int trackNo, byte[] rawBuffer, int ptr) throws DiskNibbleException {
            this.rawBuffer = rawBuffer;
            this.trackNo = trackNo;
            if (WozFile.this.info.wozVersion == 1) {
                this.bytesUsed = WozFile.this.val16(rawBuffer, ptr + 6646);
                this.bitCount = WozFile.this.val16(rawBuffer, ptr + 6646 + 2);
            } else {
                this.startingBlock = WozFile.this.val16(rawBuffer, ptr);
                this.blockCount = WozFile.this.val16(rawBuffer, ptr + 2);
                this.bitCount = WozFile.this.val32(rawBuffer, ptr + 4);
            }
            if (this.bitCount == 0) {
                return;
            }
            this.resetIndex();
            if (WozFile.this.addressPrologue == null) {
                if (this.findNext(address16prologue, ptr) > 0) {
                    WozFile.this.setPrologue(16);
                } else if (this.findNext(address13prologue, ptr) > 0) {
                    WozFile.this.setPrologue(13);
                } else {
                    throw new DiskNibbleException("No address prologue found");
                }
            }
            int offset = -1;
            while (this.sectors.size() < WozFile.this.diskSectors) {
                Sector sector;
                if ((offset = this.findNext(WozFile.this.addressPrologue, offset + 1)) < 0 || this.isDuplicate(sector = new Sector(this, offset))) break;
                this.sectors.add(sector);
            }
        }

        private boolean isDuplicate(Sector newSector) {
            for (Sector sector : this.sectors) {
                if (sector.sectorNo != newSector.sectorNo) continue;
                return true;
            }
            return false;
        }

        private void resetIndex() {
            this.trackIndex = 0;
            this.bitIndex = 0;
            this.byteIndex = WozFile.this.info.wozVersion == 1 ? 256 + this.trackNo * 6656 : this.startingBlock * 512;
        }

        boolean nextBit() {
            boolean bit;
            boolean bl = bit = (this.rawBuffer[this.byteIndex] & 128 >>> this.bitIndex) != 0;
            if (++this.trackIndex >= this.bitCount) {
                ++this.revolutions;
                this.resetIndex();
            } else if (++this.bitIndex >= 8) {
                ++this.byteIndex;
                this.bitIndex = 0;
            }
            return bit;
        }

        int nextByte() {
            int b = 0;
            while ((b & 0x80) == 0) {
                b = (byte)(b << 1);
                if (!this.nextBit()) continue;
                b = (byte)(b | 1);
            }
            return b;
        }

        void readTrack() {
            if (this.newBuffer != null) {
                return;
            }
            int max = (this.bitCount - 1) / 8 + 1;
            this.newBuffer = new byte[max += 600];
            int i = 0;
            while (i < max) {
                this.newBuffer[i] = (byte)this.nextByte();
                ++i;
            }
        }

        int findNext(byte[] key, int start) {
            this.readTrack();
            int max = this.newBuffer.length - key.length;
            int ptr = start;
            while (ptr < max) {
                block3: {
                    int keyPtr = 0;
                    while (keyPtr < key.length) {
                        if (this.newBuffer[ptr + keyPtr] == key[keyPtr]) {
                            ++keyPtr;
                            continue;
                        }
                        break block3;
                    }
                    return ptr;
                }
                ++ptr;
            }
            return -1;
        }

        void pack(byte[] diskBuffer) throws DiskNibbleException {
            int ndx = WozFile.this.diskSectors == 13 ? 0 : 1;
            DiskReader diskReader = DiskReader.getInstance(WozFile.this.diskSectors);
            for (Sector sector : this.sectors) {
                if (sector.dataOffset <= 0) continue;
                byte[] decodedBuffer = diskReader.decodeSector(this.newBuffer, sector.dataOffset + 3);
                int ptr = 256 * (sector.trackNo * WozFile.this.diskSectors + interleave[ndx][sector.sectorNo]);
                System.arraycopy(decodedBuffer, 0, diskBuffer, ptr, decodedBuffer.length);
            }
        }

        public String toString() {
            StringBuilder text = new StringBuilder();
            if (WozFile.this.info.wozVersion == 1) {
                text.append(String.format("WOZ1: Bytes: %2d,  Bits: %,8d%n%n", this.bytesUsed, this.bitCount));
            } else {
                text.append(String.format("WOZ2: Start: %4d,  Blocks: %2d,  Bits: %,8d%n%n", this.startingBlock, this.blockCount, this.bitCount));
            }
            int count = 0;
            for (Sector sector : this.sectors) {
                text.append(String.format("%2d  %s%n", count++, sector));
            }
            text.deleteCharAt(text.length() - 1);
            return text.toString();
        }

        @Override
        public Iterator<Sector> iterator() {
            return this.sectors.iterator();
        }
    }
}

