/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.nib;

import com.bytezone.diskbrowser.nib.Nibblizer;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.utilities.Utility;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class V2dFile {
    private static final int TRACK_LENGTH = 6304;
    private final Nibblizer nibbler;
    public final File file;
    final int tracks;
    final byte[] diskBuffer = new byte[143360];

    public V2dFile(File file) {
        this.file = file;
        int tracks = 0;
        this.nibbler = new Nibblizer();
        try {
            byte[] header = new byte[10];
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            in.read(header);
            int diskLength = Utility.getLongBigEndian(header, 0);
            String id = HexFormatter.getString(header, 4, 4);
            tracks = Utility.getShortBigEndian(header, 8);
            assert ((long)(diskLength + 8) == file.length());
            assert ("D5NI".equals(id));
            byte[] trackHeader = new byte[4];
            byte[] trackData = new byte[6304];
            int i = 0;
            while (i < tracks) {
                in.read(trackHeader);
                int trackNumber = Utility.getShortBigEndian(trackHeader, 0);
                int trackLength = Utility.getShortBigEndian(trackHeader, 2);
                assert (trackLength == 6304);
                int dataRead = in.read(trackData);
                assert (dataRead == 6304);
                int fullTrackNo = trackNumber / 4;
                int halfTrackNo = trackNumber % 4;
                if (halfTrackNo == 0) {
                    this.nibbler.processTrack(fullTrackNo, 16, trackData, this.diskBuffer);
                } else {
                    System.out.printf("%s skipping half track %02X / %02X%n", file.getName(), fullTrackNo, halfTrackNo);
                }
                ++i;
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.tracks = tracks;
    }

    public byte[] getDiskBuffer() {
        return this.diskBuffer;
    }
}

