/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.nib;

import com.bytezone.diskbrowser.nib.ByteTranslator;
import com.bytezone.diskbrowser.nib.ByteTranslator5and3;
import com.bytezone.diskbrowser.nib.ByteTranslator6and2;

class Nibblizer {
    private static byte[] addressPrologue32 = new byte[]{-43, -86, -75};
    private static byte[] addressPrologue33 = new byte[]{-43, -86, -106};
    private static byte[] dataPrologue = new byte[]{-43, -86, -83};
    private static byte[] epilogue = new byte[]{-34, -86, -21};
    private static int[] interleave;
    private static final int BLOCK_SIZE = 256;
    private static final int RAW_BUFFER_SIZE_DOS_33 = 342;
    private static final int RAW_BUFFER_SIZE_DOS_32 = 410;
    private static final int BUFFER_WITH_CHECKSUM_SIZE_DOS_33 = 343;
    private static final int BUFFER_WITH_CHECKSUM_SIZE_DOS_32 = 411;
    private final ByteTranslator byteTranslator62 = new ByteTranslator6and2();
    private final ByteTranslator byteTranslator53 = new ByteTranslator5and3();
    private final byte[] decodeDos33a = new byte[343];
    private final byte[] decodeDos33b = new byte[342];
    private final byte[] encodeDos33a = new byte[342];
    private final byte[] encodeDos33b = new byte[343];
    private final byte[] decodeDos32a = new byte[411];
    private final byte[] decodeDos32b = new byte[410];
    private int sectorsPerTrack;

    static {
        int[] nArray = new int[16];
        nArray[1] = 8;
        nArray[2] = 1;
        nArray[3] = 9;
        nArray[4] = 2;
        nArray[5] = 10;
        nArray[6] = 3;
        nArray[7] = 11;
        nArray[8] = 4;
        nArray[9] = 12;
        nArray[10] = 5;
        nArray[11] = 13;
        nArray[12] = 6;
        nArray[13] = 14;
        nArray[14] = 7;
        nArray[15] = 15;
        interleave = nArray;
    }

    Nibblizer() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean processTrack(int trackNo, int maxTracks, byte[] buffer, byte[] diskBuffer) {
        int ptr = 0;
        int totalSectors = 0;
        boolean[] sectorsFound = new boolean[16];
        this.sectorsPerTrack = maxTracks;
        try {
            while (ptr < buffer.length) {
                ptr = this.sectorsPerTrack == 13 ? Nibblizer.findBytes(buffer, ptr, addressPrologue32) : Nibblizer.findBytes(buffer, ptr, addressPrologue33);
                if (ptr < 0) {
                    System.out.printf("Track: %02X - Address prologue not found%n", trackNo);
                    return false;
                }
                AddressField addressField = new AddressField(buffer, ptr);
                if (!addressField.isValid()) {
                    System.out.printf("Track: %02X - Invalid address field%n", trackNo);
                    return false;
                }
                if (addressField.track != trackNo) {
                    System.out.printf("Track: %02X - Wrong track found (%02X)%n", trackNo, addressField.track);
                    return false;
                }
                if (sectorsFound[addressField.sector]) {
                    System.out.printf("Track: %02X - Sector already processes (%02X)%n", trackNo, addressField.sector);
                    return false;
                }
                sectorsFound[addressField.sector] = true;
                assert (addressField.track == trackNo);
                ptr += addressField.size();
                if ((ptr = Nibblizer.findBytes(buffer, ptr, dataPrologue)) < 0) {
                    System.out.printf("Track: %02X - Data prologue not found%n", trackNo);
                    return false;
                }
                DataField dataField = new DataField(buffer, ptr);
                if (!dataField.isValid()) {
                    System.out.printf("Track: %02X - Invalid data field%n", trackNo);
                    return false;
                }
                int offset = this.sectorsPerTrack == 13 ? addressField.track * 3328 + addressField.sector * 256 : addressField.track * 4096 + interleave[addressField.sector] * 256;
                System.arraycopy(dataField.dataBuffer, 0, diskBuffer, offset, 256);
                if (++totalSectors != this.sectorsPerTrack) {
                    ptr += dataField.size();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (totalSectors != this.sectorsPerTrack) {
            System.out.printf("Track: %02X - Sectors found: %02X%n", trackNo, totalSectors);
            return false;
        }
        return true;
    }

    private int decode4and4(byte[] buffer, int offset) {
        int odds = ((buffer[offset] & 0xFF) << 1) + 1;
        int evens = buffer[offset + 1] & 0xFF;
        return odds & evens;
    }

    private byte[] decode5and3(byte[] buffer, int offset) {
        byte[] decodedBuffer = new byte[256];
        try {
            int i = 0;
            while (i < 411) {
                this.decodeDos32a[i] = (byte)(this.byteTranslator53.decode(buffer[offset++]) << 3);
                ++i;
            }
            byte chk = 0;
            int ptr = 0;
            int i2 = 409;
            while (i2 >= 256) {
                chk = this.decodeDos32b[i2] = (byte)(this.decodeDos32a[ptr++] ^ chk);
                --i2;
            }
            i2 = 0;
            while (i2 < 256) {
                chk = this.decodeDos32b[i2] = (byte)(this.decodeDos32a[ptr++] ^ chk);
                ++i2;
            }
            assert ((chk ^ this.decodeDos32a[ptr]) == 0);
            byte[] k = new byte[8];
            ptr = 0;
            int[] nArray = new int[8];
            nArray[1] = 51;
            nArray[2] = 102;
            nArray[3] = 153;
            nArray[4] = 204;
            nArray[5] = 256;
            nArray[6] = 307;
            nArray[7] = 358;
            int[] lines = nArray;
            int i3 = 50;
            while (i3 >= 0) {
                int j = 0;
                while (j < 8) {
                    k[j] = this.decodeDos32b[i3 + lines[j]];
                    ++j;
                }
                k[0] = (byte)(k[0] | (k[5] & 0xE0) >>> 5);
                k[1] = (byte)(k[1] | (k[6] & 0xE0) >>> 5);
                k[2] = (byte)(k[2] | (k[7] & 0xE0) >>> 5);
                k[3] = (byte)(k[3] | (k[5] & 0x10) >>> 2);
                k[3] = (byte)(k[3] | (k[6] & 0x10) >>> 3);
                k[3] = (byte)(k[3] | (k[7] & 0x10) >>> 4);
                k[4] = (byte)(k[4] | (k[5] & 8) >>> 1);
                k[4] = (byte)(k[4] | (k[6] & 8) >>> 2);
                k[4] = (byte)(k[4] | (k[7] & 8) >>> 3);
                j = 0;
                while (j < 5) {
                    decodedBuffer[ptr++] = k[j];
                    ++j;
                }
                --i3;
            }
            decodedBuffer[255] = (byte)(this.decodeDos32b[255] | this.decodeDos32b[409] >>> 3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return decodedBuffer;
    }

    private byte[] decode6and2(byte[] buffer, int offset) {
        byte[] decodedBuffer = new byte[256];
        try {
            int i = 0;
            while (i < 343) {
                this.decodeDos33a[i] = (byte)(this.byteTranslator62.decode(buffer[offset++]) << 2);
                ++i;
            }
            byte chk = 0;
            int i2 = this.decodeDos33b.length - 1;
            while (i2 >= 0) {
                chk = this.decodeDos33b[i2] = (byte)(this.decodeDos33a[i2 + 1] ^ chk);
                --i2;
            }
            assert ((chk ^ this.decodeDos33a[0]) == 0);
            i2 = 0;
            while (i2 < 256) {
                decodedBuffer[i2] = this.decodeDos33b[i2 + 86];
                ++i2;
            }
            i2 = 0;
            int j = 86;
            int k = 172;
            while (i2 < 86) {
                byte val = this.decodeDos33b[i2];
                int n = i2;
                decodedBuffer[n] = (byte)(decodedBuffer[n] | Nibblizer.reverse((val & 0xC) >> 2));
                int n2 = j;
                decodedBuffer[n2] = (byte)(decodedBuffer[n2] | Nibblizer.reverse((val & 0x30) >> 4));
                if (k < 256) {
                    int n3 = k;
                    decodedBuffer[n3] = (byte)(decodedBuffer[n3] | Nibblizer.reverse((val & 0xC0) >> 6));
                }
                ++i2;
                ++j;
                ++k;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return decodedBuffer;
    }

    private byte[] encode6and2(byte[] buffer) {
        byte[] encodedBuffer = new byte[343];
        int i = 0;
        while (i < 256) {
            this.encodeDos33a[i + 86] = buffer[i];
            ++i;
        }
        i = 0;
        while (i < 86) {
            int b1 = Nibblizer.reverse(buffer[i] & 3) << 2;
            int b2 = Nibblizer.reverse(buffer[i + 86] & 3) << 4;
            if (i < 84) {
                int b3 = Nibblizer.reverse(buffer[i + 172] & 3) << 6;
                this.encodeDos33a[i] = (byte)(b1 | b2 | b3);
            } else {
                this.encodeDos33a[i] = (byte)(b1 | b2);
            }
            ++i;
        }
        byte checksum = 0;
        int i2 = 0;
        while (i2 < 342) {
            this.encodeDos33b[i2] = (byte)(checksum ^ this.encodeDos33a[i2]);
            checksum = this.encodeDos33a[i2];
            ++i2;
        }
        this.encodeDos33b[342] = checksum;
        i2 = 0;
        while (i2 < 343) {
            encodedBuffer[i2] = this.byteTranslator62.encode(this.encodeDos33b[i2]);
            ++i2;
        }
        return encodedBuffer;
    }

    private static int reverse(int bits) {
        return bits == 1 ? 2 : (bits == 2 ? 1 : bits);
    }

    private String listBytes(byte[] buffer, int offset, int length) {
        StringBuilder text = new StringBuilder();
        int max = Math.min(length + offset, buffer.length);
        while (offset < max) {
            text.append(String.format("%02X ", buffer[offset++]));
        }
        return text.toString();
    }

    static int findBytes(byte[] buffer, int offset, byte[] valueBuffer) {
        while (offset + valueBuffer.length <= buffer.length) {
            if (Nibblizer.matchBytes(buffer, offset, valueBuffer)) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean matchBytes(byte[] buffer, int offset, byte[] valueBuffer) {
        if (buffer.length - offset < valueBuffer.length) {
            return false;
        }
        int ptr = 0;
        try {
            do {
                if (ptr < valueBuffer.length) continue;
                return true;
            } while (buffer[offset++] == valueBuffer[ptr++]);
            return false;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("Error in matchBytes");
            e.printStackTrace();
            return false;
        }
    }

    private class AddressField
    extends Field {
        int track;
        int sector;
        int volume;
        int checksum;

        public AddressField(byte[] buffer, int offset) {
            super(buffer, offset);
            this.volume = Nibblizer.this.decode4and4(buffer, offset + 3);
            this.track = Nibblizer.this.decode4and4(buffer, offset + 5);
            this.sector = Nibblizer.this.decode4and4(buffer, offset + 7);
            this.checksum = Nibblizer.this.decode4and4(buffer, offset + 9);
            this.valid = true;
            this.length = 14;
        }

        @Override
        public String toString() {
            return String.format("[volume: %02X, track: %02X, sector: %02X, checksum: %02X]", this.volume, this.track, this.sector, this.checksum);
        }
    }

    private class DataField
    extends Field {
        byte[] dataBuffer;

        public DataField(byte[] buffer, int offset) {
            super(buffer, offset);
            if (Nibblizer.matchBytes(buffer, offset, dataPrologue)) {
                this.valid = true;
                this.dataBuffer = Nibblizer.this.sectorsPerTrack == 13 ? Nibblizer.this.decode5and3(buffer, offset + 3) : Nibblizer.this.decode6and2(buffer, offset + 3);
            } else {
                System.out.print("   bad data prologue: ");
                System.out.println(Nibblizer.this.listBytes(buffer, offset, 3));
            }
            this.length = 349;
        }
    }

    private abstract class Field {
        protected boolean valid;
        protected byte[] buffer;
        protected int offset;
        protected int length;

        public Field(byte[] buffer, int offset) {
            this.buffer = buffer;
            this.offset = offset;
        }

        public boolean isValid() {
            return this.valid;
        }

        public int size() {
            assert (this.length > 0);
            return this.length;
        }

        public String toString() {
            return String.format("[Offset: %04X, Length: %04X]", this.offset, this.length);
        }
    }
}

