/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.nib;

import com.bytezone.diskbrowser.nib.ByteTranslator;
import com.bytezone.diskbrowser.nib.ByteTranslator6and2;
import com.bytezone.diskbrowser.nib.DiskNibbleException;
import com.bytezone.diskbrowser.nib.DiskReader;

class DiskReaderGCR
extends DiskReader {
    static final int TAG_SIZE = 12;
    private final ByteTranslator byteTranslator = new ByteTranslator6and2();

    DiskReaderGCR() {
        super(0);
    }

    @Override
    byte[] decodeSector(byte[] inBuffer, int inPtr) throws DiskNibbleException {
        byte b2;
        byte d1;
        byte d0;
        byte d3;
        byte[] outBuffer = new byte[524];
        int outPtr = 0;
        int[] checksums = new int[3];
        while (true) {
            checksums[2] = (checksums[2] & 0xFF) << 1;
            if (checksums[2] > 255) {
                checksums[2] = checksums[2] + 1;
            }
            d3 = this.byteTranslator.decode(inBuffer[inPtr++]);
            d0 = this.byteTranslator.decode(inBuffer[inPtr++]);
            d1 = this.byteTranslator.decode(inBuffer[inPtr++]);
            byte b0 = (byte)(d0 | d3 << 2 & 0xC0);
            byte b1 = (byte)(d1 | d3 << 4 & 0xC0);
            outBuffer[outPtr++] = this.checksum(b0, checksums, 0);
            outBuffer[outPtr++] = this.checksum(b1, checksums, 1);
            if (outPtr == outBuffer.length) break;
            byte d2 = this.byteTranslator.decode(inBuffer[inPtr++]);
            b2 = (byte)(d2 | d3 << 6);
            outBuffer[outPtr++] = this.checksum(b2, checksums, 2);
        }
        d3 = this.byteTranslator.decode(inBuffer[inPtr++]);
        d0 = this.byteTranslator.decode(inBuffer[inPtr++]);
        d1 = this.byteTranslator.decode(inBuffer[inPtr++]);
        byte d2 = this.byteTranslator.decode(inBuffer[inPtr++]);
        byte b0 = (byte)(d0 | d3 << 2 & 0xC0);
        byte b1 = (byte)(d1 | d3 << 4 & 0xC0);
        b2 = (byte)(d2 | d3 << 6);
        if ((byte)(checksums[0] & 0xFF) != b0 || (byte)(checksums[1] & 0xFF) != b1 || (byte)(checksums[2] & 0xFF) != b2) {
            throw new DiskNibbleException("Checksum failed");
        }
        return outBuffer;
    }

    private byte checksum(byte diskByte, int[] checksums, int current) {
        int prev = (current + 2) % 3;
        int val = (diskByte ^ checksums[prev]) & 0xFF;
        int n = current;
        checksums[n] = checksums[n] + val;
        if (checksums[prev] > 255) {
            int n2 = current;
            checksums[n2] = checksums[n2] + 1;
            int n3 = prev;
            checksums[n3] = checksums[n3] & 0xFF;
        }
        return (byte)val;
    }

    @Override
    byte[] encodeSector(byte[] buffer) {
        System.out.println("encodeSector() not written");
        return null;
    }
}

