/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.nib;

import com.bytezone.diskbrowser.nib.ByteTranslator;
import com.bytezone.diskbrowser.nib.ByteTranslator5and3;
import com.bytezone.diskbrowser.nib.DiskNibbleException;
import com.bytezone.diskbrowser.nib.DiskReader;

class DiskReader13Sector
extends DiskReader {
    private static final int RAW_BUFFER_SIZE = 410;
    private static final int BUFFER_WITH_CHECKSUM_SIZE = 411;
    private final byte[] decodeA = new byte[411];
    private final byte[] decodeB = new byte[410];
    private final ByteTranslator byteTranslator = new ByteTranslator5and3();

    DiskReader13Sector() {
        super(13);
    }

    @Override
    byte[] decodeSector(byte[] buffer, int offset) throws DiskNibbleException {
        byte[] decodedBuffer = new byte[256];
        int i = 0;
        while (i < 411) {
            this.decodeA[i] = (byte)(this.byteTranslator.decode(buffer[offset++]) << 3);
            ++i;
        }
        byte chk = 0;
        int ptr = 0;
        int i2 = 409;
        while (i2 >= 256) {
            chk = this.decodeB[i2] = (byte)(this.decodeA[ptr++] ^ chk);
            --i2;
        }
        i2 = 0;
        while (i2 < 256) {
            chk = this.decodeB[i2] = (byte)(this.decodeA[ptr++] ^ chk);
            ++i2;
        }
        if ((chk ^ this.decodeA[ptr]) != 0) {
            throw new DiskNibbleException("Checksum failed");
        }
        byte[] k = new byte[8];
        int[] nArray = new int[8];
        nArray[1] = 51;
        nArray[2] = 102;
        nArray[3] = 153;
        nArray[4] = 204;
        nArray[5] = 256;
        nArray[6] = 307;
        nArray[7] = 358;
        int[] lines = nArray;
        ptr = 0;
        int i3 = 50;
        while (i3 >= 0) {
            int j = 0;
            while (j < 8) {
                k[j] = this.decodeB[i3 + lines[j]];
                ++j;
            }
            k[0] = (byte)(k[0] | (k[5] & 0xE0) >>> 5);
            k[1] = (byte)(k[1] | (k[6] & 0xE0) >>> 5);
            k[2] = (byte)(k[2] | (k[7] & 0xE0) >>> 5);
            k[3] = (byte)(k[3] | (k[5] & 0x10) >>> 2);
            k[3] = (byte)(k[3] | (k[6] & 0x10) >>> 3);
            k[3] = (byte)(k[3] | (k[7] & 0x10) >>> 4);
            k[4] = (byte)(k[4] | (k[5] & 8) >>> 1);
            k[4] = (byte)(k[4] | (k[6] & 8) >>> 2);
            k[4] = (byte)(k[4] | (k[7] & 8) >>> 3);
            j = 0;
            while (j < 5) {
                decodedBuffer[ptr++] = k[j];
                ++j;
            }
            --i3;
        }
        decodedBuffer[ptr] = (byte)(this.decodeB[255] | (this.decodeB[409] & 0x3F) >>> 3);
        return decodedBuffer;
    }

    @Override
    byte[] encodeSector(byte[] buffer) {
        System.out.println("encodeSector() not written");
        return null;
    }
}

