/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.nib;

import com.bytezone.diskbrowser.nib.DiskNibbleException;
import com.bytezone.diskbrowser.nib.DiskReader13Sector;
import com.bytezone.diskbrowser.nib.DiskReader16Sector;
import com.bytezone.diskbrowser.nib.DiskReaderGCR;

abstract class DiskReader {
    static final int SECTOR_SIZE = 256;
    static final int BLOCK_SIZE = 512;
    static final byte[] dataPrologue = new byte[]{-43, -86, -83};
    static DiskReader reader13;
    static DiskReader reader16;
    static DiskReader readerGCR;
    final int sectorsPerTrack;

    DiskReader(int sectorsPerTrack) {
        this.sectorsPerTrack = sectorsPerTrack;
    }

    static DiskReader getInstance(int sectors) {
        switch (sectors) {
            case 13: {
                if (reader13 == null) {
                    reader13 = new DiskReader13Sector();
                }
                return reader13;
            }
            case 16: {
                if (reader16 == null) {
                    reader16 = new DiskReader16Sector();
                }
                return reader16;
            }
            case 0: {
                if (readerGCR == null) {
                    readerGCR = new DiskReaderGCR();
                }
                return readerGCR;
            }
        }
        return null;
    }

    byte[] decodeSector(byte[] buffer) throws DiskNibbleException {
        return this.decodeSector(buffer, 0);
    }

    static int reverse(int bits) {
        return bits == 1 ? 2 : (bits == 2 ? 1 : bits);
    }

    abstract byte[] decodeSector(byte[] var1, int var2) throws DiskNibbleException;

    abstract byte[] encodeSector(byte[] var1);
}

