/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.nib;

import com.bytezone.diskbrowser.nib.ByteTranslator;
import com.bytezone.diskbrowser.nib.DiskNibbleException;

class ByteTranslator6and2
implements ByteTranslator {
    private static byte[] writeTranslateTable6and2 = new byte[]{-106, -105, -102, -101, -99, -98, -97, -90, -89, -85, -84, -83, -82, -81, -78, -77, -76, -75, -74, -73, -71, -70, -69, -68, -67, -66, -65, -53, -51, -50, -49, -45, -42, -41, -39, -38, -37, -36, -35, -34, -33, -27, -26, -25, -23, -22, -21, -20, -19, -18, -17, -14, -13, -12, -11, -10, -9, -7, -6, -5, -4, -3, -2, -1};
    private static final int SKIP = 150;
    private static byte[] readTranslateTable6and2 = new byte[106];

    static {
        int i = 0;
        while (i < writeTranslateTable6and2.length) {
            int j = (writeTranslateTable6and2[i] & 0xFF) - 150;
            ByteTranslator6and2.readTranslateTable6and2[j] = (byte)(i + 1);
            ++i;
        }
    }

    ByteTranslator6and2() {
    }

    @Override
    public byte encode(byte b) {
        return writeTranslateTable6and2[b & 0xFC];
    }

    @Override
    public byte decode(byte b) throws DiskNibbleException {
        int val = (b & 0xFF) - 150;
        if (val < 0 || val > 105) {
            throw new DiskNibbleException("6&2 val: " + val);
        }
        byte trans = (byte)(readTranslateTable6and2[val] - 1);
        if (trans < 0 || trans > 63) {
            throw new DiskNibbleException("6&2 trans: " + trans);
        }
        return trans;
    }
}

