/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.nib;

import com.bytezone.diskbrowser.nib.ByteTranslator;
import com.bytezone.diskbrowser.nib.DiskNibbleException;

class ByteTranslator5and3
implements ByteTranslator {
    private static byte[] writeTranslateTable5and3 = new byte[]{-85, -83, -82, -81, -75, -74, -73, -70, -69, -67, -66, -65, -42, -41, -38, -37, -35, -34, -33, -22, -21, -19, -18, -17, -11, -10, -9, -6, -5, -3, -2, -1};
    private static final int SKIP = 171;
    private static byte[] readTranslateTable5and3 = new byte[85];
    private static boolean debug = false;

    static {
        int i = 0;
        while (i < writeTranslateTable5and3.length) {
            int j = (writeTranslateTable5and3[i] & 0xFF) - 171;
            ByteTranslator5and3.readTranslateTable5and3[j] = (byte)(i + 1);
            if (debug) {
                System.out.printf("%02X  %02X  %02X%n", i, writeTranslateTable5and3[i], j);
            }
            ++i;
        }
        if (debug) {
            int j = 0;
            while (j < readTranslateTable5and3.length) {
                int target = readTranslateTable5and3[j] - 1;
                if (target >= 0) {
                    int value = writeTranslateTable5and3[target] & 0xFF;
                    System.out.printf("%02X -> %02X%n", j, value);
                } else {
                    System.out.printf("%02X%n", j);
                }
                ++j;
            }
        }
    }

    ByteTranslator5and3() {
    }

    @Override
    public byte encode(byte b) {
        System.out.println("encode() not written");
        return 0;
    }

    @Override
    public byte decode(byte b) throws DiskNibbleException {
        int val = (b & 0xFF) - 171;
        if (val < 0 || val > 84) {
            throw new DiskNibbleException("5&3 val: " + val);
        }
        byte trans = (byte)(readTranslateTable5and3[val] - 1);
        if (trans < 0 || trans > 31) {
            throw new DiskNibbleException("5&3 trans: " + trans);
        }
        return trans;
    }
}

