/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.infocom;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.infocom.Header;
import com.bytezone.diskbrowser.infocom.ZString;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import java.util.Map;
import java.util.TreeMap;

class StringManager
extends AbstractFile {
    Header header;
    Map<Integer, ZString> strings = new TreeMap<Integer, ZString>();

    StringManager(String name, byte[] buffer, Header header) {
        super(name, buffer);
        this.header = header;
        int ptr = header.stringPointer;
        int max = header.fileLength;
        while (ptr < max) {
            ZString zs = new ZString(header, ptr);
            if (zs.value == null) break;
            this.strings.put(ptr, zs);
            ptr += zs.length;
        }
    }

    public boolean containsStringAt(int address) {
        return this.strings.containsKey(address);
    }

    public String stringAt(int address) {
        if (this.strings.containsKey(address)) {
            return this.strings.get((Object)Integer.valueOf((int)address)).value;
        }
        return "String not found at : " + address;
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        int count = 0;
        text.append("  #  Start  String\n");
        text.append("---  -----  ---------------------------------------------------------------------------\n");
        for (ZString s : this.strings.values()) {
            String s2 = s.value.replace("\n", "\n             ");
            text.append(String.format("%3d  %05X  \"%s\"%n", ++count, s.startPtr, s2));
        }
        if (text.length() > 0) {
            text.deleteCharAt(text.length() - 1);
        }
        return text.toString();
    }

    @Override
    public String getHexDump() {
        int size = this.header.fileLength - this.header.stringPointer;
        return HexFormatter.format(this.buffer, this.header.stringPointer, size);
    }
}

